<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class TherapistCategoriesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('therapist_categories')->delete();
        
        \DB::table('therapist_categories')->insert(array (
            0 => 
            array (
                'created_at' => '2023-08-03 14:10:55',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Animal therapy, also known as animal rights therapy or animal welfare therapy, is a specialized area of therapy that addresses legal issues related to animals. It encompasses a wide range of topics, including the protection and welfare of animals, animal rights, animal cruelty, conservation, and the legal status of animals as sentient beings.<\\/p>\\r\\n\\r\\n<p>Key Aspects of Animal Therapy:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Animal Cruelty and Welfare: Animal therapy includes therapys and regulations that protect animals from cruelty and abuse. This involves criminal penalties for acts of animal cruelty, neglect, or abandonment. It also covers therapys regarding the proper care and treatment of animals kept in captivity, such as in zoos, farms, and research facilities.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Rights: Animal therapy seeks to address the legal status of animals as sentient beings capable of experiencing pain and suffering. Advocates of animal rights seek to expand legal protections for animals, recognizing their intrinsic value and right to be free from harm and exploitation.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Companion Animals: Legal issues related to pets, such as dogs, cats, and other domestic animals, are an important aspect of animal therapy. This includes therapys concerning pet ownership, pet custody in divorce cases, and pet-related contracts and agreements.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Wildlife Protection: Animal therapy covers therapys and regulations aimed at protecting wildlife, endangered species, and their natural habitats. This involves regulations on hunting, trapping, and conservation efforts to preserve biodiversity.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Testing and Research: Animal therapy addresses the use of animals in scientific research and experimentation. It includes regulations on animal testing, alternatives to animal testing, and ethical considerations in animal research.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Agriculture: Legal issues related to animal agriculture involve regulations on factory farming, animal husbandry practices, and the treatment of livestock animals. Animal therapy also covers therapys regarding the transportation and slaughter of animals for food.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Rescue and Shelter Therapy: This aspect of animal therapy pertains to the legal rights and responsibilities of animal rescue organizations and animal shelters. It includes regulations on animal adoptions, fostering, and the handling of stray animals.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Advocacy and Lobbying: Animal therapy involves advocacy efforts to promote animal welfare and rights through lobbying, litigation, and public awareness campaigns.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Legal Status of Animals: Animal therapy debates the legal status of animals as property or sentient beings with legal rights. Some jurisdictions have recognized animals as &quot;legal persons&quot; in specific contexts, affording them certain protections under the therapy.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>International Animal Therapy: Animal therapy is not limited to individual countries; there are also international efforts to address global animal welfare and conservation issues through treaties and agreements.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Animal therapy is a rapidly growing area of legal practice, driven by increasing public awareness and concern for animal welfare. Advocates and legal professionals in this field work to strengthen legal protections for animals, promote responsible animal ownership, and ensure that animals are treated with compassion and respect within society.<\\/p>","hi":"<p>\\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928, \\u091c\\u093f\\u0938\\u0947 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092d\\u0940 \\u0915\\u0939\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u090f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0940 \\u0936\\u093e\\u0916\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0938\\u093e\\u092e\\u0917\\u094d\\u0930\\u0940 \\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u092e\\u093e\\u0923, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0907\\u0938\\u0915\\u093e \\u092e\\u0941\\u0916\\u094d\\u092f \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u092f\\u0939 \\u0939\\u0948 \\u0915\\u093f \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0938\\u0924\\u094d\\u092f, \\u0928\\u094d\\u092f\\u093e\\u092f\\u0938\\u0902\\u0917\\u0924 \\u0914\\u0930 \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092d\\u094d\\u0930\\u092e\\u093f\\u0924 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0928\\u0947 \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0947\\u0902 \\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0914\\u0930 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0927\\u093e\\u0930\\u093e\\u090f\\u0901, \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0914\\u0930 \\u0926\\u093f\\u0936\\u093e\\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n<p>\\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u092e\\u0947\\u0902 \\u0938\\u0924\\u094d\\u092f\\u0924\\u093e: \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u092e\\u094c\\u0932\\u093f\\u0915 \\u0938\\u093f\\u0926\\u094d\\u0927\\u093e\\u0902\\u0924 \\u0939\\u0948 \\u0915\\u093f \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0938\\u091a\\u094d\\u091a\\u093e \\u0914\\u0930 \\u092d\\u094d\\u0930\\u092e\\u093f\\u0924 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u094b\\u0928\\u093e \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u092f\\u093e \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0938\\u091f\\u0940\\u0915 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u092f\\u094b\\u0917\\u094d\\u092f \\u0914\\u0930 \\u0917\\u0932\\u0924 \\u092f\\u093e \\u092d\\u094d\\u0930\\u093e\\u092e\\u0915 \\u0926\\u093e\\u0935\\u0947 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0941\\u0937\\u094d\\u091f\\u093f: \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0915\\u0940 \\u0917\\u0908 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0926\\u093e\\u0935\\u0947 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092f\\u094b\\u0917\\u094d\\u092f \\u0938\\u092c\\u0942\\u0924 \\u092f\\u093e \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0939\\u094b\\u0928\\u0940 \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964 \\u0907\\u0938\\u0915\\u093e \\u092e\\u0924\\u0932\\u092c \\u0939\\u0948 \\u0915\\u093f \\u092f\\u0926\\u093f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u094b, \\u0924\\u094b \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u0915\\u0925\\u0928\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0924\\u094d\\u092f\\u0924\\u093e \\u0938\\u093f\\u0926\\u094d\\u0927 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0915\\u094d\\u0937\\u092e \\u0939\\u094b\\u0928\\u093e \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0924\\u0941\\u0932\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928: \\u0924\\u0941\\u0932\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u090f\\u0915 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926 \\u092f\\u093e \\u0938\\u0947\\u0935\\u093e \\u0915\\u094b \\u0926\\u0942\\u0938\\u0930\\u0947 \\u0938\\u0947 \\u0924\\u0941\\u0932\\u0928\\u093e \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u092c\\u0939\\u0941\\u0924 \\u0938\\u0947 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u0928\\u0941\\u092e\\u0924 \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0902\\u0915\\u093f, \\u0907\\u0938 \\u0924\\u0930\\u0939 \\u0915\\u0940 \\u0924\\u0941\\u0932\\u0928\\u093e\\u090f\\u0901 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u0907\\u0938\\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0928\\u093f\\u092f\\u092e \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u092f\\u0947 \\u092f\\u0925\\u093e\\u0930\\u094d\\u0925 \\u0914\\u0930 \\u092d\\u094d\\u0930\\u093e\\u092e\\u0915 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u094b\\u0928\\u0940 \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092e\\u093e\\u0923: \\u092f\\u0926\\u093f \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u092e\\u0947\\u0902 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u093f\\u092b\\u093e\\u0930\\u093f\\u0936\\u0947\\u0902 \\u092f\\u093e \\u092a\\u094d\\u0930\\u092e\\u093e\\u0923 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0935\\u0947 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0914\\u0930 \\u0909\\u0928\\u0915\\u0947 \\u0938\\u093f\\u0926\\u094d\\u0927\\u093e\\u0902\\u0924\\u093f\\u092f\\u094b\\u0902 \\u092f\\u093e \\u0905\\u0928\\u0941\\u092d\\u0935\\u094b\\u0902 \\u0915\\u093e \\u0908\\u092e\\u093e\\u0928\\u0926\\u093e\\u0930 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0939\\u094b\\u0928\\u0940 \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964 \\u0938\\u093f\\u092b\\u093e\\u0930\\u093f\\u0936 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0915 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0935\\u0938\\u094d\\u0924\\u0941\\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0915\\u093e \\u0916\\u0941\\u0932\\u093e\\u0938\\u093e \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0928\\u093e \\u091a\\u093e\\u0939\\u093f\\u090f\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e: \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0926\\u0930\\u094d\\u0936\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0914\\u0930 \\u0932\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0915\\u0947 \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u092e\\u0947\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092c\\u091a\\u094d\\u091a\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928: \\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u094b \\u0932\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928\\u094b\\u0902 \\u092a\\u0930 \\u0909\\u0928\\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0936\\u0930\\u093e\\u092c, \\u0924\\u092e\\u094d\\u092c\\u093e\\u0915\\u0942 \\u0914\\u0930 \\u092a\\u0930\\u094d\\u091a\\u0947 \\u0926\\u0935\\u093e\\u0913\\u0902: \\u0915\\u0941\\u091b \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u091c\\u0948\\u0938\\u0947 \\u0936\\u0930\\u093e\\u092c, \\u0924\\u092e\\u094d\\u092c\\u093e\\u0915\\u0942 \\u0914\\u0930 \\u092a\\u0930\\u094d\\u091a\\u0947 \\u0926\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u094b \\u0939\\u093e\\u0928\\u093f \\u0914\\u0930 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u0936\\u0947\\u0937 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092c\\u0902\\u0927 \\u0914\\u0930 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u090f\\u0901 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092e\\u093e\\u0928\\u0935\\u0940\\u092f \\u0938\\u0902\\u0938\\u094d\\u092a\\u0926: \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0940 \\u090f\\u0915 \\u0913\\u0930 \\u0938\\u0902\\u0938\\u094d\\u092a\\u0926 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923, \\u091c\\u0948\\u0938\\u0947 \\u0915\\u093f \\u091f\\u094d\\u0930\\u0947\\u0921\\u092e\\u093e\\u0930\\u094d\\u0915, \\u0915\\u0949\\u092a\\u0940\\u0930\\u093e\\u0907\\u091f \\u0914\\u0930 \\u092a\\u0947\\u091f\\u0947\\u0902\\u091f\\u094d\\u0938, \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0902\\u0938\\u094d\\u092a\\u0926 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923 \\u0915\\u094b \\u0926\\u0930\\u094d\\u0936\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0915\\u094b\\u0902 \\u0915\\u094b \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u091a\\u093e\\u0939\\u093f\\u090f \\u0915\\u093f \\u0909\\u0928\\u0915\\u0947 \\u092a\\u093e\\u0938 \\u0909\\u0928\\u0915\\u0947 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0915\\u094b\\u0908 \\u0915\\u0949\\u092a\\u0940\\u0930\\u093e\\u0907\\u091f \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092f\\u093e \\u091f\\u094d\\u0930\\u0947\\u0921\\u092e\\u093e\\u0930\\u094d\\u0915 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0938\\u0902\\u0918\\u091f\\u0928 (FTC) \\u0926\\u093f\\u0936\\u093e\\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936: \\u0938\\u0902\\u0918\\u091f\\u0928 (FTC) \\u0928\\u0947 \\u0938\\u0902\\u0918\\u091f\\u0928 \\u0915\\u0947 \\u0916\\u093f\\u0932\\u093e\\u092b \\u092f\\u093e \\u0928\\u094d\\u092f\\u093e\\u092f\\u0938\\u0902\\u0917\\u0924 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u092a\\u094d\\u0930\\u0925\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0916\\u093f\\u0932\\u093e\\u092b \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936 \\u091c\\u093e\\u0930\\u0940 \\u0915\\u093f\\u090f \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0914\\u0930 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901: \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u090f\\u0915 \\u0926\\u0947\\u0936 \\u0938\\u0947 \\u0926\\u0942\\u0938\\u0930\\u0947 \\u0926\\u0947\\u0936 \\u0924\\u0915 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0917\\u0948\\u0930-\\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0938\\u0902\\u0917\\u0920\\u0928 \\u091c\\u0948\\u0938\\u0947 \\u0915\\u093f \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930 \\u092e\\u0939\\u093e\\u0938\\u092d\\u093e (ICC) \\u0928\\u0947 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u0947 \\u0926\\u093f\\u0936\\u093e\\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936 \\u0924\\u0948\\u092f\\u093e\\u0930 \\u0915\\u093f\\u090f \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u092a\\u094d\\u0930\\u0925\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u090f\\u0915\\u0924\\u093e \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928: \\u0921\\u093f\\u091c\\u093f\\u091f\\u0932 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0915\\u0940 \\u092c\\u0922\\u093c\\u0924\\u0940 \\u0938\\u0940\\u092e\\u093e \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928\\u094b\\u0902 \\u092a\\u0930 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0928\\u093f\\u092f\\u092e \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0938\\u0902\\u0935\\u093f\\u0926\\u093e\\u0928\\u0936\\u0940\\u0932\\u0924\\u093e \\u0914\\u0930 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u093e\\u092e\\u0917\\u094d\\u0930\\u0940 \\u0915\\u093e \\u0921\\u0947\\u091f\\u093e \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939\\u0923 \\u0938\\u0939\\u093f\\u0924 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u090f\\u0901 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928 \\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0915\\u0908 \\u0905\\u092a\\u0930\\u093e\\u0927\\u093f\\u0915 \\u0914\\u0930 \\u0928\\u0941\\u0915\\u0938\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u092a\\u0930\\u093f\\u0923\\u093e\\u092e \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0907\\u0938\\u0932\\u093f\\u090f \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0915\\u094b\\u0902 \\u0915\\u094b \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0909\\u0928\\u0915\\u0947 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u092a\\u094d\\u0930\\u0925\\u093e\\u090f\\u0901 \\u0909\\u0928\\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0932\\u093e\\u0939 \\u0932\\u0947\\u0928\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u092a\\u094d\\u0930\\u093e\\u0927\\u093f\\u0915\\u0930\\u0923\\u094b\\u0902 \\u0938\\u0947 \\u092a\\u0930\\u093e\\u092e\\u0930\\u094d\\u0936 \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0940 \\u091c\\u091f\\u093f\\u0932\\u0924\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u092e\\u093f\\u0932 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948 \\u0914\\u0930 \\u0938\\u092d\\u0940 \\u0932\\u093e\\u0917\\u0942 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u093e \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a\\u060c \\u0627\\u0644\\u0645\\u0639\\u0631\\u0648\\u0641 \\u0623\\u064a\\u0636\\u0627\\u064b \\u0628\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642\\u060c \\u0647\\u0648 \\u0641\\u0631\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u064a\\u062d\\u0643\\u0645 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0645\\u0648\\u0627\\u062f \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642. \\u0627\\u0644\\u0647\\u062f\\u0641 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a \\u0645\\u0646\\u0647 \\u0647\\u0648 \\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0635\\u0627\\u062f\\u0642\\u0629 \\u0648\\u0639\\u0627\\u062f\\u0644\\u0629 \\u0648\\u063a\\u064a\\u0631 \\u0645\\u0636\\u0644\\u0644\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643\\u064a\\u0646. \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0648\\u0627\\u0644\\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062f\\u0648\\u0644\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0648\\u0644\\u064a.<\\/p>\\r\\n<p>\\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0635\\u062f\\u0642 \\u0641\\u064a \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a: \\u0627\\u0644\\u0645\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a \\u0641\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0647\\u0648 \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646 \\u0635\\u0627\\u062f\\u0642\\u064b\\u0627 \\u0648\\u063a\\u064a\\u0631 \\u0645\\u0636\\u0644\\u0644. \\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0646\\u064a\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u062f\\u0642\\u064a\\u0642\\u0629 \\u062d\\u0648\\u0644 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u0647\\u0645 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0647\\u0645 \\u0648\\u062a\\u062c\\u0646\\u0628 \\u0625\\u062f\\u0644\\u0627\\u0621 \\u0628\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0643\\u0627\\u0630\\u0628\\u0629 \\u0623\\u0648 \\u0645\\u0636\\u0644\\u0644\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062f\\u0639\\u0645: \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u0644\\u062f\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0646\\u064a\\u0646 \\u062f\\u0644\\u0627\\u0626\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644\\u0629 \\u0623\\u0648 \\u062f\\u0639\\u0645 \\u0644\\u062f\\u0639\\u0645 \\u0623\\u064a \\u0645\\u0637\\u0627\\u0644\\u0628\\u0627\\u062a \\u064a\\u0642\\u062f\\u0645\\u0648\\u0646\\u0647\\u0627 \\u0641\\u064a \\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a\\u0647\\u0645. \\u0648\\u0647\\u0630\\u0627 \\u064a\\u0639\\u0646\\u064a \\u0623\\u0646\\u0647\\u0645 \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646\\u0648\\u0627 \\u0642\\u0627\\u062f\\u0631\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0625\\u062b\\u0628\\u0627\\u062a \\u0635\\u062d\\u0629 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0647\\u0645 \\u0625\\u0630\\u0627 \\u0644\\u0632\\u0645 \\u0627\\u0644\\u0623\\u0645\\u0631.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646 \\u0627\\u0644\\u062a\\u0641\\u0636\\u064a\\u0644\\u064a: \\u064a\\u064f\\u0633\\u0645\\u062d \\u0641\\u064a \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0642\\u0627\\u062a \\u0628\\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646 \\u0627\\u0644\\u062a\\u0641\\u0636\\u064a\\u0644\\u064a \\u0627\\u0644\\u0630\\u064a \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0645\\u0642\\u0627\\u0631\\u0646\\u0629 \\u0645\\u0646\\u062a\\u062c \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0629 \\u0628\\u0623\\u062e\\u0631\\u0649. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0647\\u0646\\u0627\\u0643 \\u0642\\u0648\\u0627\\u0639\\u062f \\u062a\\u062d\\u0643\\u0645 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0645\\u062b\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u0642\\u0627\\u0631\\u0646\\u0627\\u062a\\u060c \\u0648\\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u062f\\u0642\\u064a\\u0642\\u0629 \\u0648\\u063a\\u064a\\u0631 \\u0645\\u0636\\u0644\\u0644\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0634\\u0647\\u0627\\u062f\\u0627\\u062a: \\u0625\\u0630\\u0627 \\u062a\\u0636\\u0645\\u0646\\u062a \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u062a\\u0648\\u0635\\u064a\\u0627\\u062a \\u0623\\u0648 \\u0634\\u0647\\u0627\\u062f\\u0627\\u062a \\u0645\\u0646 \\u0623\\u0641\\u0631\\u0627\\u062f\\u060c \\u064a\\u062c\\u0628 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u062d\\u0642\\u064a\\u0642\\u064a\\u0629 \\u0648\\u062a\\u0639\\u0643\\u0633 \\u0622\\u0631\\u0627\\u0621\\u0647\\u0645 \\u0627\\u0644\\u0635\\u0627\\u062f\\u0642\\u0629 \\u0623\\u0648 \\u062a\\u062c\\u0627\\u0631\\u0628\\u0647\\u0645. \\u064a\\u062c\\u0628 \\u0627\\u0644\\u0643\\u0634\\u0641 \\u0639\\u0646 \\u0623\\u064a \\u0639\\u0644\\u0627\\u0642\\u0629 \\u0645\\u0627\\u062f\\u064a\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0635\\u064a \\u0628\\u0647 \\u0648\\u0627\\u0644\\u0645\\u0639\\u0644\\u0646.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a: \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0623\\u064a\\u0636\\u0627\\u064b \\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643\\u064a\\u0646 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u060c \\u062e\\u0627\\u0635\\u0629 \\u0641\\u064a\\u0645\\u0627 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0648\\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u062f\\u0641.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644 \\u0648\\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a: \\u063a\\u0627\\u0644\\u0628\\u0627\\u064b \\u0645\\u0627 \\u062a\\u0646\\u0637\\u0628\\u0642 \\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u062e\\u0627\\u0635\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0633\\u062a\\u0647\\u062f\\u0641 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644 \\u0644\\u062d\\u0645\\u0627\\u064a\\u062a\\u0647\\u0645 \\u0645\\u0646 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0644\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0636\\u0644\\u0644\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0643\\u062d\\u0648\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0628\\u063a \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0641\\u064a\\u0629: \\u062a\\u062e\\u0636\\u0639 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0644\\u0628\\u0639\\u0636 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0645\\u062b\\u0644 \\u0627\\u0644\\u0643\\u062d\\u0648\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0628\\u063a \\u0648\\u0627\\u0644\\u0623\\u062f\\u0648\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0641\\u064a\\u0629 \\u0644\\u0642\\u064a\\u0648\\u062f \\u0648\\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0644\\u0645\\u0646\\u0639 \\u0627\\u0644\\u0636\\u0631\\u0631 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629: \\u064a\\u062a\\u0642\\u0627\\u0637\\u0639 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0645\\u0639 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0648\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0646\\u0634\\u0631 \\u0648\\u0628\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0627\\u062e\\u062a\\u0631\\u0627\\u0639. \\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0646\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0646 \\u0644\\u062f\\u064a\\u0647\\u0645 \\u0627\\u0644\\u062d\\u0642 \\u0641\\u064a \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0623\\u064a \\u0645\\u0648\\u0627\\u062f \\u0645\\u062d\\u0645\\u064a\\u0629 \\u0628\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0646\\u0634\\u0631 \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0641\\u064a \\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a\\u0647\\u0645.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0647\\u064a\\u0626\\u0629 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 (FTC): \\u0641\\u064a \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u062d\\u062f\\u0629\\u060c \\u062a\\u0644\\u0639\\u0628 \\u0647\\u064a\\u0626\\u0629 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 \\u062f\\u0648\\u0631\\u0627\\u064b \\u0647\\u0627\\u0645\\u0627\\u064b \\u0641\\u064a \\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a. \\u062a\\u0635\\u062f\\u0631 \\u0647\\u064a\\u0626\\u0629 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 \\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0648\\u062a\\u062a\\u062e\\u0630 \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u062a\\u0646\\u0641\\u064a\\u0630\\u064a\\u0629 \\u0636\\u062f \\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u062f\\u0639\\u0629 \\u0623\\u0648 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0644\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0648\\u0637\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629: \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0628\\u0634\\u0643\\u0644 \\u0643\\u0628\\u064a\\u0631 \\u0645\\u0646 \\u062f\\u0648\\u0644\\u0629 \\u0625\\u0644\\u0649 \\u0623\\u062e\\u0631\\u0649. \\u0648\\u0647\\u0646\\u0627\\u0643 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0645\\u0646\\u0638\\u0645\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629 \\u0645\\u062b\\u0644 \\u063a\\u0631\\u0641\\u0629 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629 (ICC) \\u0627\\u0644\\u062a\\u064a \\u0648\\u0636\\u0639\\u062a \\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0644\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u0629 \\u0644\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062a\\u0648\\u062d\\u064a\\u062f \\u0641\\u064a \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a: \\u0645\\u0639 \\u0627\\u0631\\u062a\\u0641\\u0627\\u0639 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u060c \\u062a\\u0646\\u0637\\u0628\\u0642 \\u0642\\u0648\\u0627\\u0639\\u062f \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u0643\\u0634\\u0641 \\u0639\\u0646 \\u0627\\u0644\\u0645\\u062d\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0631\\u0627\\u0639\\u064a \\u0648\\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a\\u060c \\u0641\\u0636\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0642\\u0648\\u0627\\u0639\\u062f \\u062a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0627\\u0644\\u0627\\u0633\\u062a\\u0647\\u062f\\u0627\\u0641 \\u0627\\u0644\\u0633\\u0644\\u0648\\u0643\\u064a \\u0648\\u062c\\u0645\\u0639 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0639\\u062f\\u0645 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u064a\\u0624\\u062f\\u064a \\u0625\\u0644\\u0649 \\u0639\\u0648\\u0627\\u0642\\u0628 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629\\u060c \\u0648\\u063a\\u0631\\u0627\\u0645\\u0627\\u062a\\u060c \\u0648\\u0636\\u0631\\u0631 \\u0644\\u0633\\u0645\\u0639\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629. \\u0644\\u0630\\u0644\\u0643\\u060c \\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0639\\u0644\\u0646\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0646 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a\\u0647\\u0645 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u064a\\u0629 \\u062a\\u062a\\u0648\\u0627\\u0641\\u0642 \\u0645\\u0639 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0630\\u0627\\u062a \\u0627\\u0644\\u0635\\u0644\\u0629 \\u0641\\u064a \\u0627\\u062e\\u062a\\u0635\\u0627\\u0635\\u0627\\u062a\\u0647\\u0645. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u064a\\u0633\\u0627\\u0639\\u062f \\u0627\\u0644\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0627\\u0644\\u0645\\u0634\\u0648\\u0631\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0634\\u0627\\u0648\\u0631 \\u0645\\u0639 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u0631\\u0642\\u0627\\u0628\\u064a\\u0629 \\u0644\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0646\\u0642\\u0644 \\u0641\\u064a \\u062a\\u0639\\u0642\\u064a\\u062f\\u0627\\u062a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u0642\\u0627\\u0628\\u0644\\u0629 \\u0644\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642.<\\/p>"}',
                'icon' => NULL,
                'id' => 1,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Advertising Therapy","hi":"\\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646"}',
                'parent_category_id' => 1,
                'slug' => 'advertising-therapy-1',
                'updated_at' => '2023-10-11 17:30:57',
            ),
            1 => 
            array (
                'created_at' => '2023-08-03 14:12:28',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Agriculture therapy, also known as agricultural therapy or agribusiness therapy, encompasses a diverse set of legal principles and regulations that govern the agricultural industry and related activities. It is a specialized area of therapy that addresses the unique legal issues and challenges faced by farmers, ranchers, agricultural businesses, and other stakeholders involved in agricultural production and distribution.<\\/p>\\r\\n\\r\\n<p>Key Aspects of Agriculture Therapy:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Agricultural Contracts: Agriculture therapy includes the negotiation, drafting, and enforcement of contracts related to the buying and selling of agricultural products, equipment, and services. These contracts may cover the sale of crops, livestock, farm machinery, leasing of land, and various other agricultural transactions.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Farm and Land Management: Legal issues related to land use, zoning, water rights, environmental regulations, and conservation are significant aspects of agriculture therapy. Attorneys specializing in agriculture therapy advise clients on compliance with land use regulations, water usage rights, and the protection of natural resources.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Agricultural Commodities and Marketing: Therapys governing the marketing and sale of agricultural commodities, such as grains, fruits, vegetables, and livestock, are an essential part of agriculture therapy. These therapys often involve price regulations, grading standards, and marketing orders.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Environmental Regulations: Agriculture therapy addresses the environmental impacts of agricultural activities, including soil conservation, water quality, air pollution, and waste management. Compliance with environmental regulations is crucial to maintaining sustainability in agricultural practices.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Farm Labor and Employment: Agriculture therapy covers labor and employment issues in the agricultural sector, including employment contracts, immigration therapys related to seasonal workers, and compliance with labor standards.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Food Safety and Inspection: Agriculture therapy plays a vital role in ensuring food safety and quality. It involves regulations on food labeling, inspection of food processing facilities, and compliance with health and safety standards for agricultural products.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Agricultural Subsidies and Government Programs: Governments often provide subsidies and financial support to farmers and agricultural businesses. Agriculture therapy deals with the legal aspects of government programs, grants, and subsidies available to the agricultural industry.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Agricultural Intellectual Property: Intellectual property protection for new plant varieties (plant patents), genetically modified organisms (GMOs), and agricultural technologies is addressed within agriculture therapy.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Agricultural Finance and Banking: Agriculture therapy encompasses financial aspects, such as agricultural loans, farm credit, and bankruptcy proceedings for distressed agricultural businesses.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Estate Planning and Succession: Attorneys specializing in agriculture therapy assist farmers in estate planning and business succession to ensure a smooth transition of agricultural assets to the next generation.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Given the complex and evolving nature of agriculture therapy, attorneys specializing in this area often work closely with agricultural experts, government agencies, and industry organizations to provide comprehensive legal counsel and representation to clients in the agricultural sector. The goal is to help farmers and agribusinesses navigate legal challenges, adhere to regulations, and achieve sustainable and profitable agricultural practices.<\\/p>","hi":"<p>\\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928, \\u091c\\u093f\\u0938\\u0947 \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092f\\u093e \\u0915\\u0943\\u0937\\u093f\\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092d\\u0940 \\u0915\\u0939\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u092f\\u0939 \\u0915\\u0943\\u0937\\u093f \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u0914\\u0930 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u093f\\u0926\\u094d\\u0927\\u093e\\u0902\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u090f\\u0915 \\u0935\\u093f\\u0935\\u093f\\u0927 \\u0938\\u092e\\u0942\\u0939 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u090f\\u0915 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0939\\u0948 \\u091c\\u094b \\u0915\\u093f\\u0938\\u093e\\u0928\\u094b\\u0902, \\u092a\\u0936\\u0941\\u092a\\u093e\\u0932\\u0915\\u094b\\u0902, \\u0915\\u0943\\u0937\\u093f \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u094d\\u0924\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0939\\u093f\\u0924\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u091c\\u0941\\u0921\\u093c\\u0947 \\u0915\\u093f\\u0938\\u093e\\u0928\\u094b\\u0902, \\u092a\\u0936\\u0941\\u092a\\u093e\\u0932\\u0915\\u094b\\u0902, \\u0915\\u0943\\u0937\\u093f \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0939\\u093f\\u0924\\u0927\\u093e\\u0930\\u0915\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0915\\u093f\\u090f \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u0943\\u0937\\u093f \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0924\\u0930\\u0923 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0914\\u0930 \\u091a\\u0941\\u0928\\u094c\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n<p>\\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092e\\u0941\\u0916\\u094d\\u092f \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0915\\u0943\\u0937\\u093f \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947: \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u094d\\u0930\\u092e\\u0936: \\u0915\\u0943\\u0937\\u093f \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902, \\u0909\\u092a\\u0915\\u0930\\u0923\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0916\\u0930\\u0940\\u0926\\u0926\\u093e\\u0930\\u0940 \\u0914\\u0930 \\u092c\\u0947\\u091a\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u0915\\u0947 \\u092a\\u0930\\u093f\\u091a\\u092f, \\u0921\\u094d\\u0930\\u093e\\u092b\\u094d\\u091f\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u092a\\u0942\\u0930\\u094d\\u0935\\u093e\\u0930\\u094d\\u091c\\u093f\\u0924\\u093f \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0964 \\u092f\\u0947 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u092b\\u0938\\u0932\\u094b\\u0902, \\u092a\\u0936\\u0941, \\u0915\\u0943\\u0937\\u093f \\u092e\\u0936\\u0940\\u0928\\u0930\\u0940 \\u0915\\u0940 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940, \\u091c\\u093c\\u092e\\u0940\\u0928 \\u0915\\u0940 \\u0932\\u0940\\u091c\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0905\\u0928\\u094d\\u092f \\u0915\\u0943\\u0937\\u093f \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0915\\u0935\\u0930 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0916\\u0947\\u0924 \\u0914\\u0930 \\u092d\\u0942\\u092e\\u093f \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928: \\u092d\\u0942\\u092e\\u093f \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917, \\u091c\\u094b\\u0928\\u093f\\u0902\\u0917, \\u091c\\u0932 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930, \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0932\\u0948\\u0902\\u0921 \\u092f\\u0942\\u091c \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902, \\u091c\\u0932 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0906\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928, \\u0914\\u0930 \\u092a\\u094d\\u0930\\u093e\\u0915\\u0943\\u0924\\u093f\\u0915 \\u0938\\u0902\\u0938\\u093e\\u0927\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u0923 \\u092a\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0932\\u093e\\u0939 \\u0915\\u0940 \\u0926\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0915\\u0943\\u0937\\u093f \\u0935\\u0938\\u094d\\u0924\\u094d\\u0930 \\u0914\\u0930 \\u0935\\u093f\\u092a\\u0923\\u0928: \\u0905\\u0928\\u093e\\u091c, \\u092b\\u0932, \\u0938\\u092c\\u094d\\u091c\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u091c\\u0948\\u0938\\u0947 \\u0915\\u0943\\u0937\\u093f \\u0935\\u0938\\u094d\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0914\\u0930 \\u092c\\u093e\\u091c\\u093e\\u0930 \\u092e\\u0947\\u0902 \\u092c\\u0947\\u091a\\u0928\\u0947 \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u090f\\u0915 \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u093f\\u0938\\u094d\\u0938\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u092e\\u0942\\u0932\\u094d\\u092f \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928, \\u0917\\u094d\\u0930\\u0947\\u0921\\u093f\\u0902\\u0917 \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0906\\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901: \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0909\\u092a\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923\\u0940\\u092f \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u094b\\u0902, \\u091c\\u0948\\u0938\\u0947 \\u0915\\u093f \\u092e\\u0943\\u0926\\u093e \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923, \\u091c\\u0932 \\u0917\\u0941\\u0923\\u0935\\u0924\\u094d\\u0924\\u093e, \\u0935\\u093e\\u092f\\u0941 \\u092a\\u094d\\u0930\\u0926\\u0942\\u0937\\u0923 \\u0914\\u0930 \\u0915\\u091a\\u0930\\u093e \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928, \\u0915\\u093e \\u0928\\u093f\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0943\\u0937\\u093f \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u091f\\u093f\\u0915\\u093e\\u090a\\u0924\\u093e \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0916\\u0947\\u0924 \\u092e\\u091c\\u0926\\u0942\\u0930\\u0940 \\u0914\\u0930 \\u0930\\u094b\\u091c\\u0917\\u093e\\u0930: \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0943\\u0937\\u093f \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u092e\\u0947\\u0902 \\u0936\\u094d\\u0930\\u092e \\u0914\\u0930 \\u0930\\u094b\\u091c\\u0917\\u093e\\u0930 \\u0915\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0915\\u0935\\u0930 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0930\\u094b\\u091c\\u0917\\u093e\\u0930 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947, \\u090b\\u0924\\u0941\\u090b\\u0924\\u0941\\u0928\\u093f\\u0915 \\u0936\\u094d\\u0930\\u092e\\u093f\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0906\\u0928\\u093e \\u0914\\u0930 \\u0936\\u094d\\u0930\\u092e \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0916\\u093e\\u0926\\u094d\\u092f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0928\\u093f\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923: \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0916\\u093e\\u0926\\u094d\\u092f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0917\\u0941\\u0923\\u0935\\u0924\\u094d\\u0924\\u093e \\u0915\\u094b \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u090f\\u0915 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092d\\u0942\\u092e\\u093f\\u0915\\u093e \\u0928\\u093f\\u092d\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u0916\\u093e\\u0926\\u094d\\u092f \\u0932\\u0947\\u092c\\u0932\\u093f\\u0902\\u0917 \\u0915\\u0947 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902, \\u0916\\u093e\\u0926\\u094d\\u092f \\u092a\\u094d\\u0930\\u0938\\u0902\\u0938\\u094d\\u0915\\u0930\\u0923 \\u0938\\u0902 Einrichtungen \\u0915\\u0940 \\u0928\\u093f\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923, \\u0914\\u0930 \\u0915\\u0943\\u0937\\u093f \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0915\\u0943\\u0937\\u093f \\u0938\\u092c\\u094d\\u0938\\u093f\\u0921\\u0940 \\u0914\\u0930 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0915\\u093e\\u0930\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e: \\u0938\\u0930\\u0915\\u093e\\u0930\\u0947\\u0902 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0915\\u093f\\u0938\\u093e\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u0943\\u0937\\u093f \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0928\\u0941\\u0926\\u093e\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092f\\u094b\\u091c\\u0928\\u093e\\u0913\\u0902, \\u0905\\u0928\\u0941\\u0926\\u093e\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0909\\u092a\\u0932\\u092c\\u094d\\u0927 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0915\\u093e\\u0930\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e\\u094b\\u0902 \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0915\\u0943\\u0937\\u093f \\u092e\\u093e\\u0928\\u0938\\u093f\\u0915\\u0940 \\u0938\\u0902\\u092a\\u0926\\u093e: \\u0928\\u0908 \\u0935\\u0928\\u0938\\u094d\\u092a\\u0924\\u093f \\u092a\\u094d\\u0930\\u091c\\u093e\\u0924\\u093f\\u092f\\u094b\\u0902 (\\u092a\\u094c\\u0927\\u093e \\u092a\\u0947\\u091f\\u0947\\u0902\\u091f), \\u091c\\u0940\\u0928\\u0947\\u091f\\u093f\\u0915\\u0932\\u0940 \\u0938\\u0902\\u0936\\u094b\\u0927\\u093f\\u0924 \\u091c\\u0940\\u0935\\u094b\\u0902 (GMOs), \\u0914\\u0930 \\u0915\\u0943\\u0937\\u093f \\u092a\\u094d\\u0930\\u094c\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u093e\\u0928\\u0938\\u093f\\u0915\\u0940 \\u0938\\u0902\\u092a\\u0926\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0915\\u0943\\u0937\\u093f \\u0935\\u093f\\u0924\\u094d\\u0924 \\u0914\\u0930 \\u092c\\u0948\\u0902\\u0915\\u093f\\u0902\\u0917: \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0906\\u0930\\u094d\\u0925\\u093f\\u0915 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u0915\\u0943\\u0937\\u093f \\u090b\\u0923, \\u0915\\u0943\\u0937\\u093f \\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f, \\u0914\\u0930 \\u0935\\u093f\\u092a\\u0924\\u094d\\u0924\\u093f \\u0906\\u092a\\u0924\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0926\\u093f\\u0935\\u093e\\u0932\\u093f\\u092f\\u093e\\u092a\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u090f\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u0938\\u0940\\u092f\\u0924 \\u092f\\u094b\\u091c\\u0928\\u093e \\u0914\\u0930 \\u0938\\u092b\\u0932\\u0924\\u093e: \\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0915\\u093f\\u0938\\u093e\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0935\\u0938\\u0940\\u092f\\u0924 \\u092f\\u094b\\u091c\\u0928\\u093e \\u0914\\u0930 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u0915 \\u0938\\u092b\\u0932\\u0924\\u093e \\u092e\\u0947\\u0902 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948 \\u0924\\u093e\\u0915\\u093f \\u0915\\u0943\\u0937\\u093f \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u094b \\u0905\\u0917\\u0932\\u0940 \\u092a\\u0940\\u0922\\u093c\\u0940 \\u092e\\u0947\\u0902 \\u0938\\u0941\\u0917\\u092e \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u0902\\u0930\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0940 \\u091c\\u091f\\u093f\\u0932 \\u0914\\u0930 \\u0935\\u093f\\u0915\\u0938\\u093f\\u0924 \\u092a\\u094d\\u0930\\u0915\\u0943\\u0924\\u093f \\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e, \\u0907\\u0938 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0915\\u0943\\u0937\\u093f \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e\\u094b\\u0902, \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u0938\\u0902\\u0917\\u0920\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0938\\u0916\\u094d\\u0924\\u0940 \\u0938\\u0947 \\u0915\\u093e\\u092e \\u0915\\u0930\\u0928\\u093e \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u0924\\u093e\\u0915\\u093f \\u0935\\u0947 \\u0915\\u0943\\u0937\\u093f \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0915\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u0930\\u093e\\u092e\\u0930\\u094d\\u0936 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0928\\u093f\\u0927\\u093f\\u0924\\u094d\\u0935 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0947\\u0902\\u0964 \\u0932\\u0915\\u094d\\u0937\\u094d\\u092f \\u092f\\u0939 \\u0939\\u0948 \\u0915\\u093f \\u0915\\u093f\\u0938\\u093e\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u0943\\u0937\\u093f \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u091a\\u0941\\u0928\\u094c\\u0924\\u093f\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0928\\u0947, \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u0935\\u0947\\u0915\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0914\\u0930 \\u0932\\u093e\\u092d\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0943\\u0937\\u093f \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093e\\u092e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629\\u060c \\u0627\\u0644\\u0645\\u0639\\u0631\\u0648\\u0641 \\u0623\\u064a\\u0636\\u0627\\u064b \\u0628\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0641\\u0644\\u0627\\u062d\\u064a\\u060c \\u064a\\u0634\\u0645\\u0644 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0628\\u0627\\u062f\\u0626 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0643\\u0645 \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0630\\u0627\\u062a \\u0627\\u0644\\u0635\\u0644\\u0629. \\u0625\\u0646\\u0647\\u0627 \\u0645\\u062c\\u0627\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0645\\u062a\\u062e\\u0635\\u0635 \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0631\\u064a\\u062f\\u0629 \\u0648\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0648\\u0627\\u062c\\u0647\\u0647\\u0627 \\u0627\\u0644\\u0641\\u0644\\u0627\\u062d\\u0648\\u0646 \\u0648\\u0645\\u0631\\u0628\\u0648 \\u0627\\u0644\\u0645\\u0627\\u0634\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0646\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0625\\u0646\\u062a\\u0627\\u062c \\u0648\\u0627\\u0644\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a.<\\/p>\\r\\n<p>\\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629: \\u064a\\u0634\\u0645\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0648\\u0627\\u0644\\u0635\\u064a\\u0627\\u063a\\u0629 \\u0648\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0634\\u0631\\u0627\\u0621 \\u0648\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0639\\u062f\\u0627\\u062a \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0634\\u0645\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0628\\u064a\\u0639 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u0645\\u0627\\u0634\\u064a\\u0629 \\u0648\\u0622\\u0644\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0648\\u062a\\u0623\\u062c\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0631\\u0627\\u0636\\u064a \\u0648\\u0635\\u0641\\u0642\\u0627\\u062a \\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0623\\u062e\\u0631\\u0649 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0623\\u0631\\u0627\\u0636\\u064a \\u0648\\u0627\\u0644\\u0645\\u0632\\u0627\\u0631\\u0639: \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0631\\u0627\\u0636\\u064a\\u060c \\u0648\\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u062d\\u062f\\u0648\\u062f\\u060c \\u0648\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0645\\u064a\\u0627\\u0647\\u060c \\u0648\\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629 \\u0647\\u064a \\u062c\\u0648\\u0627\\u0646\\u0628 \\u0647\\u0627\\u0645\\u0629 \\u0645\\u0646 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629. \\u064a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0645\\u0648\\u0646 \\u0627\\u0644\\u0645\\u062a\\u062e\\u0635\\u0635\\u0648\\u0646 \\u0641\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0628\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0646\\u0635\\u0627\\u0626\\u062d \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0631\\u0627\\u0636\\u064a \\u0648\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0645\\u064a\\u0627\\u0647 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0631\\u062f \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0633\\u0644\\u0639 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642: \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0643\\u0645 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642 \\u0648\\u0627\\u0644\\u0628\\u064a\\u0639 \\u0644\\u0644\\u0633\\u0644\\u0639 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0645\\u062b\\u0644 \\u0627\\u0644\\u062d\\u0628\\u0648\\u0628 \\u0648\\u0627\\u0644\\u0641\\u0648\\u0627\\u0643\\u0647 \\u0648\\u0627\\u0644\\u062e\\u0636\\u0631\\u0648\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u0634\\u064a \\u0647\\u064a \\u062c\\u0632\\u0621 \\u0623\\u0633\\u0627\\u0633\\u064a \\u0645\\u0646 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629. \\u0648\\u063a\\u0627\\u0644\\u0628\\u0627 \\u0645\\u0627 \\u062a\\u0634\\u0645\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0648\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0641 \\u0648\\u0623\\u0648\\u0627\\u0645\\u0631 \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a\\u0629: \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062a\\u0623\\u062b\\u064a\\u0631\\u0627\\u062a \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0631\\u0628\\u0629 \\u0648\\u062c\\u0648\\u062f\\u0629 \\u0627\\u0644\\u0645\\u064a\\u0627\\u0647 \\u0648\\u062a\\u0644\\u0648\\u062b \\u0627\\u0644\\u0647\\u0648\\u0627\\u0621 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0646\\u0641\\u0627\\u064a\\u0627\\u062a. \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a\\u0629 \\u0623\\u0645\\u0631 \\u0628\\u0627\\u0644\\u063a \\u0627\\u0644\\u0623\\u0647\\u0645\\u064a\\u0629 \\u0644\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0633\\u062a\\u062f\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0639\\u0645\\u0644 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a \\u0648\\u0627\\u0644\\u062a\\u0648\\u0638\\u064a\\u0641: \\u064a\\u063a\\u0637\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0639\\u0645\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0648\\u0638\\u064a\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0642\\u0637\\u0627\\u0639 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0639\\u0642\\u0648\\u062f \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0648\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0647\\u062c\\u0631\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0648\\u0633\\u0645\\u064a\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0639\\u0645\\u0644.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0637\\u0639\\u0627\\u0645 \\u0648\\u0627\\u0644\\u062a\\u0641\\u062a\\u064a\\u0634: \\u064a\\u0644\\u0639\\u0628 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u062f\\u0648\\u0631\\u0627\\u064b \\u062d\\u064a\\u0648\\u064a\\u0627\\u064b \\u0641\\u064a \\u0636\\u0645\\u0627\\u0646 \\u0633\\u0644\\u0627\\u0645\\u0629 \\u0648\\u062c\\u0648\\u062f\\u0629 \\u0627\\u0644\\u0637\\u0639\\u0627\\u0645. \\u0648\\u064a\\u062a\\u0636\\u0645\\u0646 \\u0630\\u0644\\u0643 \\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u0628\\u0634\\u0623\\u0646 \\u062a\\u0633\\u0645\\u064a\\u0629 \\u0627\\u0644\\u0623\\u063a\\u0630\\u064a\\u0629 \\u0648\\u0641\\u062d\\u0635 \\u0645\\u0646\\u0634\\u0622\\u062a \\u062a\\u062c\\u0647\\u064a\\u0632 \\u0627\\u0644\\u0637\\u0639\\u0627\\u0645 \\u0648\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0635\\u062d\\u0629 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0644\\u0644\\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062f\\u0639\\u0645 \\u0648\\u0627\\u0644\\u0628\\u0631\\u0627\\u0645\\u062c \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629: \\u063a\\u0627\\u0644\\u0628\\u0627\\u064b \\u0645\\u0627 \\u062a\\u0642\\u062f\\u0645 \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u0648\\u0627\\u0644\\u062f\\u0639\\u0645 \\u0644\\u0644\\u0645\\u0632\\u0627\\u0631\\u0639\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629. \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0644\\u0644\\u0628\\u0631\\u0627\\u0645\\u062c \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0646\\u062d \\u0648\\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u062a\\u0627\\u062d \\u0644\\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629: \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629 \\u0644\\u0623\\u0635\\u0646\\u0627\\u0641 \\u0627\\u0644\\u0646\\u0628\\u0627\\u062a\\u0627\\u062a \\u0627\\u0644\\u062c\\u062f\\u064a\\u062f\\u0629 (\\u0628\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0627\\u062e\\u062a\\u0631\\u0627\\u0639 \\u0644\\u0644\\u0646\\u0628\\u0627\\u062a\\u0627\\u062a) \\u0648\\u0627\\u0644\\u0643\\u0627\\u0626\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u062f\\u0644\\u0629 \\u0648\\u0631\\u0627\\u062b\\u064a\\u0627\\u064b \\u0648\\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a \\u0648\\u0627\\u0644\\u0628\\u0646\\u0648\\u0643: \\u064a\\u0634\\u0645\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0645\\u062b\\u0644 \\u0627\\u0644\\u0642\\u0631\\u0648\\u0636 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a \\u0648\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u0641\\u0644\\u064a\\u0633 \\u0644\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u062b\\u0631\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u062a\\u062e\\u0637\\u064a\\u0637 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0631 \\u0627\\u0644\\u0625\\u0631\\u062b\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062e\\u0644\\u0627\\u0641\\u0629: \\u064a\\u0633\\u0627\\u0639\\u062f \\u0627\\u0644\\u0645\\u062d\\u0627\\u0645\\u0648\\u0646 \\u0627\\u0644\\u0645\\u062a\\u062e\\u0635\\u0635\\u0648\\u0646 \\u0641\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0641\\u0644\\u0627\\u062d\\u064a\\u0646 \\u0641\\u064a \\u062a\\u062e\\u0637\\u064a\\u0637 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0631 \\u0627\\u0644\\u0625\\u0631\\u062b\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0627\\u0646\\u062a\\u0642\\u0627\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0633 \\u0644\\u0644\\u0623\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062c\\u064a\\u0644 \\u0627\\u0644\\u0642\\u0627\\u062f\\u0645.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0646\\u0638\\u0631\\u064b\\u0627 \\u0644\\u0637\\u0628\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0642\\u062f\\u0629 \\u0648\\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631\\u0629\\u060c \\u063a\\u0627\\u0644\\u0628\\u0627\\u064b \\u0645\\u0627 \\u064a\\u0639\\u0645\\u0644 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0645\\u0648\\u0646 \\u0627\\u0644\\u0645\\u062a\\u062e\\u0635\\u0635\\u0648\\u0646 \\u0641\\u064a \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644 \\u0639\\u0646 \\u0643\\u062b\\u0628 \\u0645\\u0639 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u064a\\u0646 \\u0648\\u0627\\u0644\\u062c\\u0647\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0646\\u0638\\u0645\\u0627\\u062a \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u064a\\u0629 \\u0644\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0634\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0634\\u0627\\u0645\\u0644\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0645\\u062b\\u064a\\u0644 \\u0644\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0641\\u064a \\u0627\\u0644\\u0642\\u0637\\u0627\\u0639 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a. \\u0627\\u0644\\u0647\\u062f\\u0641 \\u0647\\u0648 \\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0641\\u0644\\u0627\\u062d\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0646\\u0642\\u0644 \\u0641\\u064a \\u0627\\u0644\\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645 \\u0628\\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a\\u060c \\u0648\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0632\\u0631\\u0627\\u0639\\u064a\\u0629 \\u0645\\u0633\\u062a\\u062f\\u0627\\u0645\\u0629 \\u0648\\u0631\\u0627\\u0628\\u062d\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 2,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Agriculture Therapy","hi":"\\u0915\\u0943\\u0937\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629"}',
                'parent_category_id' => 5,
                'slug' => 'agriculture-therapy-2',
                'updated_at' => '2023-10-23 20:03:55',
            ),
            2 => 
            array (
                'created_at' => '2023-08-03 14:13:23',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Animal therapy, also known as animal rights therapy or animal welfare therapy, is a specialized area of therapy that addresses legal issues related to animals. It encompasses a wide range of topics, including the protection and welfare of animals, animal rights, animal cruelty, conservation, and the legal status of animals as sentient beings.<\\/p>\\r\\n\\r\\n<p>Key Aspects of Animal Therapy:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Animal Cruelty and Welfare: Animal therapy includes therapys and regulations that protect animals from cruelty and abuse. This involves criminal penalties for acts of animal cruelty, neglect, or abandonment. It also covers therapys regarding the proper care and treatment of animals kept in captivity, such as in zoos, farms, and research facilities.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Rights: Animal therapy seeks to address the legal status of animals as sentient beings capable of experiencing pain and suffering. Advocates of animal rights seek to expand legal protections for animals, recognizing their intrinsic value and right to be free from harm and exploitation.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Companion Animals: Legal issues related to pets, such as dogs, cats, and other domestic animals, are an important aspect of animal therapy. This includes therapys concerning pet ownership, pet custody in divorce cases, and pet-related contracts and agreements.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Wildlife Protection: Animal therapy covers therapys and regulations aimed at protecting wildlife, endangered species, and their natural habitats. This involves regulations on hunting, trapping, and conservation efforts to preserve biodiversity.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Testing and Research: Animal therapy addresses the use of animals in scientific research and experimentation. It includes regulations on animal testing, alternatives to animal testing, and ethical considerations in animal research.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Agriculture: Legal issues related to animal agriculture involve regulations on factory farming, animal husbandry practices, and the treatment of livestock animals. Animal therapy also covers therapys regarding the transportation and slaughter of animals for food.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Rescue and Shelter Therapy: This aspect of animal therapy pertains to the legal rights and responsibilities of animal rescue organizations and animal shelters. It includes regulations on animal adoptions, fostering, and the handling of stray animals.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Animal Advocacy and Lobbying: Animal therapy involves advocacy efforts to promote animal welfare and rights through lobbying, litigation, and public awareness campaigns.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Legal Status of Animals: Animal therapy debates the legal status of animals as property or sentient beings with legal rights. Some jurisdictions have recognized animals as &quot;legal persons&quot; in specific contexts, affording them certain protections under the therapy.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>International Animal Therapy: Animal therapy is not limited to individual countries; there are also international efforts to address global animal welfare and conservation issues through treaties and agreements.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Animal therapy is a rapidly growing area of legal practice, driven by increasing public awareness and concern for animal welfare. Advocates and legal professionals in this field work to strengthen legal protections for animals, promote responsible animal ownership, and ensure that animals are treated with compassion and respect within society.<\\/p>","hi":"<p>\\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f, \\u091c\\u093f\\u0938\\u0947 \\u092a\\u0936\\u0941 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f \\u092f\\u093e \\u092a\\u0936\\u0941 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923 \\u0935\\u093f\\u0927\\u093f \\u092d\\u0940 \\u0915\\u0939\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0935\\u0939 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u090f\\u0915 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0939\\u0948 \\u091c\\u094b \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u0918\\u091f\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923, \\u092a\\u0936\\u0941 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930, \\u092a\\u0936\\u0941 \\u0909\\u0924\\u094d\\u092a\\u0940\\u0921\\u093c\\u0928, \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923 \\u0914\\u0930 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u091c\\u093e\\u0917\\u0930\\u0942\\u0915 \\u091c\\u0940\\u0935\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n<p>\\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947 \\u092e\\u0941\\u0916\\u094d\\u092f \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0936\\u0941 \\u0909\\u0924\\u094d\\u092a\\u0940\\u0921\\u093c\\u0928 \\u0914\\u0930 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u092e\\u0947\\u0902 \\u0910\\u0938\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u094b \\u0909\\u0924\\u094d\\u092a\\u0940\\u0921\\u093c\\u0928 \\u0914\\u0930 \\u0936\\u094b\\u0937\\u0923 \\u0938\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941 \\u0909\\u0924\\u094d\\u092a\\u0940\\u0921\\u093c\\u0928, \\u0909\\u092a\\u0947\\u0915\\u094d\\u0937\\u093e \\u092f\\u093e \\u091b\\u094b\\u0921\\u093c\\u0928\\u0947 \\u0915\\u0947 \\u0915\\u0943\\u0924\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u092a\\u0930\\u093e\\u0927\\u093f\\u0915 \\u0926\\u0902\\u0921 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939 \\u092f\\u0939 \\u092d\\u0940 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092c\\u0902\\u0926\\u0930\\u0917\\u093e\\u0939\\u094b\\u0902, \\u0916\\u0947\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u0941\\u0938\\u0902\\u0927\\u093e\\u0928 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u091c\\u0948\\u0938\\u0947 \\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u092a\\u0930 \\u0930\\u0916\\u0947 \\u0917\\u090f \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0909\\u091a\\u093f\\u0924 \\u0926\\u0947\\u0916\\u092d\\u093e\\u0932 \\u0914\\u0930 \\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0936\\u0941 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0915\\u094b \\u0938\\u0902\\u0935\\u0947\\u0926\\u0928\\u0936\\u0940\\u0932 \\u092a\\u094d\\u0930\\u093e\\u0923\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u092a\\u0924\\u093e \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0926\\u0941\\u0903\\u0916 \\u0914\\u0930 \\u092a\\u0940\\u0921\\u093c\\u093e \\u0915\\u093e \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0915\\u094d\\u0937\\u092e\\u0924\\u093e \\u0930\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u0915\\u0930\\u094d\\u0924\\u093e \\u0924\\u092c\\u094d\\u0926\\u0940\\u0932\\u0940 \\u0915\\u0947 \\u0909\\u0926\\u094d\\u0918\\u093e\\u091f\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u092a\\u094d\\u0930\\u092f\\u093e\\u0938 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0906\\u0902\\u0924\\u0930\\u094d\\u0928\\u093f\\u0939\\u093f\\u0924 \\u092e\\u0942\\u0932\\u094d\\u092f \\u0914\\u0930 \\u0939\\u093e\\u0928\\u093f \\u0914\\u0930 \\u0936\\u094b\\u0937\\u0923 \\u0938\\u0947 \\u092e\\u0941\\u0915\\u094d\\u0924\\u093f \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u092e\\u093e\\u0928\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0938\\u093e\\u0925\\u0940 \\u092a\\u0936\\u0941: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0941\\u0924\\u094d\\u0924\\u094b\\u0902, \\u092c\\u093f\\u0932\\u094d\\u0932\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0918\\u0930\\u0947\\u0932\\u0942 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u091c\\u0948\\u0938\\u0947 \\u092a\\u093e\\u0932\\u0924\\u0942 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947 \\u090f\\u0915 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092a\\u093e\\u0932\\u0924\\u0942 \\u092a\\u0936\\u0941 \\u0915\\u0940 \\u092e\\u093e\\u0932\\u093f\\u0915\\u0940, \\u0924\\u0932\\u093e\\u0915 \\u0915\\u0947 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941 \\u0915\\u093f\\u0930\\u093e\\u092f\\u093e \\u0914\\u0930 \\u092a\\u0936\\u0941 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u0928\\u094d\\u092f\\u091c\\u0940\\u0935 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u0935\\u0928\\u094d\\u092f\\u091c\\u0940\\u0935, \\u0935\\u093f\\u0932\\u0941\\u092a\\u094d\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u094d\\u0930\\u091c\\u093e\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0909\\u0928\\u0915\\u0947 \\u092a\\u094d\\u0930\\u093e\\u0915\\u0943\\u0924\\u093f\\u0915 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0928\\u093e\\u090f \\u0917\\u090f \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092c\\u093e\\u0918\\u092c\\u093e\\u0928\\u0940, \\u092b\\u0902\\u0938\\u0940 \\u0914\\u0930 \\u091c\\u0948\\u0935 \\u0935\\u093f\\u0935\\u093f\\u0927\\u0924\\u093e \\u0915\\u094b \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u092f\\u093e\\u0938\\u094b\\u0902 \\u092a\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0936\\u0941 \\u092a\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923 \\u0914\\u0930 \\u0905\\u0928\\u0941\\u0938\\u0902\\u0927\\u093e\\u0928: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u0935\\u0948\\u091c\\u094d\\u091e\\u093e\\u0928\\u093f\\u0915 \\u0905\\u0928\\u0941\\u0938\\u0902\\u0927\\u093e\\u0928 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092f\\u094b\\u0917 \\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u092a\\u0930 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941 \\u092a\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923, \\u092a\\u0936\\u0941 \\u092a\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923 \\u0915\\u0947 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0914\\u0930 \\u092a\\u0936\\u0941 \\u0905\\u0928\\u0941\\u0938\\u0902\\u0927\\u093e\\u0928 \\u092e\\u0947\\u0902 \\u0928\\u0948\\u0924\\u093f\\u0915 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u092a\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0936\\u0941 \\u0915\\u0943\\u0937\\u093f: \\u092a\\u0936\\u0941 \\u0915\\u0943\\u0937\\u093f \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947 \\u0938\\u0902\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0935\\u093f\\u092a\\u0923\\u0928, \\u092a\\u0936\\u0941 \\u092a\\u093e\\u0932\\u0928 \\u092a\\u094d\\u0930\\u0925\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e\\u0928 \\u0915\\u0947 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u092f\\u0939 \\u092d\\u0940 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0916\\u093e\\u0926\\u094d\\u092f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0947 \\u092a\\u0930\\u093f\\u0935\\u0939\\u0928 \\u0914\\u0930 \\u0935\\u0927 \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u094d\\u092f\\u093e \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0936\\u0941 \\u0909\\u0926\\u094d\\u0927\\u093e\\u0930 \\u0914\\u0930 \\u0906\\u0936\\u094d\\u0930\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u0915\\u093e \\u092f\\u0939 \\u092a\\u0939\\u0932\\u0942 \\u092a\\u0936\\u0941 \\u0909\\u0926\\u094d\\u0927\\u093e\\u0930 \\u0938\\u0902\\u0917\\u0920\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u092a\\u0936\\u0941 \\u0906\\u0936\\u094d\\u0930\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941 \\u0917\\u094b\\u0926 \\u0932\\u0947\\u0928, \\u092a\\u094b\\u0937\\u0923 \\u0914\\u0930 \\u092d\\u091f\\u0915 \\u091c\\u093e\\u0928\\u0935\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0902\\u092a\\u093e\\u0926\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0936\\u0941 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u091a\\u093e\\u0930: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u092d\\u093e\\u0930\\u0924\\u0940\\u092f \\u0938\\u092e\\u093e\\u091c \\u092e\\u0947\\u0902 \\u092a\\u0936\\u0941 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923 \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948 \\u091c\\u094b \\u091a\\u0941\\u0915\\u093e\\u0928\\u093e, \\u092e\\u0941\\u0915\\u0926\\u092e\\u093e \\u091a\\u0932\\u093e\\u0928\\u0947 \\u0914\\u0930 \\u091c\\u0928\\u0924\\u093e \\u0915\\u0947 \\u091c\\u093e\\u0917\\u0930\\u0942\\u0915 \\u0915\\u0930\\u0928\\u0947 \\u0905\\u092d\\u093f\\u092f\\u093e\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092a\\u0936\\u0941 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923 \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093e\\u092e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u092e\\u0947\\u0902 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092a\\u0936\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u092f\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0935\\u093e\\u0932\\u0947 \\u091c\\u0940\\u0935\\u094b\\u0902 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0939\\u0948\\u0964 \\u0915\\u0941\\u091b \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092f\\u0939\\u093e\\u0901 \\u0924\\u0915 \\u0915\\u093f \\u0935\\u093f\\u0927\\u093e\\u092f\\u093f\\u0915\\u093e\\u0913\\u0902 \\u0928\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0938\\u0902\\u0915\\u091f \\u092e\\u0947\\u0902 \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\"\\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\" \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u092e\\u093e\\u0928\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0926\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f: \\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u0915\\u0947\\u0935\\u0932 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0940\\u092e\\u093f\\u0924 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u0948; \\u0935\\u093f\\u092a\\u0923\\u0928\\u0940\\u092f \\u092a\\u0936\\u0941 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923 \\u0914\\u0930 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u091a\\u093f\\u0902\\u0924\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0902\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u092a\\u0936\\u0941 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923 \\u0914\\u0930 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u092a\\u0930 \\u091a\\u0930\\u094d\\u091a\\u093e \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u092a\\u0936\\u0941 \\u0935\\u093f\\u0927\\u093f \\u091c\\u093e\\u0917\\u0930\\u0942\\u0915\\u0924\\u093e \\u0914\\u0930 \\u092a\\u0936\\u0941 \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0922\\u093c\\u0924\\u0947 \\u0939\\u0941\\u090f \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0947 \\u0935\\u0943\\u0915\\u094d\\u0937 \\u0928\\u0948\\u0924\\u093f\\u0915\\u0924\\u093e \\u0914\\u0930 \\u0907\\u0938 \\u0938\\u092e\\u093e\\u091c \\u092e\\u0947\\u0902 \\u0938\\u093e\\u0939\\u093f\\u0924\\u094d\\u092f \\u0914\\u0930 \\u0907\\u0938\\u094d\\u0924\\u0947\\u092e\\u093e\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0922\\u093c\\u0924\\u0947 \\u0939\\u0941\\u090f \\u091c\\u0928\\u0938\\u0902\\u0916\\u094d\\u092f\\u093e \\u0915\\u0947 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093e\\u092e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0938 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0915\\u0947 \\u0935\\u0915\\u0940\\u0932 \\u092f\\u093e \\u092a\\u0936\\u0941 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0905\\u092a\\u0940\\u0932 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u091c\\u091f\\u093f\\u0932\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0932\\u0928\\u0947 \\u0914\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0930\\u094d\\u0935\\u094b\\u0924\\u094d\\u0924\\u092e \\u092a\\u0930\\u093f\\u0923\\u093e\\u092e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0928\\u0941\\u092d\\u0935\\u0936\\u0940\\u0932\\u0924\\u093e \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u060c \\u0627\\u0644\\u0645\\u0639\\u0631\\u0648\\u0641 \\u0623\\u064a\\u0636\\u0627 \\u0628\\u0627\\u0633\\u0645 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0623\\u0648 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0631\\u0641\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u060c \\u0647\\u0648 \\u0645\\u062c\\u0627\\u0644 \\u062a\\u062e\\u0635\\u0635\\u064a \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a. \\u0648\\u064a\\u0634\\u0645\\u0644 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0636\\u0648\\u0639\\u0627\\u062a\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0648\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u0633\\u0648\\u0621 \\u0645\\u0639\\u0627\\u0645\\u0644\\u062a\\u0647\\u0627\\u060c \\u0648\\u0627\\u0644\\u0645\\u062d\\u0627\\u0641\\u0638\\u0629 \\u0639\\u0644\\u064a\\u0647\\u0627\\u060c \\u0648\\u0627\\u0644\\u0648\\u0636\\u0639 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0643\\u0643\\u0627\\u0626\\u0646\\u0627\\u062a \\u0630\\u0627\\u062a \\u0648\\u0639\\u064a.<\\/p>\\r\\n<p>\\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0633\\u0648\\u0621 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0648\\u0631\\u0639\\u0627\\u064a\\u062a\\u0647: \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0645\\u064a \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0633\\u0648\\u0629 \\u0648\\u0627\\u0644\\u0625\\u0633\\u0627\\u0621\\u0629. \\u0648\\u064a\\u062a\\u0636\\u0645\\u0646 \\u0630\\u0644\\u0643 \\u0641\\u0631\\u0636 \\u0639\\u0642\\u0648\\u0628\\u0627\\u062a \\u062c\\u0646\\u0627\\u0626\\u064a\\u0629 \\u0639\\u0644\\u0649 \\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0642\\u0633\\u0648\\u0629 \\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0625\\u0647\\u0645\\u0627\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u0647\\u062c\\u0631. \\u0643\\u0645\\u0627 \\u064a\\u063a\\u0637\\u064a \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0639\\u0644\\u0627\\u062c \\u0627\\u0644\\u0633\\u0644\\u064a\\u0645 \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u062d\\u062a\\u0641\\u0638 \\u0628\\u0647\\u0627 \\u0641\\u064a \\u0627\\u0644\\u0623\\u0633\\u0631\\u060c \\u0645\\u062b\\u0644 \\u0641\\u064a \\u0627\\u0644\\u062d\\u062f\\u0627\\u0626\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0632\\u0627\\u0631\\u0639 \\u0648\\u0645\\u0631\\u0627\\u0641\\u0642 \\u0627\\u0644\\u0628\\u062d\\u062b.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646: \\u064a\\u0633\\u0639\\u0649 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0648\\u0636\\u0639 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0643\\u0643\\u0627\\u0626\\u0646\\u0627\\u062a \\u0630\\u0627\\u062a \\u0648\\u0639\\u064a \\u0642\\u0627\\u062f\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0623\\u0644\\u0645 \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u0646\\u0627\\u0629. \\u064a\\u0633\\u0639\\u0649 \\u0645\\u062f\\u0627\\u0641\\u0639\\u0648 \\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0625\\u0644\\u0649 \\u062a\\u0648\\u0633\\u064a\\u0639 \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0645\\u0639 \\u0627\\u0644\\u062a\\u0633\\u0644\\u064a\\u0645 \\u0628\\u0642\\u064a\\u0645\\u062a\\u0647\\u0627 \\u0627\\u0644\\u062c\\u0648\\u0647\\u0631\\u064a\\u0629 \\u0648\\u062d\\u0642\\u0647\\u0627 \\u0641\\u064a \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u062d\\u0631\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0630\\u0649 \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u063a\\u0644\\u0627\\u0644.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u0627\\u0641\\u0642\\u0629: \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0623\\u0644\\u064a\\u0641\\u0629\\u060c \\u0645\\u062b\\u0644 \\u0627\\u0644\\u0643\\u0644\\u0627\\u0628 \\u0648\\u0627\\u0644\\u0642\\u0637\\u0637 \\u0648\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649\\u060c \\u0647\\u064a \\u062c\\u0627\\u0646\\u0628 \\u0645\\u0647\\u0645 \\u0645\\u0646 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646. \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0645\\u062a\\u0644\\u0627\\u0643 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0623\\u0644\\u064a\\u0641\\u0629\\u060c \\u0648\\u062d\\u0636\\u0627\\u0646\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0623\\u0644\\u064a\\u0641\\u0629 \\u0641\\u064a \\u062d\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642\\u060c \\u0648\\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0648\\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0623\\u0644\\u064a\\u0641\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0628\\u0631\\u064a\\u0629: \\u064a\\u063a\\u0637\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0647\\u062f\\u0641 \\u0625\\u0644\\u0649 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0627\\u0629 \\u0627\\u0644\\u0628\\u0631\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u0645\\u0647\\u062f\\u062f\\u0629 \\u0628\\u0627\\u0644\\u0627\\u0646\\u0642\\u0631\\u0627\\u0636 \\u0648\\u0645\\u0648\\u0627\\u0637\\u0646\\u0647\\u0627 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629. \\u064a\\u0634\\u0645\\u0644 \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0635\\u064a\\u062f \\u0648\\u0627\\u0644\\u0641\\u062e\\u0627\\u062e \\u0648\\u062c\\u0647\\u0648\\u062f \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0646\\u0648\\u0639 \\u0627\\u0644\\u0628\\u064a\\u0648\\u0644\\u0648\\u062c\\u064a.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u062e\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0648\\u0623\\u0628\\u062d\\u0627\\u062b \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a: \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0623\\u0628\\u062d\\u0627\\u062b \\u0627\\u0644\\u0639\\u0644\\u0645\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0628. \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u062e\\u062a\\u0628\\u0627\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u0628\\u062f\\u0627\\u0626\\u0644 \\u0627\\u062e\\u062a\\u0628\\u0627\\u0631 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0623\\u062e\\u0644\\u0627\\u0642\\u064a\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0628\\u062d\\u0648\\u062b \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a: \\u062a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u064a\\u0629 \\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0632\\u0627\\u0631\\u0639 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u064a\\u0629 \\u0648\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u062a\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0634\\u064a\\u0629. \\u064a\\u063a\\u0637\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0646\\u0642\\u0644 \\u0648\\u0630\\u0628\\u062d \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0644\\u0644\\u0623\\u063a\\u0630\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0625\\u0646\\u0642\\u0627\\u0630 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0648\\u0645\\u0644\\u062c\\u0623: \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062c\\u0627\\u0646\\u0628 \\u0645\\u0646 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0628\\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0644\\u0645\\u0646\\u0638\\u0645\\u0627\\u062a \\u0625\\u0646\\u0642\\u0627\\u0630 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0648\\u062f\\u0648\\u0631 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0628\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a. \\u064a\\u0634\\u0645\\u0644 \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062a\\u0628\\u0646\\u064a \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0648\\u0631\\u0639\\u0627\\u064a\\u062a\\u0647\\u0627 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0636\\u0627\\u0644\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u062f\\u0627\\u0641\\u0639\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0639\\u0627\\u064a\\u0629 \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646: \\u064a\\u0634\\u0645\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u062c\\u0647\\u0648\\u062f \\u0627\\u0644\\u0645\\u062f\\u0627\\u0641\\u0639\\u0629 \\u0644\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0631\\u0641\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0648\\u062d\\u0642\\u0648\\u0642\\u0647\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062f\\u062e\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0648\\u0627\\u0644\\u062f\\u0639\\u0627\\u064a\\u0629 \\u0648\\u062d\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0648\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0648\\u0636\\u0639 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a: \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0627\\u0644\\u0646\\u0642\\u0627\\u0634 \\u062d\\u0648\\u0644 \\u0627\\u0644\\u0648\\u0636\\u0639 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0643\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0623\\u0648 \\u0643\\u0643\\u0627\\u0626\\u0646\\u0627\\u062a \\u0630\\u0627\\u062a \\u0648\\u0639\\u064a \\u0628\\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629. \\u0642\\u062f \\u0627\\u0639\\u062a\\u0631\\u0641\\u062a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0628\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0643\\u0640 \\"\\u0623\\u0634\\u062e\\u0627\\u0635 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u064a\\u0646\\" \\u0641\\u064a \\u0633\\u064a\\u0627\\u0642\\u0627\\u062a \\u0645\\u0639\\u064a\\u0646\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0645\\u0646\\u062d\\u0647\\u0645 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0627\\u062a \\u0628\\u0645\\u0648\\u062c\\u0628 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a: \\u0644\\u0627 \\u064a\\u0642\\u062a\\u0635\\u0631 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062f\\u0648\\u0644 \\u0627\\u0644\\u0641\\u0631\\u062f\\u064a\\u0629\\u061b \\u0647\\u0646\\u0627\\u0643 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u062c\\u0647\\u0648\\u062f \\u062f\\u0648\\u0644\\u064a\\u0629 \\u0644\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0631\\u0641\\u0642 \\u0628\\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0648\\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0632\\u0646 \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0647\\u062f\\u0627\\u062a \\u0648\\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646 \\u0647\\u0648 \\u0645\\u062c\\u0627\\u0644 \\u064a\\u0646\\u0645\\u0648 \\u0628\\u0633\\u0631\\u0639\\u0629 \\u0641\\u064a \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u060c \\u0648\\u0630\\u0644\\u0643 \\u0646\\u062a\\u064a\\u062c\\u0629 \\u0644\\u0632\\u064a\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0648\\u0639\\u064a \\u0627\\u0644\\u0639\\u0627\\u0645 \\u0648\\u0627\\u0644\\u0642\\u0644\\u0642 \\u0628\\u0634\\u0623\\u0646 \\u0631\\u0641\\u0642 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646. \\u064a\\u0639\\u0645\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0627\\u0641\\u0639\\u0648\\u0646 \\u0648\\u0627\\u0644\\u0645\\u062d\\u062a\\u0631\\u0641\\u0648\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0648\\u0646 \\u0641\\u064a \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0645\\u064a\\u062f\\u0627\\u0646 \\u0639\\u0644\\u0649 \\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u0629 \\u0644\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646 \\u062a\\u0639\\u0627\\u0645\\u0644 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646\\u0627\\u062a \\u0628\\u0631\\u0641\\u0642 \\u0648\\u0627\\u062d\\u062a\\u0631\\u0627\\u0645 \\u062f\\u0627\\u062e\\u0644 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639.<\\/p>"}',
                'icon' => NULL,
                'id' => 3,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Animal Therapy","hi":"\\u092a\\u0936\\u0941 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062d\\u064a\\u0648\\u0627\\u0646"}',
                'parent_category_id' => NULL,
                'slug' => 'animal-therapy-3',
                'updated_at' => '2023-10-11 17:15:35',
            ),
            3 => 
            array (
                'created_at' => '2023-08-03 14:14:55',
                'deleted_at' => NULL,
            'description' => '{"hi":"<p>\\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928, \\u091c\\u093f\\u0938\\u0947 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092d\\u0940 \\u0915\\u0939\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u0940 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u094b \\u092c\\u091a\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0908 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u090f\\u0915 \\u0938\\u092e\\u0942\\u0939 \\u0939\\u0948 \\u091c\\u094b \\u092c\\u093e\\u091c\\u093e\\u0930 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0928\\u094d\\u092f\\u093e\\u092f\\u0938\\u0902\\u0917\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u0947 \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0930\\u0916\\u0924\\u093e \\u0939\\u0948\\u0964 \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u092e\\u0941\\u0916\\u094d\\u092f \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e, \\u092c\\u093e\\u091c\\u093e\\u0930 \\u0915\\u0941\\u0936\\u0932\\u0924\\u093e \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u0928\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0935\\u094d\\u092f\\u0935\\u0939\\u093e\\u0930 \\u0915\\u094b \\u0930\\u094b\\u0915\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n<p>\\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u092e\\u0949\\u0928\\u094b\\u092a\\u094b\\u0932\\u0940 \\u0915\\u093e \\u0928\\u093f\\u0937\\u0947\\u0927: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u090f\\u0915\\u0932 \\u0915\\u0902\\u092a\\u0928\\u0940 \\u092f\\u093e \\u0915\\u0941\\u091b \\u0915\\u0902\\u092a\\u0928\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0915\\u093f\\u0938\\u0940 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u092c\\u093e\\u091c\\u093e\\u0930 \\u092f\\u093e \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092a\\u0930 \\u0905\\u0927\\u093f\\u0915 \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u0923 \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0915\\u094b \\u0928\\u093f\\u0930\\u094d\\u092e\\u093f\\u0924 \\u092f\\u093e \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u0928\\u0947 \\u0915\\u093e \\u092a\\u094d\\u0930\\u0924\\u093f\\u0937\\u0947\\u0927 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092e\\u0949\\u0928\\u094b\\u092a\\u094b\\u0932\\u0940 \\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u094b \\u0938\\u0940\\u092e\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948, \\u092e\\u0942\\u0932\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948, \\u0914\\u0930 \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e \\u091a\\u092f\\u0928 \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u0940 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u0928 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u0940 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u094b \\u0932\\u0915\\u094d\\u0937\\u094d\\u092f \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u094b \\u0938\\u0940\\u092e\\u093f\\u0924 \\u092f\\u093e \\u0935\\u093f\\u0915\\u0943\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0928 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092e\\u0942\\u0932\\u094d\\u092f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 (\\u092e\\u0942\\u0932\\u094d\\u092f \\u0924\\u092f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u093e\\u0915\\u094d\\u0937\\u0930\\u0924\\u093e), \\u092c\\u094b\\u0932\\u0940 \\u0930\\u093f\\u0917\\u093f\\u0902\\u0917 (\\u0938\\u0902\\u0935\\u093f\\u0926\\u093e\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u094b\\u0932\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092c\\u0926\\u0932\\u0928\\u093e) \\u092e\\u093e\\u0930\\u094d\\u0915\\u0947\\u091f \\u0935\\u093f\\u092d\\u093e\\u091c\\u0928 (\\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u092c\\u093e\\u091c\\u093e\\u0930 \\u0915\\u094b \\u0935\\u093f\\u092d\\u093e\\u091c\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e) \\u0914\\u0930 \\u091f\\u093e\\u0907\\u0902\\u0917 (\\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u094b \\u090f\\u0915 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926 \\u0915\\u094b \\u0916\\u0930\\u0940\\u0926\\u0928\\u0947 \\u0915\\u0940 \\u0936\\u0930\\u094d\\u0924 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0926\\u092c\\u093e\\u0928\\u093e) \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092e\\u0930\\u094d\\u091c \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0917\\u094d\\u0930\\u0939\\u0923: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0930\\u094d\\u091c \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0917\\u094d\\u0930\\u0939\\u0923 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0924\\u093e\\u0915\\u093f \\u0938\\u0902\\u092d\\u093e\\u0935\\u093f\\u0924 \\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u0940 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u094b\\u0902 \\u0938\\u0947 \\u092c\\u091a\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947\\u0964 \\u092a\\u094d\\u0930\\u093e\\u0927\\u093f\\u0915\\u0930\\u0923\\u094b\\u0902 \\u0915\\u094b \\u0910\\u0938\\u0947 \\u092e\\u0930\\u094d\\u091c \\u0915\\u094b \\u0930\\u094b\\u0915 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u094b \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0915\\u092e \\u0915\\u0930 \\u0926\\u0947\\u0902 \\u092f\\u093e \\u092e\\u0949\\u0928\\u094b\\u092a\\u094b\\u0932\\u0940 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092e\\u0942\\u0932\\u094d\\u092f \\u0935\\u093f\\u092d\\u093e\\u091c\\u0928: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0942\\u0932\\u094d\\u092f \\u0935\\u093f\\u092d\\u093e\\u091c\\u0928 \\u092a\\u0930 \\u0927\\u094d\\u092f\\u093e\\u0928 \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u091c\\u094b \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u091c\\u092c \\u090f\\u0915 \\u0935\\u093f\\u0915\\u094d\\u0930\\u0947\\u0924\\u093e \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0938\\u092e\\u093e\\u0928 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u092f\\u093e \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092e\\u0942\\u0932\\u094d\\u092f\\u094b\\u0902 \\u092a\\u0930 \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0932\\u0947\\u0924\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u092f\\u0939 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u092f\\u093e \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0915\\u094d\\u0937\\u0924\\u093f \\u092a\\u0939\\u0941\\u0902\\u091a\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u094d\\u0930\\u0924\\u093f\\u0926\\u094d\\u0935\\u0902\\u0926\\u094d\\u0935\\u0940 \\u092a\\u094d\\u0930\\u0925\\u093e\\u090f\\u0901: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0902\\u0936\\u0924: \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092f\\u093e \\u0935\\u093f\\u0926\\u094d\\u0935\\u0947\\u0937\\u0940 \\u092a\\u094d\\u0930\\u0925\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0928\\u093f\\u0937\\u0947\\u0927 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0939\\u093e\\u0901 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u0915\\u0902\\u092a\\u0928\\u093f\\u092f\\u093e\\u0901 \\u0935\\u093f\\u092a\\u0930\\u0940\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092c\\u093e\\u091c\\u093e\\u0930 \\u0938\\u0947 \\u092c\\u093e\\u0939\\u0930 \\u0928\\u093f\\u0915\\u093e\\u0932\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0902\\u0915\\u094d\\u0937\\u0947\\u092a\\u093f\\u0924 \\u0924\\u0915\\u0928\\u0940\\u0915\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u092e\\u0947\\u0902 \\u0915\\u092e\\u0940 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u0941\\u0928\\u0903 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u092e\\u0942\\u0932\\u094d\\u092f \\u0930\\u0915\\u094d\\u0937\\u0923: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0915\\u094b\\u0902 \\u092f\\u093e \\u0906\\u092a\\u0942\\u0930\\u094d\\u0924\\u093f\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0928\\u093f\\u0937\\u094d\\u0926\\u0947\\u0936 \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0935\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u0935\\u093f\\u0924\\u0930\\u0915\\u094b\\u0902 \\u092f\\u093e \\u0916\\u0941\\u0926\\u0930\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0909\\u0928\\u0915\\u0947 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u0915\\u0940 \\u0915\\u0940\\u092e\\u0924\\u0947\\u0902 \\u0915\\u0948\\u0938\\u0947 \\u092c\\u0947\\u091a \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0915\\u093e\\u0930\\u094d\\u091f\\u0947\\u0932: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e\\u0930\\u094d\\u091f\\u0947\\u0932 \\u0915\\u094b \\u0932\\u0915\\u094d\\u0937\\u094d\\u092f \\u092c\\u0928\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u090f\\u0915\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0940 \\u0917\\u0941\\u092b\\u093e \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u092e\\u0942\\u0932\\u094d\\u092f \\u0924\\u092f \\u0915\\u0930\\u0928\\u093e \\u092f\\u093e \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928 \\u0915\\u094b\\u091f\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0940\\u092e\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e, \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u094b\\u0917\\u093f\\u0924\\u093e \\u0915\\u094b \\u0938\\u0940\\u092e\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u092a\\u094d\\u0930\\u0935\\u0930\\u094d\\u0924\\u0928 \\u092a\\u094d\\u0930\\u093e\\u0927\\u093f\\u0915\\u0930\\u0923: \\u0905\\u0928\\u0947\\u0915 \\u0938\\u0902\\u0918\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u094b \\u092a\\u0942\\u0930\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0909\\u0928\\u0915\\u093e \\u0909\\u0932\\u094d\\u0932\\u0902\\u0918\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0909\\u0926\\u093e\\u0939\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0938\\u0902\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0930\\u093e\\u091c\\u094d\\u092f \\u0905\\u092e\\u0947\\u0930\\u093f\\u0915\\u093e \\u092e\\u0947\\u0902 \\u0928\\u094d\\u092f\\u093e\\u092f \\u0935\\u093f\\u092d\\u093e\\u0917 (DOJ) \\u0914\\u0930 \\u092b\\u0947\\u0921\\u0930\\u0932 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930 \\u0906\\u092f\\u094b\\u0917 (FTC) \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u092a\\u094d\\u0930\\u0935\\u0930\\u094d\\u0924\\u0928 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0938\\u0939\\u092f\\u094b\\u0917: \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u093e \\u0917\\u094d\\u0932\\u094b\\u092c\\u0932 \\u092a\\u094d\\u0930\\u0938\\u0902\\u0938\\u094d\\u0915\\u0930\\u0923 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092c\\u0939\\u0941\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0915\\u0902\\u092a\\u0928\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0940\\u092e\\u093e\\u0902\\u0924 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u092e\\u0947\\u0902\\u0964 \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u092a\\u094d\\u0930\\u093e\\u0927\\u093f\\u0915\\u0930\\u0923\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u0939\\u092f\\u094b\\u0917 \\u0917\\u094d\\u0932\\u094b\\u092c\\u0932 \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u091a\\u093f\\u0902\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u0940 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u0902\\u092c\\u094b\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0909\\u092a\\u093e\\u092f \\u0914\\u0930 \\u0926\\u0902\\u0921: \\u090f\\u0902\\u091f\\u0940\\u091f\\u094d\\u0930\\u0938\\u094d\\u091f \\u0909\\u0932\\u094d\\u0932\\u0902\\u0918\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u092a\\u0924\\u093e \\u091a\\u0932\\u0924\\u0947 \\u0939\\u0940, \\u092a\\u094d\\u0930\\u0935\\u0930\\u094d\\u0924\\u0928 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0909\\u092a\\u093e\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0926\\u0902\\u0921\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u0948\\u0938\\u0947 \\u091c\\u0941\\u0930\\u094d\\u092e\\u093e\\u0928\\u0947, \\u0935\\u093f\\u092a\\u0923\\u0928, \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u092c\\u0926\\u0932\\u093e\\u0935\\u0947\\u0902<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>","ar":"\\u0645\\u062b\\u0644 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0646\\u0641\\u0627\\u0630 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0633\\u0648\\u0642.\\r\\n\\r\\n<p>\\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0645\\u0646\\u0639 \\u0627\\u0644\\u0627\\u062d\\u062a\\u0643\\u0627\\u0631\\u0627\\u062a: \\u064a\\u062d\\u0638\\u0631 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0623\\u0648 \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u062d\\u062a\\u0643\\u0627\\u0631\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u062f\\u062b \\u0639\\u0646\\u062f\\u0645\\u0627 \\u062a\\u0645\\u062a\\u0644\\u0643 \\u0634\\u0631\\u0643\\u0629 \\u0648\\u0627\\u062d\\u062f\\u0629 \\u0623\\u0648 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0633\\u064a\\u0637\\u0631\\u0629 \\u0643\\u0628\\u064a\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u0633\\u0648\\u0642 \\u0623\\u0648 \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0642\\u064a\\u062f \\u0627\\u0644\\u0627\\u062d\\u062a\\u0643\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0648\\u062a\\u0631\\u0641\\u0639 \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0648\\u062a\\u0642\\u0644\\u0644 \\u0645\\u0646 \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629: \\u064a\\u0633\\u062a\\u0647\\u062f\\u0641 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0642\\u064a\\u062f \\u0623\\u0648 \\u062a\\u0634\\u0648\\u0647 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629. \\u062a\\u0634\\u0645\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631 (\\u0627\\u0644\\u062a\\u0648\\u0627\\u0637\\u0624 \\u0644\\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631)\\u060c \\u0648\\u062a\\u0632\\u0648\\u064a\\u0631 \\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 (\\u062a\\u0632\\u0648\\u064a\\u0631 \\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0641\\u064a \\u0627\\u0644\\u0639\\u0642\\u0648\\u062f)\\u060c \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0627\\u0644\\u0633\\u0648\\u0642 (\\u062a\\u0642\\u0633\\u064a\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0648\\u0627\\u0642 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u064a\\u0646)\\u060c \\u0648\\u0627\\u0644\\u0631\\u0628\\u0637 (\\u0641\\u0631\\u0636 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0634\\u0631\\u0627\\u0621 \\u0645\\u0646\\u062a\\u062c \\u0648\\u0627\\u062d\\u062f \\u0643\\u0634\\u0631\\u0637 \\u0644\\u0634\\u0631\\u0627\\u0621 \\u0645\\u0646\\u062a\\u062c \\u0622\\u062e\\u0631).<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c\\u0627\\u062a \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630: \\u064a\\u0631\\u0627\\u062c\\u0639 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0648\\u064a\\u0646\\u0638\\u0645 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c\\u0627\\u062a \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630 \\u0644\\u0645\\u0646\\u0639 \\u0627\\u0644\\u062a\\u0623\\u062b\\u064a\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u062d\\u062a\\u0645\\u0644\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0639\\u064a\\u0642 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0642\\u062f \\u062a\\u0642\\u0644\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0643\\u0628\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0623\\u0648 \\u062a\\u0624\\u062f\\u064a \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0627\\u062d\\u062a\\u0643\\u0627\\u0631.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u062a\\u0645\\u064a\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631: \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0645\\u0633\\u0623\\u0644\\u0629 \\u062a\\u0645\\u064a\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631\\u060c \\u0627\\u0644\\u0630\\u064a \\u064a\\u062d\\u062f\\u062b \\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u0641\\u0631\\u0636 \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639 \\u0623\\u0633\\u0639\\u0627\\u0631\\u064b\\u0627 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0634\\u062a\\u0631\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0644\\u0641\\u064a\\u0646 \\u0644\\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0645\\u0627\\u062b\\u0644\\u0629\\u060c \\u0648\\u064a\\u0636\\u0631 \\u0628\\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643\\u064a\\u0646.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0628\\u062f\\u0627\\u062f\\u064a\\u0629: \\u064a\\u062d\\u0638\\u0631 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0628\\u062f\\u0627\\u062f\\u064a\\u0629\\u060c \\u062d\\u064a\\u062b \\u062a\\u062a\\u0648\\u0631\\u0637 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0633\\u0627\\u0626\\u062f\\u0629 \\u0641\\u064a \\u062a\\u0643\\u062a\\u064a\\u0643\\u0627\\u062a \\u0639\\u062f\\u0627\\u0626\\u064a\\u0629 \\u0644\\u0637\\u0631\\u062f \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u064a\\u0646 \\u0645\\u0646 \\u0627\\u0644\\u0633\\u0648\\u0642\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0624\\u062f\\u064a \\u0625\\u0644\\u0649 \\u062a\\u0642\\u0644\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0635\\u064a\\u0627\\u0646\\u0629 \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0639: \\u064a\\u0642\\u064a\\u062f \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0635\\u064a\\u0627\\u0646\\u0629 \\u0623\\u0633\\u0639\\u0627\\u0631 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0639\\u060c \\u062d\\u064a\\u062b \\u064a\\u062d\\u062f\\u062f \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0646\\u0639\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0645\\u0648\\u0632\\u0639\\u064a\\u0647\\u0627 \\u0623\\u0648 \\u0628\\u0627\\u0626\\u0639\\u064a\\u0647\\u0627 \\u0628\\u064a\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u0647\\u0627 \\u0628\\u0647\\u0627.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0643\\u0627\\u0631\\u062a\\u0644\\u0627\\u062a: \\u064a\\u0633\\u062a\\u0647\\u062f\\u0641 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0627\\u0644\\u0643\\u0627\\u0631\\u062a\\u0644\\u0627\\u062a\\u060c \\u0648\\u0647\\u064a \\u0627\\u062a\\u0641\\u0627\\u0642\\u0627\\u062a \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u064a\\u0646 \\u0644\\u062a\\u0646\\u0633\\u064a\\u0642 \\u0623\\u0641\\u0639\\u0627\\u0644\\u0647\\u0645\\u060c \\u0645\\u062b\\u0644 \\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631 \\u0623\\u0648 \\u062d\\u0635\\u0635 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0627\\u062c\\u060c \\u0644\\u062a\\u0642\\u064a\\u064a\\u062f \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u062a\\u0646\\u0641\\u064a\\u0630 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642: \\u062a\\u0645\\u062a\\u0644\\u0643 \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0628\\u0644\\u062f\\u0627\\u0646 \\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0645\\u062e\\u062a\\u0635\\u0629 \\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u062a\\u0646\\u0641\\u064a\\u0630 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0648\\u0627\\u0644\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0641\\u064a \\u0627\\u0646\\u062a\\u0647\\u0627\\u0643\\u0627\\u062a \\u0645\\u062d\\u062a\\u0645\\u0644\\u0629. \\u0639\\u0644\\u0649 \\u0633\\u0628\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062b\\u0627\\u0644\\u060c \\u0641\\u064a \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u062d\\u062f\\u0629\\u060c \\u062a\\u0639\\u062f \\u0648\\u0632\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0639\\u062f\\u0644 (DOJ) \\u0648\\u0627\\u0644\\u0645\\u0641\\u0648\\u0636\\u064a\\u0629 \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 \\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u062d\\u062f\\u0629 (FTC) \\u0647\\u064a \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062a\\u0639\\u0627\\u0648\\u0646 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a \\u0641\\u064a \\u0645\\u062c\\u0627\\u0644 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642: \\u062a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0644\\u0647\\u0627 \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u062a\\u0623\\u062b\\u064a\\u0631\\u0627\\u062a \\u0639\\u0627\\u0644\\u0645\\u064a\\u0629\\u060c \\u062e\\u0627\\u0635\\u0629 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0634\\u0631\\u0643\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0627\\u0644\\u062c\\u0646\\u0633\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u062d\\u062f\\u0648\\u062f. \\u0625\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0648\\u0646 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a \\u0628\\u064a\\u0646 \\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0623\\u0645\\u0631 \\u0628\\u0627\\u0644\\u063a \\u0627\\u0644\\u0623\\u0647\\u0645\\u064a\\u0629 \\u0644\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645\\u064a\\u0629 \\u0630\\u0627\\u062a \\u0627\\u0644\\u0635\\u0644\\u0629 \\u0628\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0628\\u0641\\u0639\\u0627\\u0644\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0648\\u0633\\u0627\\u0626\\u0644 \\u0648\\u0627\\u0644\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a: \\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u062a\\u0645 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0646\\u062a\\u0647\\u0627\\u0643\\u0627\\u062a \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0641\\u0631\\u0636 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0626\\u0644 \\u0648\\u0627\\u0644\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a\\u060c \\u0645\\u062b\\u0644 \\u0627\\u0644\\u063a\\u0631\\u0627\\u0645\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u062a\\u062e\\u0644\\u0635 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0635\\u0648\\u0644\\u060c \\u0648\\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0627\\u0644\\u0647\\u064a\\u0643\\u0644\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>"}',
                'icon' => NULL,
                'id' => 4,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Antitrust therapy","hi":"\\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938\\u0918\\u093e\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u0643\\u0627\\u0641\\u062d\\u0629 \\u0627\\u0644\\u0627\\u062d\\u062a\\u0643\\u0627\\u0631"}',
                'parent_category_id' => 4,
                'slug' => 'antitrust-therapy-4',
                'updated_at' => '2023-10-11 17:06:31',
            ),
            4 => 
            array (
                'created_at' => '2023-08-03 14:16:14',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Appellate practice refers to the legal process of appealing a court decision to a higher court. In most legal systems, parties have the right to appeal a judgment or order if they believe that errors were made in the trial court or lower tribunal. The appellate process aims to review the lower court&#39;s decision and determine if it was legally correct and fair based on the evidence and applicable therapy.<\\/p>\\r\\n\\r\\n<p>Key Aspects of Appellate Practice:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Appellate Jurisdiction: Appellate courts have the authority to hear appeals from lower courts or administrative tribunals. The specific jurisdiction and procedures for appeals are typically defined by therapy and may vary depending on the legal system and the type of case involved.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Notice of Appeal: To initiate the appellate process, the party seeking the appeal (appellant) must file a formal notice of appeal within a specified timeframe after the lower court&#39;s decision. This notice notifies the higher court of the intent to challenge the decision.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Record on Appeal: The appellant is required to compile and submit a record on appeal, which includes transcripts of the trial or hearing, evidence, exhibits, and the lower court&#39;s written decision. This record forms the basis for the appellate court&#39;s review.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Briefs: Both the appellant and the opposing party (appellee) are required to submit written briefs that present their legal arguments and address the issues on appeal. The briefs provide a comprehensive analysis of the relevant therapy and how it applies to the facts of the case.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Oral Arguments: In many appellate courts, the parties are given the opportunity to present oral arguments before the appellate panel. During oral arguments, attorneys can further explain their positions and answer questions from the judges.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Appellate Review: The appellate court reviews the lower court&#39;s decision to determine if any errors of therapy were made or if the decision was supported by the evidence presented during the trial. The appellate court does not re-try the case or consider new evidence.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Standards of Review: Appellate courts generally apply different standards of review depending on the type of issue being appealed. For questions of therapy, the standard of review is typically de novo (completely fresh review), while for factual determinations, the standard may be more deferential.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Remedies: If the appellate court finds errors in the lower court&#39;s decision, it may remand the case back to the trial court for a new trial or corrective action. Alternatively, the appellate court may reverse or affirm the lower court&#39;s decision.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Finality: The decision of the appellate court is generally final, although in some cases, parties may have the option to seek further review by a higher court, such as a state&#39;s highest court or a country&#39;s supreme court.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Appellate practice requires specialized skills in legal research, writing persuasive arguments, and effective oral advocacy. Appellate attorneys or appellate specialists are experienced in handling appeals and navigating the complexities of the appellate process to seek the best possible outcome for their clients.<\\/p>","hi":"<p>\\u0905\\u092a\\u0940\\u0932 \\u0915\\u093e\\u0930\\u094d\\u092f \\u092a\\u0926\\u094d\\u0927\\u0924\\u093f \\u0909\\u091a\\u094d\\u091a\\u0924\\u092e \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0905\\u0926\\u093e\\u0932\\u0924 \\u0915\\u094b \\u090f\\u0915 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0915\\u093e \\u092b\\u0948\\u0938\\u0932\\u093e \\u0905\\u092a\\u0940\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u094b \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0902\\u0936 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0924\\u0902\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0927\\u0940\\u0928\\u0938\\u094d\\u0925 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u092f\\u093e \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u091f\\u094d\\u0930\\u093f\\u092c\\u094d\\u092f\\u0942\\u0928\\u0932 \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0930\\u0941\\u091f\\u093f\\u092f\\u093e\\u0901 \\u0939\\u094b \\u0917\\u0908 \\u0939\\u0948\\u0902 \\u092f\\u093e \\u0935\\u0947 \\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0915\\u093f \\u0915\\u093f\\u0938\\u0940 \\u0924\\u094d\\u0930\\u0941\\u091f\\u093f \\u0915\\u0940 \\u0935\\u091c\\u0939 \\u0938\\u0947 \\u0909\\u0928\\u0915\\u0947 \\u0916\\u093f\\u0932\\u093e\\u092b \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u092f\\u093e \\u0906\\u0926\\u0947\\u0936 \\u0939\\u0941\\u0906 \\u0939\\u0948, \\u0924\\u094b \\u0909\\u0928\\u0915\\u0947 \\u092a\\u093e\\u0938 \\u0905\\u092a\\u0940\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0905\\u092a\\u0940\\u0932 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0928\\u093f\\u091a\\u0932\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e \\u0914\\u0930 \\u092f\\u0939 \\u0924\\u092f \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092f\\u0939 \\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u0914\\u0930 \\u092f\\u094b\\u0917\\u094d\\u092f \\u0938\\u093e\\u0915\\u094d\\u0937\\u094d\\u092f \\u0914\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928\\u093f\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u0939\\u0940 \\u0914\\u0930 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0925\\u093e\\u0964<\\/p>\\r\\n<p>\\u0905\\u092a\\u0940\\u0932 \\u092a\\u094d\\u0930\\u0948\\u0915\\u094d\\u091f\\u093f\\u0938 \\u0915\\u0947 \\u0915\\u0941\\u091b \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u090f\\u0901:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0927\\u093f\\u0915\\u0930\\u0923: \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924\\u094b\\u0902 \\u0915\\u094b \\u0905\\u0927\\u0940\\u0928\\u0938\\u094d\\u0925 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f\\u094b\\u0902 \\u092f\\u093e \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u091f\\u094d\\u0930\\u093f\\u092c\\u094d\\u092f\\u0942\\u0928\\u0932\\u094b\\u0902 \\u0938\\u0947 \\u0905\\u092a\\u0940\\u0932 \\u0938\\u0941\\u0928\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0905\\u092a\\u0940\\u0932 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0905\\u0927\\u093f\\u0915\\u0930\\u0923 \\u0914\\u0930 \\u0909\\u0926\\u094d\\u092f\\u092e\\u093f\\u0924\\u093e\\u090f\\u0901 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f\\u0924: \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u0930\\u093f\\u092d\\u093e\\u0937\\u093f\\u0924 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u092f\\u0939 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0924\\u0902\\u0924\\u094d\\u0930 \\u0914\\u0930 \\u092e\\u093e\\u092e\\u0932\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u092a\\u0940\\u0932 \\u0915\\u0940 \\u0938\\u0942\\u091a\\u0928\\u093e: \\u0905\\u092a\\u0940\\u0932 \\u091a\\u093e\\u0939\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092a\\u0915\\u094d\\u0937 (\\u0905\\u092a\\u0940\\u0932\\u0940\\u092f\\u0915\\u0930\\u094d\\u0924\\u093e) \\u0915\\u094b \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0915\\u0947 \\u092c\\u093e\\u0926 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0938\\u092e\\u092f\\u0938\\u0940\\u092e\\u093e \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u090f\\u0915 \\u0914\\u092a\\u091a\\u093e\\u0930\\u093f\\u0915 \\u0905\\u092a\\u0940\\u0932 \\u0938\\u0942\\u091a\\u0928\\u093e \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0928\\u0940 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0909\\u091a\\u094d\\u091a\\u0924\\u092e \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u094b \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0915\\u094b \\u0935\\u093f\\u0935\\u093e\\u0926\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0907\\u091a\\u094d\\u091b\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u092a\\u0940\\u0932 \\u092a\\u0930 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921: \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u094b \\u0905\\u092a\\u0940\\u0932 \\u092a\\u0930 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921 \\u0924\\u0948\\u092f\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0924\\u0925\\u094d\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0935\\u093f\\u0935\\u0930\\u0923, \\u092a\\u094d\\u0930\\u092e\\u093e\\u0923, \\u092a\\u094d\\u0930\\u0926\\u0930\\u094d\\u0936\\u0928\\u0940 \\u0914\\u0930 \\u0928\\u093f\\u091a\\u0932\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u093e \\u0932\\u093f\\u0916\\u093f\\u0924 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921 \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0927\\u093e\\u0930 \\u092c\\u0928\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092c\\u094d\\u0930\\u0940\\u092b\\u094d\\u0938: \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f\\u0915\\u0930\\u094d\\u0924\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0930\\u094b\\u0927\\u0940 \\u092a\\u0915\\u094d\\u0937 (\\u0905\\u092a\\u0940\\u0932\\u0940) \\u0926\\u094b\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093f\\u0916\\u093f\\u0924 \\u092c\\u094d\\u0930\\u0940\\u092b\\u094d\\u0938 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0909\\u0928\\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0905\\u092a\\u0940\\u0932 \\u092a\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092c\\u094d\\u0930\\u0940\\u092b\\u094d\\u0938 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0935\\u093f\\u0927\\u093e\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u090f\\u0915 \\u0935\\u094d\\u092f\\u093e\\u092a\\u0915 \\u0935\\u093f\\u0936\\u094d\\u0932\\u0947\\u0937\\u0923 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u092f\\u0939 \\u092c\\u0924\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0915\\u093f \\u0915\\u093f\\u0938 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u0914\\u0930 \\u092f\\u0939 \\u0915\\u093f\\u0938 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0924\\u0925\\u094d\\u092f\\u094b\\u0902 \\u092a\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092e\\u094c\\u0916\\u093f\\u0915 \\u0924\\u0930\\u094d\\u0915: \\u092c\\u0939\\u0941\\u0924 \\u0938\\u0940 \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u092a\\u0948\\u0928\\u0932 \\u0915\\u0947 \\u0938\\u093e\\u092e\\u0928\\u0947 \\u092e\\u094c\\u0916\\u093f\\u0915 \\u0924\\u0930\\u094d\\u0915 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0935\\u0938\\u0930 \\u0926\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092e\\u094c\\u0916\\u093f\\u0915 \\u0924\\u0930\\u094d\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928, \\u0935\\u0915\\u0940\\u0932 \\u0905\\u092a\\u0928\\u0947 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0914\\u0930 \\u091c\\u091c\\u094b\\u0902 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u0924\\u0930 \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0935\\u0938\\u0930 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e: \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924 \\u0928\\u093f\\u091a\\u0932\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948 \\u0924\\u093e\\u0915\\u093f \\u092f\\u0926\\u093f \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0924\\u094d\\u0930\\u0941\\u091f\\u093f\\u092f\\u093e\\u0901 \\u0939\\u0941\\u0908\\u0902 \\u0925\\u0940\\u0902 \\u092f\\u093e \\u092f\\u0926\\u093f \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924\\u093f \\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0938\\u093e\\u0915\\u094d\\u0937\\u094d\\u092f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0925\\u093e\\u0964 \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924 \\u092e\\u093e\\u092e\\u0932\\u093e \\u092b\\u093f\\u0930 \\u0938\\u0947 \\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0924\\u0940 \\u0914\\u0930 \\u0928\\u090f \\u0938\\u093e\\u0915\\u094d\\u0937\\u094d\\u092f \\u0915\\u094b \\u092d\\u0940 \\u0928\\u0939\\u0940\\u0902 \\u0935\\u093f\\u091a\\u093e\\u0930\\u0924\\u0940\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u092e\\u093e\\u0928\\u0915: \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924\\u0947\\u0902 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f\\u0924: \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0905\\u092a\\u0940\\u0932 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u091c\\u094b \\u0905\\u092a\\u0940\\u0932 \\u0915\\u093f\\u092f\\u0947 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0915\\u093e \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u094d\\u0930\\u0936\\u094d\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f\\u0924: \\u092e\\u093e\\u0928\\u0915 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0939\\u0948 (\\u092a\\u0942\\u0930\\u0940 \\u0924\\u0930\\u0939 \\u0938\\u0947 \\u0924\\u093e\\u091c\\u0917\\u0940 \\u0938\\u0947 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e), \\u091c\\u092c\\u0915\\u093f \\u0924\\u0925\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u093e\\u0928\\u0915 \\u0905\\u0927\\u093f\\u0915 \\u0906\\u091c\\u094d\\u091e\\u093e\\u0935\\u0932\\u0940 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0909\\u092a\\u093e\\u092f: \\u092f\\u0926\\u093f \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924 \\u0928\\u093f\\u091a\\u0932\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u092e\\u0947\\u0902 \\u0924\\u094d\\u0930\\u0941\\u091f\\u093f\\u092f\\u093e\\u0901 \\u092e\\u093f\\u0932\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0935\\u0939 \\u092e\\u093e\\u092e\\u0932\\u093e \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093e\\u092a\\u0938 \\u0928\\u093f\\u091a\\u0932\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u094b \\u092a\\u094d\\u0930\\u0947\\u0937\\u093f\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948 \\u092f\\u093e \\u0909\\u0938\\u0947 \\u0928\\u093f\\u091a\\u0932\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0915\\u094b \\u092a\\u0932\\u091f \\u0926\\u0947\\u0928\\u0947 \\u092f\\u093e \\u092a\\u0941\\u0937\\u094d\\u091f\\u093f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0915\\u0940 \\u0905\\u0902\\u0924\\u0924\\u093e: \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u0926\\u093e\\u0932\\u0924 \\u0915\\u093e \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0905\\u0902\\u0924\\u093f\\u092e \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948, \\u0939\\u093e\\u0932\\u093e\\u0902\\u0915\\u093f \\u0915\\u0941\\u091b \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u090f\\u0915 \\u0909\\u091a\\u094d\\u091a \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f, \\u091c\\u0948\\u0938\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u0930\\u093e\\u091c\\u094d\\u092f \\u0915\\u093e \\u0909\\u091a\\u094d\\u091a\\u0924\\u092e \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u092f\\u093e \\u0915\\u093f\\u0938\\u0940 \\u0926\\u0947\\u0936 \\u0915\\u093e \\u0938\\u0930\\u094d\\u0935\\u094b\\u091a\\u094d\\u091a \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f, \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0906\\u0917\\u0947 \\u091c\\u093e\\u0902\\u091a \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u092e\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0928\\u0941\\u0938\\u0902\\u0927\\u093e\\u0928, \\u092a\\u0930\\u094d\\u0938\\u094d\\u0935-\\u0932\\u0947\\u0916\\u0928 \\u092a\\u094d\\u0930\\u0947\\u0930\\u093f\\u0924 \\u0924\\u0930\\u094d\\u0915 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u0940 \\u092e\\u094c\\u0916\\u093f\\u0915 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924\\u093f \\u0915\\u094c\\u0936\\u0932\\u094b\\u0902 \\u0915\\u0940 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e\\u0924\\u093e \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0935\\u0915\\u0940\\u0932 \\u092f\\u093e \\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e \\u0905\\u092a\\u0940\\u0932\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u092c\\u094b\\u0927\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0905\\u092a\\u0940\\u0932 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0940 \\u091c\\u091f\\u093f\\u0932\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0938\\u0902\\u091a\\u093e\\u0932\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0928\\u0941\\u092d\\u0935\\u0940 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0909\\u0928\\u0915\\u0947 \\u0917\\u094d\\u0930\\u093e\\u0939\\u0915\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0930\\u094d\\u0935\\u094b\\u0924\\u094d\\u0924\\u092e \\u092a\\u0930\\u093f\\u0923\\u093e\\u092e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947\\u0964<\\/p>","ar":"<p>\\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0623\\u0645\\u0627\\u0645 \\u0645\\u062d\\u0643\\u0645\\u0629 \\u0623\\u0639\\u0644\\u0649. \\u0641\\u064a \\u0645\\u0639\\u0638\\u0645 \\u0627\\u0644\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629\\u060c \\u0644\\u062f\\u0649 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u062d\\u0642 \\u0641\\u064a \\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u062d\\u0643\\u0645 \\u0623\\u0648 \\u0642\\u0631\\u0627\\u0631 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u0648\\u0627 \\u064a\\u0639\\u062a\\u0642\\u062f\\u0648\\u0646 \\u0623\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u0623\\u062e\\u0637\\u0627\\u0621 \\u062a\\u0645 comdemned \\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649. \\u062a\\u0647\\u062f\\u0641 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0625\\u0644\\u0649 \\u0627\\u0633\\u062a\\u0639\\u0631\\u0627\\u0636 \\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649 \\u0648\\u062a\\u062d\\u062f\\u064a\\u062f \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u0635\\u062d\\u064a\\u062d\\u064b\\u0627 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u064b\\u0627 \\u0648\\u0639\\u0627\\u062f\\u0644\\u064b\\u0627 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u062f\\u0644\\u0629 \\u0648\\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0633\\u0627\\u0631\\u064a.<\\/p>\\r\\n<p>\\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0627\\u062e\\u062a\\u0635\\u0627\\u0635 \\u0641\\u064a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641: \\u0644\\u062f\\u0649 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0643\\u0645 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0644\\u0633\\u0645\\u0627\\u0639 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u0627\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0643\\u0645 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629. \\u0639\\u0627\\u062f\\u0629 \\u0645\\u0627 \\u064a\\u062a\\u0645 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0627\\u062e\\u062a\\u0635\\u0627\\u0635 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0648\\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0644\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0628\\u0648\\u0627\\u0633\\u0637\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0648\\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u0642\\u0636\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0646\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0625\\u0634\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641: \\u0644\\u0628\\u062f\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u060c \\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0631\\u0627\\u063a\\u0628 \\u0641\\u064a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 (\\u0627\\u0644\\u0645\\u0633\\u062a\\u0623\\u0646\\u0641) \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0625\\u0634\\u0639\\u0627\\u0631 \\u0631\\u0633\\u0645\\u064a \\u0628\\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u0632\\u0645\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629 \\u0628\\u0639\\u062f \\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649. \\u064a\\u064f\\u062e\\u0637\\u0631 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0625\\u0634\\u0639\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0639\\u0644\\u064a\\u0627 \\u0628\\u0646\\u064a\\u0629 \\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0642\\u0631\\u0627\\u0631.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0633\\u062c\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641: \\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0623\\u0646\\u0641 \\u062a\\u062c\\u0645\\u064a\\u0639 \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0633\\u062c\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u060c \\u0627\\u0644\\u0630\\u064a \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0645\\u062d\\u0627\\u0636\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062c\\u0644\\u0633\\u0629\\u060c \\u0648\\u0627\\u0644\\u0623\\u062f\\u0644\\u0629\\u060c \\u0648\\u0627\\u0644\\u0645\\u0639\\u0631\\u0648\\u0636\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0643\\u062a\\u0627\\u0628\\u064a \\u0644\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649. \\u064a\\u0634\\u0643\\u0644 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0633\\u062c\\u0644 \\u0623\\u0633\\u0627\\u0633 \\u0627\\u0633\\u062a\\u0639\\u0631\\u0627\\u0636 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u0630\\u0643\\u0631\\u0627\\u062a: \\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0643\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0623\\u0646\\u0641 \\u0648\\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0622\\u062e\\u0631 (\\u0627\\u0644\\u0645\\u0633\\u062a\\u0623\\u0646\\u0641) \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0645\\u0630\\u0643\\u0631\\u0627\\u062a \\u0643\\u062a\\u0627\\u0628\\u064a\\u0629 \\u062a\\u0642\\u062f\\u0645 \\u062d\\u062c\\u062c\\u0647\\u0645 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u062a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0623\\u0646\\u0641\\u0629. \\u062a\\u0648\\u0641\\u0631 \\u0627\\u0644\\u0645\\u0630\\u0643\\u0631\\u0627\\u062a \\u062a\\u062d\\u0644\\u064a\\u0644\\u064b\\u0627 \\u0634\\u0627\\u0645\\u0644\\u0627\\u064b \\u0644\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0630\\u064a \\u0627\\u0644\\u0635\\u0644\\u0629 \\u0648\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0637\\u0628\\u064a\\u0642\\u0647 \\u0639\\u0644\\u0649 \\u062d\\u0642\\u0627\\u0626\\u0642 \\u0627\\u0644\\u0642\\u0636\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062d\\u062c\\u062c \\u0627\\u0644\\u0634\\u0641\\u0648\\u064a\\u0629: \\u0641\\u064a \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0643\\u0645 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629\\u060c \\u064a\\u062a\\u0645 \\u0645\\u0646\\u062d \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0641\\u0631\\u0635\\u0629 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062d\\u062c\\u062c \\u0627\\u0644\\u0634\\u0641\\u0648\\u064a\\u0629 \\u0623\\u0645\\u0627\\u0645 \\u0627\\u0644\\u0644\\u062c\\u0646\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629. \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062d\\u062c\\u062c \\u0627\\u0644\\u0634\\u0641\\u0648\\u064a\\u0629\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u062d\\u0627\\u0645\\u064a\\u0646 \\u0634\\u0631\\u062d \\u0645\\u0648\\u0627\\u0642\\u0641\\u0647\\u0645 \\u0628\\u0645\\u0632\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u062a\\u0641\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u0625\\u062c\\u0627\\u0628\\u0629 \\u0639\\u0644\\u0649 \\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0642\\u0636\\u0627\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641: \\u062a\\u0633\\u062a\\u0639\\u0631\\u0636 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629 \\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649 \\u0644\\u062a\\u062d\\u062f\\u064a\\u062f \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0647\\u0646\\u0627\\u0643 \\u0623\\u062e\\u0637\\u0627\\u0621 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u062a\\u0645 comdemned \\u0623\\u0648 \\u0645\\u0627 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u0627\\u0644\\u0642\\u0631\\u0627\\u0631 \\u0645\\u062f\\u0639\\u0648\\u0645\\u064b\\u0627 \\u0628\\u0627\\u0644\\u0623\\u062f\\u0644\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0642\\u062f\\u0645\\u062a \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0643\\u0645\\u0629. \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629 \\u0644\\u0627 \\u062a\\u0639\\u064a\\u062f \\u0645\\u062d\\u0627\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0642\\u0636\\u064a\\u0629 \\u0623\\u0648 \\u062a\\u0646\\u0638\\u0631 \\u0641\\u064a \\u0623\\u062f\\u0644\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629: \\u062a\\u0637\\u0628\\u0642 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0643\\u0645 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629 \\u0639\\u0645\\u0648\\u0645\\u064b\\u0627 \\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0646\\u0648\\u0639 \\u0627\\u0644\\u0642\\u0636\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0623\\u0646\\u0641\\u0629. \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u060c \\u0641\\u0625\\u0646 \\u0645\\u0639\\u064a\\u0627\\u0631 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0647\\u0648 \\u0639\\u0627\\u062f\\u0629\\u064b de novo (\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0643\\u0627\\u0645\\u0644\\u0629)\\u060c \\u0628\\u064a\\u0646\\u0645\\u0627 \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0645\\u0639\\u064a\\u0627\\u0631 \\u0623\\u0643\\u062b\\u0631 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u0627\\u064b \\u0644\\u062a\\u062d\\u062f\\u064a\\u062f\\u0627\\u062a \\u0627\\u0644\\u062d\\u0642\\u0627\\u0626\\u0642.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0629: \\u0625\\u0630\\u0627 \\u0648\\u062c\\u062f\\u062a \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629 \\u0623\\u062e\\u0637\\u0627\\u0621 \\u0641\\u064a \\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649\\u060c \\u0641\\u0642\\u062f \\u062a\\u062d\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0633\\u0623\\u0644\\u0629 \\u0645\\u0631\\u0629 \\u0623\\u062e\\u0631\\u0649 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0645\\u062d\\u0627\\u0643\\u0645\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u0648 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u062a\\u0635\\u062d\\u064a\\u062d\\u064a. \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u062a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629 \\u0628\\u0625\\u0644\\u063a\\u0627\\u0621 \\u0623\\u0648 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0633\\u0641\\u0644\\u0649.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0627\\u0646\\u062a\\u0647\\u0627\\u0621: \\u0639\\u0627\\u062f\\u0629\\u064b \\u0645\\u0627 \\u064a\\u0643\\u0648\\u0646 \\u0642\\u0631\\u0627\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u064a\\u0629 \\u0646\\u0647\\u0627\\u0626\\u064a\\u064b\\u0627\\u060c \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0631\\u063a\\u0645 \\u0645\\u0646 \\u0623\\u0646\\u0647 \\u0641\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0644\\u062f\\u0649 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u062e\\u064a\\u0627\\u0631 \\u0644\\u0637\\u0644\\u0628 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0625\\u0636\\u0627\\u0641\\u064a\\u0629 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0645\\u062d\\u0643\\u0645\\u0629 \\u0623\\u0639\\u0644\\u0649\\u060c \\u0645\\u062b\\u0644 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u062d\\u0643\\u0645\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0639\\u0644\\u064a\\u0627 \\u0644\\u0644\\u0628\\u0644\\u062f.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u062a\\u062a\\u0637\\u0644\\u0628 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0645\\u0647\\u0627\\u0631\\u0627\\u062a \\u0645\\u062a\\u062e\\u0635\\u0635\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0628\\u062d\\u062b \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u060c \\u0648\\u0643\\u062a\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062d\\u062c\\u062c \\u0627\\u0644\\u0645\\u0642\\u0646\\u0639\\u0629\\u060c \\u0648\\u0627\\u0644\\u062e\\u0637\\u0628\\u0629 \\u0627\\u0644\\u0634\\u0641\\u0648\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0639\\u0627\\u0644\\u0629. \\u0627\\u0644\\u0645\\u062d\\u0627\\u0645\\u0648\\u0646 \\u0627\\u0644\\u0645\\u062a\\u062e\\u0635\\u0635\\u0648\\u0646 \\u0641\\u064a \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0623\\u0648 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0641\\u064a \\u0645\\u062c\\u0627\\u0644 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0644\\u062f\\u064a\\u0647\\u0645 \\u062e\\u0628\\u0631\\u0629 \\u0641\\u064a \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0646\\u0642\\u0644 \\u0641\\u064a \\u062a\\u0639\\u0642\\u064a\\u062f\\u0627\\u062a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641 \\u0644\\u0633\\u0639\\u064a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0641\\u0636\\u0644 \\u0646\\u062a\\u064a\\u062c\\u0629 \\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0647\\u0645.<\\/p>"}',
                'icon' => NULL,
                'id' => 5,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Appellate practice","hi":"\\u0905\\u092a\\u0940\\u0932\\u0940\\u092f \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938","ar":"\\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0626\\u0646\\u0627\\u0641"}',
                'parent_category_id' => 2,
                'slug' => 'appellate-practice-5',
                'updated_at' => '2023-10-11 16:45:14',
            ),
            5 => 
            array (
                'created_at' => '2023-08-08 11:34:00',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Agency therapy refers to the area of therapy that deals with the legal relationship between two parties, where one party (the agent) acts on behalf of and under the control of the other party (the principal). This relationship gives rise to certain rights, duties, and liabilities between the principal and the agent.<\\/p>\\r\\n\\r\\n<p>Key concepts and principles of agency therapy include:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p><strong>Principal-Agent Relationship:<\\/strong> This is the core concept of agency therapy, where one party (the principal) grants authority to another party (the agent) to act on their behalf. The agent performs tasks or makes decisions that affect the legal rights and duties of the principal.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Authority:<\\/strong> Authority can be actual or apparent. Actual authority is when the principal explicitly grants the agent the power to act on their behalf, either orally or in writing. Apparent authority arises when a third party reasonably believes that the agent has the authority to act on behalf of the principal, even if such authority was not explicitly granted.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Duties of the Agent:<\\/strong> Agents owe certain duties to their principals, including the duty of loyalty (acting solely in the principal&#39;s interest), the duty of obedience (following the principal&#39;s instructions), the duty of care (exercising reasonable care and skill), and the duty to account for any transactions or funds handled on behalf of the principal.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Duties of the Principal:<\\/strong> Principals also have responsibilities, including compensating the agent for their services and indemnifying the agent for any losses incurred while acting within the scope of their authority.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Termination of Agency:<\\/strong> The agency relationship can be terminated by the mutual agreement of the parties, the expiration of a specific time period, the completion of the agent&#39;s tasks, the death or incapacity of either party, or through the unilateral termination by one party (if allowed by the terms of the agency agreement).<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Liability:<\\/strong> Generally, a principal is liable for the actions of their agent if those actions were within the scope of the agent&#39;s authority and were carried out in the course of the agency relationship. However, certain acts of agents that exceed their authority might not bind the principal.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Ratification:<\\/strong> Sometimes, an agent may exceed their authority but the principal may choose to accept the unauthorized action, which is known as ratification. In such cases, the principal becomes bound by the agent&#39;s actions as if they were originally authorized.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Agency therapy has a significant impact in various areas, including business transactions, employment relationships, real estate, and more. It helps define the rights and responsibilities of both parties in the principal-agent relationship, providing a legal framework for conducting business and other activities through agents.<\\/p>","hi":"<p>\\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u090f\\u0915 \\u0910\\u0938\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0915\\u094b \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0909\\u0928 \\u0926\\u094b \\u092a\\u0915\\u094d\\u0937\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0902\\u092c\\u0902\\u0927\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0939\\u093e\\u0901 \\u090f\\u0915 \\u092a\\u0915\\u094d\\u0937 (\\u090f\\u091c\\u0947\\u0902\\u091f) \\u0926\\u0942\\u0938\\u0930\\u0947 \\u092a\\u0915\\u094d\\u0937 (\\u092e\\u0941\\u0916\\u094d\\u092f) \\u0915\\u0947 \\u0905\\u0927\\u0940\\u0928 \\u0914\\u0930 \\u0909\\u0928\\u0915\\u0940 \\u0928\\u093f\\u0917\\u0930\\u093e\\u0928\\u0940 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u092e \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0941\\u0916\\u094d\\u092f \\u0914\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902, \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f\\u094b\\u0902, \\u0914\\u0930 \\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935\\u094b\\u0902 \\u0915\\u093e \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u093e \\u0915\\u093e\\u0930\\u0923 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n<p>\\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0914\\u0930 \\u0938\\u093f\\u0926\\u094d\\u0927\\u093e\\u0902\\u0924 \\u0928\\u093f\\u092e\\u094d\\u0928\\u0932\\u093f\\u0916\\u093f\\u0924 \\u0939\\u0948\\u0902:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u092e\\u0941\\u0916\\u094d\\u092f-\\u090f\\u091c\\u0947\\u0902\\u091f \\u0938\\u0902\\u092c\\u0902\\u0927:<\\/strong> \\u092f\\u0939 \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0940 \\u092e\\u094c\\u0932\\u093f\\u0915 \\u0905\\u0935\\u0927\\u093e\\u0930\\u0923\\u093e \\u0939\\u0948, \\u091c\\u0939\\u093e\\u0901 \\u090f\\u0915 \\u092a\\u0915\\u094d\\u0937 (\\u092e\\u0941\\u0916\\u094d\\u092f) \\u0926\\u0942\\u0938\\u0930\\u0947 \\u092a\\u0915\\u094d\\u0937 (\\u090f\\u091c\\u0947\\u0902\\u091f) \\u0915\\u094b \\u0909\\u0928\\u0915\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u090f\\u091c\\u0947\\u0902\\u091f \\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0928\\u093f\\u0930\\u094d\\u0935\\u0939\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0905\\u0927\\u093f\\u0915\\u093e\\u0930:<\\/strong> \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u092f\\u093e \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u093f\\u0924 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0935\\u0939 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0939\\u0948 \\u091c\\u092c \\u092e\\u0941\\u0916\\u094d\\u092f \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0930\\u0942\\u092a \\u0938\\u0947 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0909\\u0928\\u0915\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0936\\u0915\\u094d\\u0924\\u093f \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u092c\\u094b\\u0932\\u0940 \\u092f\\u093e \\u0932\\u093f\\u0916\\u0940 \\u0930\\u0942\\u092a \\u0938\\u0947\\u0964 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092f\\u093f\\u0924 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0935\\u0939\\u093e\\u0901 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u091c\\u092c \\u0924\\u0940\\u0938\\u0930\\u093e \\u092a\\u0915\\u094d\\u0937 \\u092f\\u0939 \\u0938\\u092e\\u091d\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0939\\u0948, \\u0939\\u093e\\u0932\\u093e\\u0902\\u0915\\u093f \\u0910\\u0938\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0940 \\u0917\\u0908 \\u0925\\u0940\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f:<\\/strong> \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0905\\u092a\\u0928\\u0947 \\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0924\\u093f \\u0915\\u0941\\u091b \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0935\\u092b\\u093e\\u0926\\u093e\\u0930\\u0940 \\u0915\\u093e \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f (\\u0915\\u0947\\u0935\\u0932 \\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0947 \\u0939\\u093f\\u0924 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0928\\u093e), \\u0906\\u091c\\u094d\\u091e\\u093e \\u0915\\u093e \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f (\\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0940 \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u093e), \\u0926\\u0947\\u0916\\u092d\\u093e\\u0932 \\u0915\\u093e \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f (\\u092f\\u094b\\u0917\\u094d\\u092f \\u0926\\u0947\\u0916\\u092d\\u093e\\u0932 \\u0914\\u0930 \\u0915\\u094c\\u0936\\u0932 \\u0915\\u093e \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938 \\u0915\\u0930\\u0928\\u093e) \\u0914\\u0930 \\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u092e\\u0947\\u0902 \\u0938\\u094c\\u0926\\u094b\\u0902 \\u092f\\u093e \\u0928\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0932\\u0928\\u0947 \\u0915\\u093e \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0947 \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f:<\\/strong> \\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u0947 \\u092d\\u0940 \\u0915\\u0941\\u091b \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u093e\\u0901 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0909\\u0928\\u0915\\u0940 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0941\\u0906\\u0935\\u091c\\u093e \\u0926\\u0947\\u0928\\u093e \\u0914\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u094b \\u0909\\u0928\\u0915\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0915\\u0947 \\u0906\\u0927\\u0940\\u0928 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0924\\u0947 \\u0938\\u092e\\u092f \\u0939\\u0941\\u090f \\u0928\\u0941\\u0915\\u0938\\u093e\\u0928\\u094b\\u0902 \\u0915\\u093e \\u092c\\u0926\\u0932\\u093e \\u0926\\u0947\\u0928\\u093e \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u093e \\u0938\\u092e\\u093e\\u092a\\u0928:<\\/strong> \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u0938\\u092e\\u093e\\u092a\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948 \\u0926\\u094b \\u092a\\u0915\\u094d\\u0937\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0902\\u0935\\u093f\\u0926\\u093e\\u0928\\u093f\\u0915 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947, \\u090f\\u0915 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0938\\u092e\\u092f \\u0905\\u0935\\u0927\\u093f \\u0915\\u0940 \\u0938\\u092e\\u093e\\u092a\\u0928, \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u092e\\u093e\\u092a\\u0928, \\u0926\\u094b\\u0928\\u094b\\u0902 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0938\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u090f\\u0915 \\u0915\\u0940 \\u092e\\u0943\\u0924\\u094d\\u092f\\u0941 \\u092f\\u093e \\u0905\\u0915\\u094d\\u0937\\u092e\\u0924\\u093e, \\u092f\\u093e \\u0935\\u093f\\u092d\\u093e\\u0917 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u0947 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935:<\\/strong> \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930, \\u090f\\u0915 \\u092e\\u0941\\u0916\\u094d\\u092f \\u0905\\u092a\\u0928\\u0947 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0940 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u0924\\u094d\\u0924\\u0930\\u0926\\u093e\\u0924\\u093e \\u0939\\u0948 \\u092f\\u0926\\u093f \\u0935\\u0947 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0915\\u0940 \\u0938\\u0940\\u092e\\u093e \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0939\\u0941\\u090f \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0938\\u0902\\u092c\\u0902\\u0927 \\u0915\\u0947 \\u0915\\u093e\\u0930\\u094d\\u092f \\u0915\\u093f\\u090f \\u0917\\u090f \\u0939\\u0948\\u0902\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0902\\u0915\\u093f, \\u0910\\u0938\\u0947 \\u0915\\u0941\\u091b \\u0915\\u093e\\u0930\\u094d\\u092f \\u091c\\u094b \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0938\\u0947 \\u0905\\u0927\\u093f\\u0936\\u0947\\u0937 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u092e\\u0941\\u0916\\u094d\\u092f \\u0915\\u094b \\u092c\\u093e\\u0902\\u0927\\u0928\\u0947 \\u0915\\u0940 \\u0915\\u094d\\u0937\\u092e\\u0924\\u093e \\u0928\\u0939\\u0940\\u0902 \\u0930\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u092e\\u0902\\u091c\\u0942\\u0930\\u0940:<\\/strong> \\u0915\\u092d\\u0940-\\u0915\\u092d\\u0940, \\u090f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u091f \\u0905\\u092a\\u0928\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0938\\u0947 \\u0905\\u0927\\u093f\\u0915 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u0932\\u0947\\u0915\\u093f\\u0928 \\u092e\\u0941\\u0916\\u094d\\u092f \\u0909\\u0938 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924 \\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0935\\u0932\\u0940 \\u0915\\u094b \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0947 \\u0938\\u092e\\u093e\\u092a\\u094d\\u0924\\u093f \\u0915\\u0939\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0938 \\u0924\\u0930\\u0939 \\u0915\\u0947 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u092e\\u0941\\u0916\\u094d\\u092f \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0938\\u0947 \\u092c\\u093e\\u0927\\u093f\\u0924 \\u0939\\u094b \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u0915\\u093f \\u092f\\u0926\\u093f \\u0935\\u0947 \\u092e\\u094c\\u0932\\u093f\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924 \\u0925\\u0947\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935 \\u0921\\u093e\\u0932\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928, \\u0909\\u092a\\u092f\\u094b\\u0917-\\u092a\\u094d\\u0930\\u092f\\u094b\\u0917 \\u0938\\u0902\\u092c\\u0902\\u0927, \\u0905\\u091a\\u0932 \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f, \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0915\\u0964 \\u092f\\u0939 \\u092e\\u0941\\u0916\\u094d\\u092f-\\u090f\\u091c\\u0947\\u0902\\u091f \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0926\\u094b\\u0928\\u094b\\u0902 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092a\\u0930\\u093f\\u092d\\u093e\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u090f\\u091c\\u0947\\u0902\\u091f \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0922\\u093e\\u0902\\u091a\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0645\\u062c\\u0627\\u0644 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0630\\u064a \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0628\\u064a\\u0646 \\u0637\\u0631\\u0641\\u064a\\u0646\\u060c \\u062d\\u064a\\u062b \\u064a\\u062a\\u0635\\u0631\\u0641 \\u0637\\u0631\\u0641 \\u0648\\u0627\\u062d\\u062f (\\u0627\\u0644\\u0648\\u0643\\u064a\\u0644) \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646 \\u0648\\u062a\\u062d\\u062a \\u0633\\u064a\\u0637\\u0631\\u0629 \\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0622\\u062e\\u0631 (\\u0627\\u0644\\u0645\\u0648\\u0643\\u0644). \\u062a\\u0639\\u0637\\u064a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0629 \\u0646\\u0634\\u0648\\u0621 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u0648\\u0627\\u062c\\u0628\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0648\\u0627\\u0644\\u0648\\u0643\\u064a\\u0644.<\\/p>\\r\\n<p>\\u062a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0641\\u0627\\u0647\\u064a\\u0645 \\u0648\\u0627\\u0644\\u0645\\u0628\\u0627\\u062f\\u0626 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629:<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0648\\u0627\\u0644\\u0648\\u0643\\u064a\\u0644:<\\/strong> \\u0647\\u0630\\u0647 \\u0647\\u064a \\u0627\\u0644\\u0641\\u0643\\u0631\\u0629 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a\\u0629 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629\\u060c \\u062d\\u064a\\u062b \\u064a\\u0645\\u0646\\u062d \\u0637\\u0631\\u0641 \\u0648\\u0627\\u062d\\u062f (\\u0627\\u0644\\u0645\\u0648\\u0643\\u0644) \\u062a\\u0641\\u0648\\u064a\\u0636\\u0627\\u064b \\u0644\\u0637\\u0631\\u0641 \\u0622\\u062e\\u0631 (\\u0627\\u0644\\u0648\\u0643\\u064a\\u0644) \\u0644\\u0644\\u062a\\u0635\\u0631\\u0641 \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646\\u0647. \\u064a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0628\\u0623\\u062f\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0647\\u0627\\u0645 \\u0623\\u0648 \\u0627\\u062a\\u062e\\u0627\\u0630 \\u0627\\u0644\\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0624\\u062b\\u0631 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u0648\\u0627\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0648\\u0643\\u0644.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u0633\\u0644\\u0637\\u0629:<\\/strong> \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0641\\u0639\\u0644\\u064a\\u0629 \\u0623\\u0648 \\u0638\\u0627\\u0647\\u0631\\u0629. \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0627\\u0644\\u0641\\u0639\\u0644\\u064a\\u0629 \\u0647\\u064a \\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u0645\\u0646\\u062d \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0635\\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0644\\u0644\\u062a\\u0635\\u0631\\u0641 \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646\\u0647\\u060c \\u0625\\u0645\\u0627 \\u0634\\u0641\\u0648\\u064a\\u0627\\u064b \\u0623\\u0648 \\u0643\\u062a\\u0627\\u0628\\u064a\\u0627\\u064b. \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0627\\u0644\\u0638\\u0627\\u0647\\u0631\\u0629 \\u062a\\u0646\\u0634\\u0623 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u0639\\u062a\\u0642\\u062f \\u0637\\u0631\\u0641 \\u062b\\u0627\\u0644\\u062b \\u0628\\u0645\\u0639\\u0642\\u0648\\u0644\\u064a\\u0629 \\u0623\\u0646 \\u0644\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0644\\u0644\\u062a\\u0635\\u0631\\u0641 \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644\\u060c \\u062d\\u062a\\u0649 \\u0644\\u0648 \\u0644\\u0645 \\u064a\\u062a\\u0645 \\u0645\\u0646\\u062d \\u0645\\u062b\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0635\\u0631\\u0627\\u062d\\u0629\\u064b.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0648\\u0627\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644:<\\/strong> \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0645\\u0644\\u0632\\u0645\\u0648\\u0646 \\u0628\\u0628\\u0639\\u0636 \\u0627\\u0644\\u0648\\u0627\\u062c\\u0628\\u0627\\u062a \\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0648\\u0627\\u062c\\u0628 \\u0627\\u0644\\u0648\\u0644\\u0627\\u0621 (\\u0627\\u0644\\u062a\\u0635\\u0631\\u0641 \\u062d\\u0635\\u0631\\u0627\\u064b \\u0641\\u064a \\u0645\\u0635\\u0644\\u062d\\u0629 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644)\\u060c \\u0648\\u0648\\u0627\\u062c\\u0628 \\u0627\\u0644\\u0637\\u0627\\u0639\\u0629 (\\u0627\\u062a\\u0628\\u0627\\u0639 \\u062a\\u0639\\u0644\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644)\\u060c \\u0648\\u0648\\u0627\\u062c\\u0628 \\u0627\\u0644\\u0639\\u0646\\u0627\\u064a\\u0629 (\\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0639\\u0646\\u0627\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0647\\u0627\\u0631\\u0629 \\u0628\\u0634\\u0643\\u0644 \\u0645\\u0639\\u0642\\u0648\\u0644)\\u060c \\u0648\\u0648\\u0627\\u062c\\u0628 \\u062a\\u0633\\u0648\\u064a\\u0629 \\u0623\\u064a \\u0635\\u0641\\u0642\\u0627\\u062a \\u0623\\u0648 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u062a\\u0645 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0628\\u0647\\u0627 \\u0646\\u064a\\u0627\\u0628\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0648\\u0627\\u062c\\u0628\\u0627\\u062a \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644:<\\/strong> \\u0644\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0623\\u064a\\u0636\\u0627\\u064b \\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u062a\\u0639\\u0648\\u064a\\u0636 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0639\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0647 \\u0648\\u062a\\u0639\\u0648\\u064a\\u0636 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0639\\u0646 \\u0623\\u064a \\u062e\\u0633\\u0627\\u0626\\u0631 \\u062a\\u0643\\u0628\\u062f\\u0647\\u0627 \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0627\\u0644\\u062a\\u0635\\u0631\\u0641 \\u062f\\u0627\\u062e\\u0644 \\u0646\\u0637\\u0627\\u0642 \\u0633\\u0644\\u0637\\u062a\\u0647.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0625\\u0646\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629:<\\/strong> \\u064a\\u0645\\u0643\\u0646 \\u0625\\u0646\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u062a\\u0641\\u0627\\u0642 \\u0637\\u0631\\u0641\\u064a \\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u060c \\u0623\\u0648 \\u0627\\u0646\\u062a\\u0647\\u0627\\u0621 \\u0641\\u062a\\u0631\\u0629 \\u0632\\u0645\\u0646\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629\\u060c \\u0623\\u0648 \\u0627\\u0643\\u062a\\u0645\\u0627\\u0644 \\u0645\\u0647\\u0627\\u0645 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644\\u060c \\u0623\\u0648 \\u0648\\u0641\\u0627\\u0629 \\u0623\\u0648 \\u0639\\u062f\\u0645 \\u0642\\u062f\\u0631\\u0629 \\u0623\\u062d\\u062f \\u0627\\u0644\\u0637\\u0631\\u0641\\u064a\\u0646\\u060c \\u0623\\u0648 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0625\\u0646\\u0647\\u0627\\u0621 \\u0623\\u062d\\u0627\\u062f\\u064a \\u0627\\u0644\\u0637\\u0631\\u0641 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0637\\u0631\\u0641 \\u0648\\u0627\\u062d\\u062f (\\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u0630\\u0644\\u0643 \\u0645\\u0633\\u0645\\u0648\\u062d\\u0627\\u064b \\u0628\\u0634\\u0631\\u0648\\u0637 \\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629).<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629:<\\/strong> \\u0628\\u0634\\u0643\\u0644 \\u0639\\u0627\\u0645\\u060c \\u064a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0645\\u0633\\u0624\\u0648\\u0644\\u0627\\u064b \\u0639\\u0646 \\u0623\\u0641\\u0639\\u0627\\u0644 \\u0648\\u0643\\u064a\\u0644\\u0647 \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0623\\u0641\\u0639\\u0627\\u0644 \\u062f\\u0627\\u062e\\u0644 \\u0646\\u0637\\u0627\\u0642 \\u0633\\u0644\\u0637\\u0629 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0648\\u062a\\u0645\\u062a \\u0641\\u064a \\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u064a\\u0629. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u0644\\u0627 \\u062a\\u0631\\u0628\\u0637 \\u0628\\u0639\\u0636 \\u0623\\u0641\\u0639\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062a\\u062c\\u0627\\u0648\\u0632 \\u0633\\u0644\\u0637\\u062a\\u0647\\u0645 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u062a\\u0635\\u062f\\u064a\\u0642:<\\/strong> \\u0641\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0623\\u062d\\u064a\\u0627\\u0646\\u060c \\u0642\\u062f \\u064a\\u062a\\u062c\\u0627\\u0648\\u0632 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0633\\u0644\\u0637\\u062a\\u0647 \\u0648\\u0644\\u0643\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0642\\u062f \\u064a\\u062e\\u062a\\u0627\\u0631 \\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0635\\u0631\\u062d \\u0628\\u0647\\u060c \\u0648\\u0627\\u0644\\u0630\\u064a \\u064a\\u0639\\u0631\\u0641 \\u0628\\u0627\\u0644\\u062a\\u0635\\u062f\\u064a\\u0642. \\u0641\\u064a \\u0645\\u062b\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a\\u060c \\u064a\\u0635\\u0628\\u062d \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0645\\u0644\\u0632\\u0645\\u0627\\u064b \\u0628\\u0623\\u0641\\u0639\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0643\\u064a\\u0644 \\u0643\\u0645\\u0627 \\u0644\\u0648 \\u0643\\u0627\\u0646\\u062a \\u0645\\u0635\\u0631\\u062d\\u0627\\u064b \\u0628\\u0647\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0644\\u062f\\u0649 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0643\\u0628\\u064a\\u0631 \\u0641\\u064a \\u0645\\u062c\\u0627\\u0644\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0648\\u0638\\u064a\\u0641\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u0639\\u0642\\u0627\\u0631\\u0627\\u062a\\u060c \\u0648\\u0623\\u0643\\u062b\\u0631 \\u0645\\u0646 \\u0630\\u0644\\u0643. \\u0625\\u0646\\u0647 \\u064a\\u0633\\u0627\\u0639\\u062f \\u0641\\u064a \\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0644\\u0644\\u0637\\u0631\\u0641\\u064a\\u0646 \\u0641\\u064a \\u0639\\u0644\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0645\\u0648\\u0643\\u0644 \\u0648\\u0627\\u0644\\u0648\\u0643\\u064a\\u0644\\u060c \\u0648\\u064a\\u0648\\u0641\\u0631 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0648\\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0643\\u0644\\u0627\\u0621.<\\/p>"}',
                'icon' => NULL,
                'id' => 6,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Agency Therapy","hi":"\\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629"}',
                'parent_category_id' => 1,
                'slug' => 'agency-therapy-6',
                'updated_at' => '2023-10-11 16:35:49',
            ),
            6 => 
            array (
                'created_at' => '2023-08-08 11:59:08',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Rulemaking and regulations are processes by which government agencies create and implement rules and standards to govern various aspects of society, industry, and public behavior. These rules and regulations are designed to achieve specific policy objectives, maintain order, protect public safety, ensure fair competition, and address other societal goals.<\\/p>\\r\\n\\r\\n<p>Here&#39;s an overview of the rulemaking and regulatory process:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p><strong>Initiation:<\\/strong> The process usually begins with a perceived need for new rules or changes to existing regulations. This need might arise from public concerns, technological advancements, changing market conditions, or other factors. Government agencies, often under the authority of legislation passed by a legislative body, initiate the process.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Notice of Proposed Rulemaking (NPRM):<\\/strong> The agency publishes a Notice of Proposed Rulemaking in the Federal Register or a similar publication. This notice provides details about the proposed rule, including its purpose, scope, potential impacts, and the agency&#39;s legal authority to make such a rule. The public is given an opportunity to comment on the proposed rule during a specified comment period.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Public Comment:<\\/strong> During the comment period, individuals, businesses, organizations, and other stakeholders can submit their opinions, suggestions, concerns, and evidence related to the proposed rule. Agencies are required to consider these comments before finalizing the rule.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Analysis:<\\/strong> The agency reviews the public comments, conducts additional research if necessary, and assesses the potential economic, social, and environmental impacts of the proposed rule. This analysis helps ensure that the rule is well-informed and reasonable.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Final Rule:<\\/strong> Based on the comments received and the analysis conducted, the agency may revise the proposed rule before issuing the Final Rule. The Final Rule includes the agency&#39;s response to the public comments, the text of the rule as adopted, and an effective date for implementation.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Publication and Codification:<\\/strong> The Final Rule is published in the Federal Register or an appropriate regulatory publication. It is also often incorporated into the Code of Federal Regulations (CFR), which is a compilation of all federal regulations organized by subject matter.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Enforcement:<\\/strong> Once the Final Rule is in effect, the agency is responsible for enforcing compliance. This may involve monitoring, inspections, penalties for violations, and other enforcement mechanisms.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>Review and Amendments:<\\/strong> Over time, regulations may need to be reviewed, updated, or amended to account for changing circumstances. This can involve a similar process of notice, comment, and rulemaking.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>It&#39;s important to note that the rulemaking process can vary by country and jurisdiction. In the United States, for example, federal agencies follow specific procedures outlined in the Administrative Procedure Act (APA) when engaging in rulemaking. Other countries and regions have their own legal frameworks for developing and implementing regulations.<\\/p>\\r\\n\\r\\n<p>Rulemaking and regulations play a crucial role in shaping the legal and regulatory environment within which businesses, individuals, and organizations operate, and they are essential tool for governments to achieve public policy objectives and maintain social order.<\\/p>","hi":"<p>\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0935\\u0947 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0939\\u0948\\u0902 \\u091c\\u093f\\u0938\\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u0901 \\u0928\\u093f\\u092f\\u092e \\u0914\\u0930 \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0915\\u094b \\u092c\\u0928\\u093e\\u0924\\u0940 \\u0914\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0938\\u092e\\u093e\\u091c, \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917, \\u0914\\u0930 \\u091c\\u0928\\u0924\\u093e \\u0915\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u093e \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u0923 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0928\\u093f\\u092f\\u092e \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0928\\u0940\\u0924\\u093f \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947, \\u0915\\u094d\\u0930\\u092e \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u0928\\u0947, \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0940 \\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u0947, \\u0909\\u091a\\u093f\\u0924 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947, \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u093e\\u092e\\u093e\\u091c\\u093f\\u0915 \\u0932\\u0915\\u094d\\u0937\\u094d\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0921\\u093f\\u091c\\u093c\\u093e\\u0907\\u0928 \\u0915\\u0940 \\u0917\\u0908 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d:<\\/strong> \\u092f\\u0939 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0928\\u0908 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u092f\\u093e \\u092e\\u094c\\u091c\\u0942\\u0926\\u093e \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u0928 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0915\\u0947 \\u0926\\u0943\\u0937\\u094d\\u091f\\u093f\\u0915\\u094b\\u0923 \\u0938\\u0947 \\u0936\\u0941\\u0930\\u0942 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0938\\u093e\\u092e\\u093e\\u091c\\u093f\\u0915 \\u091a\\u093f\\u0902\\u0924\\u093e\\u0913\\u0902, \\u092a\\u094d\\u0930\\u094c\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915\\u0940 \\u0909\\u0928\\u094d\\u0928\\u0924\\u093f\\u092f\\u094b\\u0902, \\u092c\\u0926\\u0932\\u0924\\u0940 \\u092c\\u093e\\u091c\\u093e\\u0930 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902, \\u092f\\u093e \\u0905\\u0928\\u094d\\u092f \\u0915\\u093e\\u0930\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u0901 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0938\\u092e\\u094d\\u0935\\u093f\\u0927\\u093e\\u0928\\u093f\\u0915 \\u0928\\u093f\\u0915\\u093e\\u092f \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u093e\\u0930\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u0905\\u0927\\u0940\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0906\\u0930\\u0902\\u092d \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u0940 \\u0938\\u0942\\u091a\\u0928\\u093e (NPRM):<\\/strong> \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0938\\u0902\\u0918 \\u0930\\u091c\\u093f\\u0938\\u094d\\u091f\\u0930 \\u092f\\u093e \\u090f\\u0915 \\u0938\\u092e\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0936\\u0928 \\u092e\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u0940 \\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u0915\\u093e\\u0936\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0938\\u0942\\u091a\\u0928\\u093e \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0938\\u094d\\u0924\\u093e\\u0930 \\u0938\\u0947 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0907\\u0938\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f, \\u0935\\u093f\\u0938\\u094d\\u0924\\u093e\\u0930, \\u0938\\u0902\\u092d\\u093e\\u0935\\u093f\\u0924 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935, \\u0914\\u0930 \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0915\\u094b \\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u0940 \\u0905\\u0935\\u0927\\u093f \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e \\u092a\\u0930 \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u0940 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0935\\u0938\\u0930 \\u0926\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u0940:<\\/strong> \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u0940 \\u0905\\u0935\\u0927\\u093f \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928, \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902, \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902, \\u0938\\u0902\\u0917\\u0920\\u0928\\u094b\\u0902, \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0938\\u0902\\u0932\\u0917\\u094d\\u0928\\u0915 \\u0905\\u092a\\u0928\\u0947 \\u0935\\u093f\\u091a\\u093e\\u0930, \\u0938\\u0941\\u091d\\u093e\\u0935, \\u091a\\u093f\\u0902\\u0924\\u093e\\u090f\\u0901, \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0928\\u093f\\u092f\\u092e \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u092c\\u0942\\u0924 \\u0938\\u092c\\u092e\\u093f\\u091f \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0907\\u0928 \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u092f\\u092e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u0930\\u0928\\u093e \\u0905\\u0928\\u093f\\u0935\\u093e\\u0930\\u094d\\u092f \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0935\\u093f\\u0936\\u094d\\u0932\\u0947\\u0937\\u0923:<\\/strong> \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u092a\\u0941\\u0928\\u0930\\u093e\\u0935\\u0932\\u094b\\u0915\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u092f\\u0926\\u093f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u094b, \\u0924\\u094b \\u0905\\u0924\\u093f\\u0930\\u093f\\u0915\\u094d\\u0924 \\u0905\\u0928\\u0941\\u0938\\u0902\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e \\u0915\\u0947 \\u0938\\u0902\\u092d\\u093e\\u0935\\u093f\\u0924 \\u0906\\u0930\\u094d\\u0925\\u093f\\u0915, \\u0938\\u093e\\u092e\\u093e\\u091c\\u093f\\u0915, \\u0914\\u0930 \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923\\u0940\\u092f \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u094b\\u0902 \\u0915\\u093e \\u092e\\u0942\\u0932\\u094d\\u092f\\u093e\\u0902\\u0915\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0935\\u093f\\u0936\\u094d\\u0932\\u0947\\u0937\\u0923 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0928\\u093f\\u092f\\u092e \\u091c\\u094d\\u091e\\u093e\\u0928\\u0940 \\u0914\\u0930 \\u092f\\u094b\\u0917\\u094d\\u092f \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0905\\u0902\\u0924\\u093f\\u092e \\u0928\\u093f\\u092f\\u092e:<\\/strong> \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0936\\u094d\\u0932\\u0947\\u0937\\u0923 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930, \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0938\\u0902\\u0936\\u094b\\u0927\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948 \\u092a\\u094d\\u0930\\u093e\\u0938\\u094d\\u0924\\u093e\\u0935\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e \\u0915\\u094b \\u092a\\u094d\\u0930\\u0915\\u093e\\u0936\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947\\u0964 \\u0905\\u0902\\u0924\\u093f\\u092e \\u0928\\u093f\\u092f\\u092e \\u092e\\u0947\\u0902 \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u0940 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u0924\\u094d\\u0924\\u0930, \\u0928\\u093f\\u092f\\u092e \\u0915\\u093e \\u092a\\u093e\\u0920 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0938\\u094d\\u0935\\u0940\\u0915\\u0943\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0914\\u0930 \\u0915\\u093e\\u0930\\u094d\\u092f\\u093e\\u0928\\u094d\\u0935\\u092f\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u0940 \\u0924\\u093e\\u0930\\u0940\\u0916 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u092a\\u094d\\u0930\\u0915\\u093e\\u0936\\u0928 \\u0914\\u0930 \\u0938\\u0902\\u0935\\u0930\\u094d\\u0917\\u0923:<\\/strong> \\u0905\\u0902\\u0924\\u093f\\u092e \\u0928\\u093f\\u092f\\u092e \\u0915\\u094b \\u0938\\u0902\\u0918 \\u0930\\u091c\\u093f\\u0938\\u094d\\u091f\\u0930 \\u092f\\u093e \\u090f\\u0915 \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0924\\u094d\\u092e\\u0915 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0936\\u0928 \\u092e\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0936\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0938\\u0902\\u0918 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0915\\u094b\\u0921 (CFR) \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u091c\\u094b \\u0935\\u093f\\u0937\\u092f-\\u0938\\u0942\\u091a\\u0940 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0938\\u092d\\u0940 \\u0938\\u0902\\u0918 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0915\\u0932\\u0928 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0928\\u093f\\u0930\\u094d\\u0935\\u093e\\u091a\\u0928:<\\/strong> \\u0905\\u0902\\u0924\\u093f\\u092e \\u0928\\u093f\\u092f\\u092e \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0926, \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0906\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930 \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u0928\\u093f\\u0917\\u0930\\u093e\\u0928\\u0940, \\u0928\\u093f\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923, \\u0909\\u0932\\u094d\\u0932\\u0902\\u0918\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0926\\u0902\\u0921, \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u092a\\u093e\\u0932\\u0928 \\u092f\\u0941\\u0915\\u094d\\u0924\\u093f\\u092f\\u093e\\u0901 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0938\\u0902\\u0936\\u094b\\u0927\\u0928:<\\/strong> \\u0938\\u092e\\u092f \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e, \\u0905\\u0926\\u094d\\u092f\\u0924\\u0928, \\u092f\\u093e \\u0938\\u0902\\u0936\\u094b\\u0927\\u0928 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948 \\u091c\\u094b \\u092c\\u0926\\u0932\\u0924\\u0940 \\u0939\\u0941\\u0908 \\u092a\\u0930\\u093f\\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0927\\u094d\\u092f\\u093e\\u0928 \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u0938\\u0942\\u091a\\u0928\\u093e, \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u0940, \\u0914\\u0930 \\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u0940 \\u0938\\u092e\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0927\\u094d\\u092f\\u093e\\u0928 \\u0926\\u0947\\u0928\\u093e \\u091c\\u0930\\u0942\\u0930\\u0940 \\u0939\\u0948 \\u0915\\u093f \\u0928\\u093f\\u092f\\u092e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0928\\u0941\\u0938\\u093e\\u0930 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0909\\u0926\\u093e\\u0939\\u0930\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f, \\u0938\\u0902\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0930\\u093e\\u091c\\u094d\\u092f \\u0905\\u092e\\u0947\\u0930\\u093f\\u0915\\u093e \\u092e\\u0947\\u0902 \\u0938\\u0902\\u0918 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u0901 \\u0928\\u093f\\u092f\\u092e\\u0928 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u091c\\u092c \\u0935\\u0947 \\u0928\\u093f\\u092f\\u092e\\u0928 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 (APA) \\u092e\\u0947\\u0902 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0905\\u0928\\u094d\\u092f \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u092a\\u0928\\u0947 \\u0928\\u093f\\u092f\\u092e \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0914\\u0930 \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u092a\\u0928\\u0947 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0922\\u093e\\u0902\\u091a\\u0947 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n<p>\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0935\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0909\\u092a\\u0915\\u0930\\u0923 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0938\\u0930\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0928\\u0940\\u0924\\u093f \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0938\\u093e\\u092e\\u093e\\u091c\\u093f\\u0915 \\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e \\u0915\\u094b \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902, \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902, \\u0914\\u0930 \\u0938\\u0902\\u0917\\u0920\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0915\\u093e\\u0930\\u094d\\u092f \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0924\\u094d\\u092e\\u0915 \\u092a\\u0930\\u093f\\u0935\\u0947\\u0936 \\u0915\\u094b \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0647\\u064a \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0642\\u0648\\u0645 \\u0628\\u0647\\u0627 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0648\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0643\\u0645 \\u0645\\u062e\\u062a\\u0644\\u0641 \\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639 \\u0648\\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u0629 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0648\\u0643 \\u0627\\u0644\\u0639\\u0627\\u0645. \\u062a\\u0645 \\u062a\\u0635\\u0645\\u064a\\u0645 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0644\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0623\\u0647\\u062f\\u0627\\u0641 \\u0633\\u064a\\u0627\\u0633\\u064a\\u0629 \\u0645\\u062d\\u062f\\u062f\\u0629\\u060c \\u0648\\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645\\u060c \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629\\u060c \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0644\\u0629\\u060c \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0623\\u0647\\u062f\\u0627\\u0641 \\u0623\\u062e\\u0631\\u0649 \\u0641\\u064a \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639.<\\/p>\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u0628\\u062f\\u0627\\u064a\\u0629:<\\/strong> \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u0645\\u0627 \\u062a\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0628\\u0627\\u0644\\u062d\\u0627\\u062c\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0635\\u0648\\u0631\\u0629 \\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u062c\\u062f\\u064a\\u062f\\u0629 \\u0623\\u0648 \\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0626\\u0645\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0646\\u0634\\u0623 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062d\\u0627\\u062c\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0644\\u0642 \\u0627\\u0644\\u0639\\u0627\\u0645\\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0642\\u062f\\u0645 \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0638\\u0631\\u0648\\u0641 \\u0627\\u0644\\u0633\\u0648\\u0642\\u064a\\u0629\\u060c \\u0623\\u0648 \\u0639\\u0648\\u0627\\u0645\\u0644 \\u0623\\u062e\\u0631\\u0649. \\u062a\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629\\u060c \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u062a\\u062d\\u062a \\u0633\\u0644\\u0637\\u0629 \\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u062a\\u064a \\u0635\\u062f\\u0631\\u062a\\u0647\\u0627 \\u0647\\u064a\\u0626\\u0629 \\u062a\\u0634\\u0631\\u064a\\u0639\\u064a\\u0629\\u060c \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0625\\u0639\\u0644\\u0627\\u0646 \\u0639\\u0646 \\u0642\\u0627\\u0639\\u062f\\u0629 \\u0645\\u0642\\u062a\\u0631\\u062d\\u0629 (NPRM):<\\/strong> \\u062a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u0628\\u0646\\u0634\\u0631 \\u0625\\u0639\\u0644\\u0627\\u0646 \\u0639\\u0646 \\u0642\\u0627\\u0639\\u062f\\u0629 \\u0645\\u0642\\u062a\\u0631\\u062d\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0633\\u062c\\u0644 \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a \\u0623\\u0648 \\u0646\\u0634\\u0631 \\u0645\\u0645\\u0627\\u062b\\u0644. \\u064a\\u0648\\u0641\\u0631 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u062d\\u0648\\u0644 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0645\\u0642\\u062a\\u0631\\u062d\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u063a\\u0631\\u0636 \\u0645\\u0646\\u0647\\u0627\\u060c \\u0648\\u0646\\u0637\\u0627\\u0642\\u0647\\u0627\\u060c \\u0648\\u0627\\u0644\\u062a\\u0623\\u062b\\u064a\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u062d\\u062a\\u0645\\u0644\\u0629\\u060c \\u0648\\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0644\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u0641\\u064a \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0645\\u062b\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629. \\u064a\\u062a\\u0627\\u062d \\u0644\\u0644\\u062c\\u0645\\u0647\\u0648\\u0631 \\u0627\\u0644\\u0641\\u0631\\u0635\\u0629 \\u0644\\u0644\\u062a\\u0639\\u0644\\u064a\\u0642 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0645\\u0642\\u062a\\u0631\\u062d\\u0629 \\u062e\\u0644\\u0627\\u0644 \\u0641\\u062a\\u0631\\u0629 \\u062a\\u0639\\u0644\\u064a\\u0642 \\u0645\\u062d\\u062f\\u062f\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u062a\\u0639\\u0644\\u064a\\u0642 \\u0639\\u0627\\u0645:<\\/strong> \\u062e\\u0644\\u0627\\u0644 \\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0642\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0646\\u0638\\u0645\\u0627\\u062a \\u0648\\u0623\\u0635\\u062d\\u0627\\u0628 \\u0627\\u0644\\u0645\\u0635\\u0644\\u062d\\u0629 \\u0627\\u0644\\u0622\\u062e\\u0631\\u064a\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0622\\u0631\\u0627\\u0626\\u0647\\u0645 \\u0648\\u0627\\u0642\\u062a\\u0631\\u0627\\u062d\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0645\\u062e\\u0627\\u0648\\u0641\\u0647\\u0645 \\u0648\\u0627\\u0644\\u0623\\u062f\\u0644\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0645\\u0642\\u062a\\u0631\\u062d\\u0629. \\u0648\\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0623\\u0646 \\u062a\\u0646\\u0638\\u0631 \\u0641\\u064a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0642\\u0627\\u062a \\u0642\\u0628\\u0644 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u062a\\u062d\\u0644\\u064a\\u0644:<\\/strong> \\u062a\\u0633\\u062a\\u0639\\u0631\\u0636 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0642\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629\\u060c \\u0648\\u062a\\u064f\\u062c\\u0631\\u064a \\u0623\\u0628\\u062d\\u0627\\u062b\\u064b\\u0627 \\u0625\\u0636\\u0627\\u0641\\u064a\\u0629 \\u0625\\u0630\\u0627 \\u0644\\u0632\\u0645 \\u0627\\u0644\\u0623\\u0645\\u0631\\u060c \\u0648\\u062a\\u0642\\u064a\\u0645 \\u0627\\u0644\\u0622\\u062b\\u0627\\u0631 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0635\\u0627\\u062f\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0627\\u062c\\u062a\\u0645\\u0627\\u0639\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0628\\u064a\\u0626\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062d\\u062a\\u0645\\u0644\\u0629 \\u0644\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0645\\u0642\\u062a\\u0631\\u062d\\u0629. \\u064a\\u0633\\u0627\\u0639\\u062f \\u0647\\u0630\\u0627 \\u0627\\u0644\\u062a\\u062d\\u0644\\u064a\\u0644 \\u0641\\u064a \\u0627\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0645\\u0633\\u062a\\u0646\\u064a\\u0631\\u0629 \\u0648\\u0645\\u0639\\u0642\\u0648\\u0644\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0646\\u0647\\u0627\\u0626\\u064a\\u0629:<\\/strong> \\u0627\\u0633\\u062a\\u0646\\u0627\\u062f\\u064b\\u0627 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0642\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645 \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645\\u0647\\u0627 \\u0648\\u0627\\u0644\\u062a\\u062d\\u0644\\u064a\\u0644 \\u0627\\u0644\\u0630\\u064a \\u062a\\u0645 \\u0625\\u062c\\u0631\\u0627\\u0624\\u0647\\u060c \\u0642\\u062f \\u062a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u0628\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0645\\u0642\\u062a\\u0631\\u062d\\u0629 \\u0642\\u0628\\u0644 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0646\\u0647\\u0627\\u0626\\u064a\\u0629. \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0646\\u0647\\u0627\\u0626\\u064a\\u0629 \\u0631\\u062f \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0642\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629\\u060c \\u0648\\u0646\\u0635 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0643\\u0645\\u0627 \\u062a\\u0645 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u0647\\u060c \\u0648\\u062a\\u0627\\u0631\\u064a\\u062e \\u0641\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0646\\u0641\\u064a\\u0630.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u0646\\u0634\\u0631 \\u0648\\u0627\\u0644\\u062a\\u062f\\u0648\\u064a\\u0646:<\\/strong> \\u064a\\u062a\\u0645 \\u0646\\u0634\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0646\\u0647\\u0627\\u0626\\u064a\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0633\\u062c\\u0644 \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a \\u0623\\u0648 \\u0646\\u0634\\u0631 \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0622\\u062e\\u0631. \\u0643\\u0645\\u0627 \\u064a\\u062a\\u0645 \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u062a\\u0636\\u0645\\u064a\\u0646\\u0647\\u0627 \\u0641\\u064a \\u0627\\u0644\\u0643\\u0648\\u062f \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a \\u0644\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a (CFR)\\u060c \\u0648\\u0627\\u0644\\u0630\\u064a \\u0647\\u0648 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646\\u0638\\u0645\\u0629 \\u062d\\u0633\\u0628 \\u0627\\u0644\\u0645\\u0648\\u0636\\u0648\\u0639.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u062a\\u0646\\u0641\\u064a\\u0630:<\\/strong> \\u0628\\u0645\\u062c\\u0631\\u062f \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0646\\u0647\\u0627\\u0626\\u064a\\u0629 \\u0633\\u0627\\u0631\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0641\\u0639\\u0648\\u0644\\u060c \\u062a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u0645\\u0633\\u0624\\u0648\\u0644\\u0629 \\u0639\\u0646 \\u0641\\u0631\\u0636 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644. \\u0648\\u0642\\u062f \\u064a\\u0634\\u0645\\u0644 \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0645\\u0631\\u0627\\u0642\\u0628\\u0629\\u060c \\u0648\\u0627\\u0644\\u062a\\u0641\\u062a\\u064a\\u0634\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u0646\\u062a\\u0647\\u0627\\u0643\\u0627\\u062a\\u060c \\u0648\\u0648\\u0633\\u0627\\u0626\\u0644 \\u062a\\u0646\\u0641\\u064a\\u0630 \\u0623\\u062e\\u0631\\u0649.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p><strong>\\u0627\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0639\\u062f\\u064a\\u0644\\u0627\\u062a:<\\/strong> \\u0645\\u0639 \\u0645\\u0631\\u0648\\u0631 \\u0627\\u0644\\u0648\\u0642\\u062a\\u060c \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0623\\u0648 \\u062a\\u062d\\u062f\\u064a\\u062b \\u0623\\u0648 \\u062a\\u0639\\u062f\\u064a\\u0644 \\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0644\\u0645\\u0631\\u0627\\u0639\\u0627\\u0629 \\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0638\\u0631\\u0648\\u0641. \\u0642\\u062f \\u064a\\u0634\\u0645\\u0644 \\u0630\\u0644\\u0643 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0645\\u0645\\u0627\\u062b\\u0644\\u0629 \\u0644\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u060c \\u0648\\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0642\\u060c \\u0648\\u0635\\u0646\\u0639 \\u0627\\u0644\\u0642\\u0627\\u0639\\u062f\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n<p>\\u0645\\u0646 \\u0627\\u0644\\u0645\\u0647\\u0645 \\u0623\\u0646 \\u0646\\u0644\\u0627\\u062d\\u0638 \\u0623\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0645\\u0646 \\u062f\\u0648\\u0644\\u0629 \\u0625\\u0644\\u0649 \\u062f\\u0648\\u0644\\u0629 \\u0648\\u0645\\u0646 \\u0645\\u0646\\u0637\\u0642\\u0629 \\u0625\\u0644\\u0649 \\u0645\\u0646\\u0637\\u0642\\u0629. \\u0639\\u0644\\u0649 \\u0633\\u0628\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062b\\u0627\\u0644\\u060c \\u0641\\u064a \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u062d\\u062f\\u0629\\u060c \\u062a\\u062a\\u0628\\u0639 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0641\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 (APA) \\u0639\\u0646\\u062f\\u0645\\u0627 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0627\\u0644\\u0623\\u0645\\u0631 \\u0628\\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f. \\u0648\\u0647\\u0646\\u0627\\u0643 \\u0623\\u0646\\u0638\\u0645\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643\\u0644 \\u062f\\u0648\\u0644\\u0629 \\u0623\\u062e\\u0631\\u0649 \\u0623\\u0648 \\u0645\\u0646\\u0637\\u0642\\u0629 \\u0644\\u062a\\u0637\\u0648\\u064a\\u0631 \\u0648\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d.<\\/p>\\r\\n<p>\\u0625\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u062a\\u0644\\u0639\\u0628 \\u062f\\u0648\\u0631\\u064b\\u0627 \\u062d\\u0627\\u0633\\u0645\\u064b\\u0627 \\u0641\\u064a \\u062a\\u0634\\u0643\\u064a\\u0644 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0639\\u0645\\u0644 \\u0641\\u064a\\u0647\\u0627 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0646\\u0638\\u0645\\u0627\\u062a\\u060c \\u0648\\u0647\\u064a \\u0623\\u062f\\u0627\\u0629 \\u0623\\u0633\\u0627\\u0633\\u064a\\u0629 \\u0644\\u0644\\u062d\\u0643\\u0648\\u0645\\u0627\\u062a \\u0644\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0623\\u0647\\u062f\\u0627\\u0641 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0627\\u062c\\u062a\\u0645\\u0627\\u0639\\u064a.<\\/p>"}',
                'icon' => NULL,
                'id' => 7,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Rulemaking and Regulations","hi":"\\u0928\\u093f\\u092f\\u092e \\u0928\\u093f\\u0930\\u094d\\u092e\\u093e\\u0923 \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e","ar":"\\u0648\\u0636\\u0639 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d"}',
                'parent_category_id' => 1,
                'slug' => 'rulemaking-and-regulations-7',
                'updated_at' => '2023-10-11 16:22:47',
            ),
            7 => 
            array (
                'created_at' => '2023-08-08 12:41:09',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Licensing and permits are legal authorizations granted by government authorities that allow individuals, businesses, or organizations to engage in certain activities, provide specific services, or operate within certain parameters. These requirements are often established to ensure public safety, protect the environment, maintain industry standards, and regulate various aspects of society and commerce.<\\/p>","hi":"<p>\\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938 \\u0914\\u0930 \\u092a\\u0930\\u092e\\u093f\\u091f \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0926\\u0940 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e\\u090f\\u0901 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902, \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902, \\u092f\\u093e \\u0938\\u0902\\u0917\\u0920\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0928\\u0947, \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0938\\u0947\\u0935\\u093e\\u090f\\u0902 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947, \\u092f\\u093e \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0938\\u0940\\u092e\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0938\\u0902\\u091a\\u093e\\u0932\\u093f\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u090f\\u0901 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0924\\u092c \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0940 \\u091c\\u093e \\u0938\\u0915\\u0947, \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0940 \\u091c\\u093e \\u0938\\u0915\\u0947, \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0915\\u094b \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947, \\u0914\\u0930 \\u0938\\u092e\\u093e\\u091c \\u0914\\u0930 \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f \\u0915\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947\\u0964<\\/p>","ar":"<p>\\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635 \\u0648\\u0627\\u0644\\u062a\\u0635\\u0627\\u0631\\u064a\\u062d \\u0647\\u064a \\u0627\\u0644\\u062a\\u0641\\u0648\\u064a\\u0636\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u0646\\u062d\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u064a \\u062a\\u0633\\u0645\\u062d \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0623\\u0648 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u0638\\u0645\\u0627\\u062a \\u0628\\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0641\\u064a \\u0623\\u0646\\u0634\\u0637\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629\\u060c \\u0623\\u0648 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u062d\\u062f\\u062f\\u0629\\u060c \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0636\\u0645\\u0646 \\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0645\\u0639\\u064a\\u0646\\u0629. \\u0648\\u063a\\u0627\\u0644\\u0628\\u0627\\u064b \\u0645\\u0627 \\u062a\\u064f\\u0646\\u0634\\u0623 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629\\u060c \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629\\u060c \\u0648\\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u0629\\u060c \\u0648\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0645\\u062e\\u062a\\u0644\\u0641 \\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639 \\u0648\\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 8,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Licensing and Permits","hi":"\\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u092a\\u0930\\u092e\\u093f\\u091f","ar":"\\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635 \\u0648\\u0627\\u0644\\u062a\\u0635\\u0627\\u0631\\u064a\\u062d"}',
                'parent_category_id' => 1,
                'slug' => 'licensing-and-permits-8',
                'updated_at' => '2023-10-11 16:14:48',
            ),
            8 => 
            array (
                'created_at' => '2023-08-08 12:41:48',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Environmental regulation refers to the set of rules, therapys, policies, and practices established by government authorities to manage and mitigate the impact of human activities on the environment. The main goal of environmental regulation is to protect natural resources, preserve ecosystems, prevent pollution, and promote sustainable development.<\\/p>","hi":"<p>\\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902, \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902, \\u0928\\u0940\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0942\\u0939 \\u0939\\u0948 \\u091c\\u093f\\u0928\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u092e\\u093e\\u0928\\u0935 \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u092a\\u0930 \\u092a\\u0921\\u093c\\u0947 \\u0905\\u0938\\u0930 \\u0915\\u094b \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0914\\u0930 \\u0915\\u092e \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964 \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u093e \\u092e\\u0941\\u0916\\u094d\\u092f \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u092a\\u094d\\u0930\\u093e\\u0915\\u0943\\u0924\\u093f\\u0915 \\u0938\\u0902\\u0938\\u093e\\u0927\\u0928\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e, \\u092a\\u093e\\u0930\\u093f\\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u0915\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923, \\u092a\\u094d\\u0930\\u0926\\u0942\\u0937\\u0923 \\u0915\\u094b \\u0930\\u094b\\u0915\\u0928\\u093e \\u0914\\u0930 \\u0938\\u0924\\u0924 \\u0935\\u093f\\u0915\\u093e\\u0938 \\u0915\\u094b \\u092a\\u094d\\u0930\\u094b\\u0924\\u094d\\u0938\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u064a\\u0634\\u064a\\u0631 \\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629 \\u0625\\u0644\\u0649 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0648\\u0636\\u0639\\u062a\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0648\\u062a\\u062e\\u0641\\u064a\\u0641 \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0628\\u0634\\u0631\\u064a\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629. \\u0627\\u0644\\u0647\\u062f\\u0641 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a \\u0645\\u0646 \\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629 \\u0647\\u0648 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0631\\u062f \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0646\\u0638\\u0645 \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a\\u0629\\u060c \\u0648\\u0645\\u0646\\u0639 \\u0627\\u0644\\u062a\\u0644\\u0648\\u062b\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062a\\u0646\\u0645\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062f\\u0627\\u0645\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 9,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Environmental Regulation","hi":"\\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928","ar":"\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a"}',
                'parent_category_id' => 1,
                'slug' => 'environmental-regulation-9',
                'updated_at' => '2023-10-11 16:10:09',
            ),
            9 => 
            array (
                'created_at' => '2023-08-08 12:42:44',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Health and safety regulations are a set of rules, standards, and guidelines established by government authorities to ensure the protection of workers, consumers, and the public from potential risks and hazards that could arise from various activities, products, or environments. These regulations are designed to prevent accidents, injuries, and illnesses, and to promote a safe and healthy working and living environment.<\\/p>","hi":"<p>\\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923, \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0914\\u0930 \\u0926\\u093f\\u0936\\u093e\\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936 \\u0939\\u0948\\u0902 \\u091c\\u093f\\u0928\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0915\\u093e\\u0930\\u094d\\u092f\\u0915\\u0930\\u094d\\u0924\\u093e\\u0913\\u0902, \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u091c\\u0928\\u0924\\u093e \\u0915\\u0940 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902, \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u092f\\u093e \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923\\u094b\\u0902 \\u0938\\u0947 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0926\\u0941\\u0930\\u094d\\u0918\\u091f\\u0928\\u093e\\u0913\\u0902, \\u091a\\u094b\\u091f\\u094b\\u0902 \\u0914\\u0930 \\u092c\\u0940\\u092e\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u092c\\u091a\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0921\\u093f\\u091c\\u093c\\u093e\\u0907\\u0928 \\u0915\\u093f\\u090f \\u0917\\u090f \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0938\\u094d\\u0935\\u0938\\u094d\\u0925 \\u0915\\u093e\\u0930\\u094d\\u092f \\u0914\\u0930 \\u091c\\u0940\\u0935\\u0928 \\u0935\\u093e\\u0924\\u093e\\u0935\\u0930\\u0923 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f\\u0964<\\/p>","ar":"<p>\\u062a\\u0634\\u062a\\u0645\\u0644 \\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0635\\u062d\\u0629 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0648\\u0627\\u0644\\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0648\\u0636\\u0639\\u062a\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0627\\u0644 \\u0648\\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643\\u064a\\u0646 \\u0648\\u0627\\u0644\\u062c\\u0645\\u0647\\u0648\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631 \\u0648\\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631 \\u0627\\u0644\\u0645\\u062d\\u062a\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0646\\u0634\\u0623 \\u0645\\u0646 \\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0627\\u062a. \\u062a\\u0645 \\u062a\\u0635\\u0645\\u064a\\u0645 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0644\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u062d\\u0648\\u0627\\u062f\\u062b \\u0648\\u0627\\u0644\\u0625\\u0635\\u0627\\u0628\\u0627\\u062a \\u0648\\u0627\\u0644\\u0623\\u0645\\u0631\\u0627\\u0636\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0628\\u064a\\u0626\\u0629 \\u0639\\u0645\\u0644 \\u0648\\u0645\\u0639\\u064a\\u0634\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0635\\u062d\\u064a\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 10,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Health and Safety Regulations","hi":"\\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e","ar":"\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0635\\u062d\\u0629 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629"}',
                'parent_category_id' => 1,
                'slug' => 'health-and-safety-regulations-10',
                'updated_at' => '2023-10-11 16:07:11',
            ),
            10 => 
            array (
                'created_at' => '2023-08-08 12:43:27',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Telecommunications therapy refers to the legal framework and regulations that govern the provision of telecommunications services and the use of telecommunications networks. Telecommunications therapy encompasses a wide range of issues, including telecommunications infrastructure, licensing, competition, consumer protection, privacy, and more. It is designed to ensure fair competition, promote efficient use of resources, protect consumer rights, and facilitate the development of communication technologies.<\\/p>","hi":"<p>\\u0926\\u0942\\u0930\\u0938\\u0902\\u091a\\u093e\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0914\\u0930 \\u0926\\u0942\\u0930\\u0938\\u0902\\u091a\\u093e\\u0930 \\u0928\\u0947\\u091f\\u0935\\u0930\\u094d\\u0915\\u094b\\u0902 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0922\\u093e\\u0902\\u091a\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0926\\u0942\\u0930\\u0938\\u0902\\u091a\\u093e\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u0915\\u0940 \\u0926\\u0942\\u0930\\u0938\\u0902\\u091a\\u093e\\u0930 \\u092c\\u0941\\u0928\\u093f\\u092f\\u093e\\u0926\\u0940 \\u0922\\u093e\\u0902\\u091a\\u093e, \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u093f, \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u093e, \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e, \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e, \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f\\u0964 \\u0907\\u0938\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u092f\\u094b\\u091c\\u0928\\u093e \\u092c\\u0928\\u093e\\u0928\\u093e \\u0939\\u0948 \\u0924\\u093e\\u0915\\u093f \\u0928\\u093f\\u0937\\u094d\\u092a\\u0915\\u094d\\u0937 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b, \\u0938\\u0902\\u0938\\u093e\\u0927\\u0928\\u094b\\u0902 \\u0915\\u093e \\u0915\\u0941\\u0936\\u0932 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0939\\u094b, \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0939\\u094b, \\u0914\\u0930 \\u0938\\u0902\\u091a\\u093e\\u0930 \\u092a\\u094d\\u0930\\u094c\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0915\\u093e\\u0938 \\u0915\\u094b \\u0938\\u0941\\u0917\\u092e \\u092c\\u0928\\u093e\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947\\u0964<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0643\\u0645 \\u062a\\u0648\\u0641\\u064a\\u0631 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0634\\u0628\\u0643\\u0627\\u062a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a. \\u064a\\u0634\\u0645\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0628\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062a\\u062d\\u062a\\u064a\\u0629 \\u0644\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635\\u060c \\u0648\\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629\\u060c \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643\\u060c \\u0648\\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629\\u060c \\u0648\\u0623\\u0643\\u062b\\u0631 \\u0645\\u0646 \\u0630\\u0644\\u0643. \\u0625\\u0646 \\u0647\\u062f\\u0641\\u0647 \\u0647\\u0648 \\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0644\\u0629\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0627\\u0644 \\u0644\\u0644\\u0645\\u0648\\u0627\\u0631\\u062f\\u060c \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643\\u060c \\u0648\\u062a\\u064a\\u0633\\u064a\\u0631 \\u062a\\u0637\\u0648\\u064a\\u0631 \\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627\\u062a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644.<\\/p>"}',
                'icon' => NULL,
                'id' => 11,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Telecommunications Therapy","hi":"\\u0926\\u0942\\u0930\\u0938\\u0902\\u091a\\u093e\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a"}',
                'parent_category_id' => 1,
                'slug' => 'telecommunications-therapy-11',
                'updated_at' => '2023-10-11 15:54:52',
            ),
            11 => 
            array (
                'created_at' => '2023-08-08 13:00:55',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Energy regulation refers to the system of therapys, rules, and policies established by government authorities to oversee and manage the production, distribution, pricing, consumption, and environmental impact of various forms of energy, including electricity, natural gas, oil, and renewable sources. Energy regulation aims to ensure a reliable and sustainable energy supply while promoting competition, consumer protection, and environmental sustainability.<\\/p>","hi":"<p>\\u090a\\u0930\\u094d\\u091c\\u093e \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902, \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0914\\u0930 \\u0928\\u0940\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0924\\u0902\\u0924\\u094d\\u0930 \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0938\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u092c\\u093f\\u091c\\u0932\\u0940, \\u092a\\u094d\\u0930\\u093e\\u0915\\u0943\\u0924\\u093f\\u0915 \\u0917\\u0948\\u0938, \\u0924\\u0947\\u0932 \\u0914\\u0930 \\u0928\\u0935\\u093e\\u091a\\u093e\\u0930\\u0940 \\u0938\\u094d\\u0930\\u094b\\u0924\\u094b\\u0902 \\u0938\\u0939\\u093f\\u0924 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0930\\u0942\\u092a\\u094b\\u0902 \\u0915\\u0940 \\u090a\\u0930\\u094d\\u091c\\u093e \\u0915\\u0940 \\u0909\\u0924\\u094d\\u092a\\u0924\\u094d\\u0924\\u093f, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u092e\\u0942\\u0932\\u094d\\u092f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923, \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0914\\u0930 \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923\\u0940\\u092f \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935 \\u0915\\u093e \\u0928\\u093f\\u0917\\u0930\\u093e\\u0928\\u0940 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964 \\u090a\\u0930\\u094d\\u091c\\u093e \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u090f\\u0915 \\u0938\\u094d\\u0925\\u093f\\u0930 \\u0914\\u0930 \\u0926\\u0940\\u0930\\u094d\\u0918\\u0915\\u093e\\u0932\\u093f\\u0915 \\u090a\\u0930\\u094d\\u091c\\u093e \\u0906\\u092a\\u0942\\u0930\\u094d\\u0924\\u093f \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948 \\u0914\\u0930 \\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u093e, \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u092a\\u0930\\u094d\\u092f\\u093e\\u0935\\u0930\\u0923\\u0940\\u092f \\u0935\\u093f\\u0915\\u093e\\u0938 \\u0915\\u094b \\u092a\\u094d\\u0930\\u094b\\u0924\\u094d\\u0938\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0637\\u0627\\u0642\\u0629 \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0648\\u0636\\u0639\\u062a\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0644\\u0625\\u0634\\u0631\\u0627\\u0641 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0625\\u0646\\u062a\\u0627\\u062c \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u062a\\u0633\\u0639\\u064a\\u0631 \\u0648\\u0627\\u0633\\u062a\\u0647\\u0644\\u0627\\u0643 \\u0648\\u0627\\u0644\\u062a\\u0623\\u062b\\u064a\\u0631 \\u0627\\u0644\\u0628\\u064a\\u0626\\u064a \\u0644\\u0623\\u0634\\u0643\\u0627\\u0644 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0637\\u0627\\u0642\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0643\\u0647\\u0631\\u0628\\u0627\\u0621 \\u0648\\u0627\\u0644\\u063a\\u0627\\u0632 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0639\\u064a \\u0648\\u0627\\u0644\\u0646\\u0641\\u0637 \\u0648\\u0645\\u0635\\u0627\\u062f\\u0631 \\u0627\\u0644\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0645\\u062a\\u062c\\u062f\\u062f\\u0629. \\u064a\\u0647\\u062f\\u0641 \\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0637\\u0627\\u0642\\u0629 \\u0625\\u0644\\u0649 \\u0636\\u0645\\u0627\\u0646 \\u0625\\u0645\\u062f\\u0627\\u062f \\u0645\\u0648\\u062b\\u0648\\u0642 \\u0648\\u0645\\u0633\\u062a\\u062f\\u0627\\u0645 \\u0644\\u0644\\u0637\\u0627\\u0642\\u0629 \\u0645\\u0639 \\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643 \\u0648\\u0627\\u0633\\u062a\\u062f\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 12,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Energy Regulation","hi":"\\u090a\\u0930\\u094d\\u091c\\u093e \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928","ar":"\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0637\\u0627\\u0642\\u0629"}',
                'parent_category_id' => 1,
                'slug' => 'energy-regulation-12',
                'updated_at' => '2023-10-11 15:52:34',
            ),
            12 => 
            array (
                'created_at' => '2023-08-08 13:02:22',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Financial regulation refers to the framework of therapys, rules, and oversight mechanisms established by government authorities to ensure the stability, integrity, transparency, and fair operation of financial markets and institutions. Financial regulation aims to protect investors, consumers, and the broader economy from risks associated with financial activities, while also promoting healthy competition and preventing fraud, misconduct, and systemic crises.<\\/p>","hi":"<p>\\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902, \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0914\\u0930 \\u0928\\u093f\\u0917\\u0930\\u093e\\u0928\\u0940 \\u092f\\u093e\\u0902\\u0924\\u094d\\u0930\\u093f\\u0915\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0922\\u093e\\u0902\\u091a\\u0947 \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0928\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u092c\\u093e\\u091c\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u094d\\u0925\\u093f\\u0930\\u0924\\u093e, \\u0908\\u092e\\u093e\\u0928\\u0926\\u093e\\u0930\\u0940, \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e, \\u0914\\u0930 \\u0909\\u091a\\u093f\\u0924 \\u0938\\u0902\\u091a\\u093e\\u0932\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0928\\u093f\\u092f\\u093e\\u092e\\u0928 \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0928\\u093f\\u0935\\u0947\\u0936\\u0915\\u094b\\u0902, \\u0909\\u092a\\u092d\\u094b\\u0915\\u094d\\u0924\\u093e\\u0913\\u0902, \\u0914\\u0930 \\u0935\\u093f\\u0938\\u094d\\u0924\\u0943\\u0924 \\u0905\\u0930\\u094d\\u0925\\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e \\u0915\\u094b \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0947 \\u091c\\u094b\\u0916\\u093f\\u092e\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948, \\u0938\\u093e\\u0925 \\u0939\\u0940 \\u0938\\u094d\\u0935\\u0938\\u094d\\u0925 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0938\\u094d\\u092a\\u0930\\u094d\\u0927\\u093e \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u093e \\u0914\\u0930 \\u0927\\u094b\\u0916\\u093e\\u0927\\u0921\\u093c\\u0940, \\u0905\\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e, \\u0914\\u0930 \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0938\\u0902\\u0915\\u091f\\u094b\\u0902 \\u0915\\u094b \\u0930\\u094b\\u0915\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0622\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0631\\u0642\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0648\\u0636\\u0639\\u062a\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0633\\u062a\\u0642\\u0631\\u0627\\u0631 \\u0648\\u0646\\u0632\\u0627\\u0647\\u0629 \\u0648\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u062a\\u0634\\u063a\\u064a\\u0644 \\u0639\\u0627\\u062f\\u0644 \\u0644\\u0644\\u0623\\u0633\\u0648\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a. \\u064a\\u0647\\u062f\\u0641 \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u0625\\u0644\\u0649 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062b\\u0645\\u0631\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0627\\u0642\\u062a\\u0635\\u0627\\u062f \\u0627\\u0644\\u0623\\u0648\\u0633\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631 \\u0627\\u0644\\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629\\u060c \\u0645\\u0639 \\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0641\\u0633\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0648\\u0645\\u0646\\u0639 \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u0644 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0648\\u0643\\u064a\\u0627\\u062a \\u0627\\u0644\\u0633\\u064a\\u0626\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0632\\u0645\\u0627\\u062a \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645\\u064a\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 13,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Financial Regulation","hi":"\\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928","ar":"\\u0627\\u0644\\u0644\\u0627\\u0626\\u062d\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629"}',
                'parent_category_id' => 1,
                'slug' => 'financial-regulation-13',
                'updated_at' => '2023-10-11 15:50:44',
            ),
            13 => 
            array (
                'created_at' => '2023-08-08 13:05:11',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Medical cannabis regulation refers to the legal framework and rules established by government authorities to govern the cultivation, production, distribution, prescription, and use of cannabis for medical purposes. Medical cannabis, also known as medical marijuana, is the use of cannabis and its derivatives to alleviate symptoms and manage medical conditions under the supervision of healthcare professionals.<\\/p>","hi":"<p>\\u092e\\u0947\\u0921\\u093f\\u0915\\u0932 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0940 \\u0917\\u0908 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0930\\u0942\\u092a\\u0930\\u0947\\u0916\\u093e \\u0914\\u0930 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u0935\\u093f\\u0915\\u0938\\u093e\\u0928, \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u0921\\u0949\\u0915\\u094d\\u091f\\u0930 \\u0915\\u0940 \\u0938\\u093f\\u092b\\u093e\\u0930\\u093f\\u0936, \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092e\\u0947\\u0921\\u093f\\u0915\\u0932 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938, \\u091c\\u093f\\u0938\\u0947 \\u092e\\u0947\\u0921\\u093f\\u0915\\u0932 \\u092e\\u093e\\u0930\\u093f\\u091c\\u0941\\u0906\\u0928\\u093e \\u092d\\u0940 \\u0915\\u0939\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0938\\u0947\\u0935\\u093e \\u092a\\u0947\\u0936\\u0947\\u0935\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0928\\u093f\\u0917\\u0930\\u093e\\u0928\\u0940 \\u092e\\u0947\\u0902 \\u0932\\u0915\\u094d\\u0937\\u0923\\u094b\\u0902 \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0914\\u0930 \\u0909\\u0938\\u0915\\u0947 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u062a\\u064a \\u0648\\u0636\\u0639\\u062a\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0632\\u0631\\u0627\\u0639\\u0629 \\u0648\\u0625\\u0646\\u062a\\u0627\\u062c \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u0648\\u0635\\u0641 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0637\\u0628\\u064a\\u0629. \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a\\u060c \\u0627\\u0644\\u0645\\u0639\\u0631\\u0648\\u0641 \\u0623\\u064a\\u0636\\u0627 \\u0628\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0631\\u064a\\u062c\\u0648\\u0627\\u0646\\u0627 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629\\u060c \\u0647\\u0648 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0648\\u0645\\u0634\\u062a\\u0642\\u0627\\u062a\\u0647 \\u0644\\u062a\\u062e\\u0641\\u064a\\u0641 \\u0627\\u0644\\u0623\\u0639\\u0631\\u0627\\u0636 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u062a\\u062d\\u062a \\u0625\\u0634\\u0631\\u0627\\u0641 \\u0627\\u0644\\u0639\\u0646\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0647\\u0646\\u064a\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 14,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Medical Cannabis Regulation","hi":"\\u092e\\u0947\\u0921\\u093f\\u0915\\u0932 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928","ar":"\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a"}',
                'parent_category_id' => 2,
                'slug' => 'medical-cannabis-regulation-14',
                'updated_at' => '2023-10-11 15:45:58',
            ),
            14 => 
            array (
                'created_at' => '2023-08-08 13:05:57',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Recreational cannabis regulation refers to the legal framework and rules established by government authorities to govern the cultivation, distribution, sale, possession, and use of cannabis for non-medical or recreational purposes. Recreational cannabis legalization allows adults to purchase and consume cannabis products for personal use within specified legal limits.<\\/p>","hi":"<p>\\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0928\\u093f\\u0915 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u093f\\u0915 \\u092f\\u093e \\u092e\\u0947\\u0921\\u093f\\u0915\\u0932 \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928 \\u0915\\u0947\\u0935\\u0932 \\u092c\\u0932\\u094d\\u0915\\u093f \\u0905\\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0940\\u092e\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u0935\\u093f\\u0915\\u0938\\u093e\\u0928, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940, \\u0939\\u093f\\u0930\\u093e\\u0938\\u0924 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0940 \\u0917\\u0908 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0930\\u0942\\u092a\\u0930\\u0947\\u0916\\u093e \\u0914\\u0930 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0928\\u093f\\u0915 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940\\u0915\\u0930\\u0923 \\u0935\\u092f\\u0938\\u094d\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u0930\\u094d\\u0926\\u093f\\u0937\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0940\\u092e\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0905\\u0902\\u0926\\u0930 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u0915\\u0940 \\u0916\\u0930\\u0940\\u0926 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0641\\u064a\\u0647\\u064a \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u062a\\u064a \\u0623\\u0646\\u0634\\u0623\\u062a\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0632\\u0631\\u0627\\u0639\\u0629 \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u0628\\u064a\\u0639 \\u0648\\u062d\\u064a\\u0627\\u0632\\u0629 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0637\\u0628\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0631\\u0641\\u064a\\u0647\\u064a\\u0629. \\u064a\\u0633\\u0645\\u062d \\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0641\\u064a\\u0647\\u064a \\u0644\\u0644\\u0628\\u0627\\u0644\\u063a\\u064a\\u0646 \\u0628\\u0634\\u0631\\u0627\\u0621 \\u0648\\u0627\\u0633\\u062a\\u0647\\u0644\\u0627\\u0643 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a \\u0636\\u0645\\u0646 \\u062d\\u062f\\u0648\\u062f \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0645\\u062d\\u062f\\u062f\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 15,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Recreational Cannabis Regulation","hi":"\\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0915 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928","ar":"\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0641\\u064a\\u0647\\u064a"}',
                'parent_category_id' => 2,
                'slug' => 'recreational-cannabis-regulation-15',
                'updated_at' => '2023-10-11 15:43:58',
            ),
            15 => 
            array (
                'created_at' => '2023-08-08 13:06:35',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Cannabis licensing and permits refer to the legal authorizations granted by government authorities to individuals, businesses, or organizations to engage in various activities related to the cultivation, processing, distribution, sale, and possession of cannabis. These licenses and permits are an integral part of the regulated cannabis industry and are designed to ensure compliance with applicable therapys, promote public safety, and manage the legal cannabis market.<\\/p>","hi":"<p>\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u092a\\u0930\\u092e\\u093f\\u091f \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902, \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902 \\u092f\\u093e \\u0938\\u0902\\u0917\\u0920\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u0935\\u093f\\u0915\\u0938\\u093e\\u0928, \\u092a\\u094d\\u0930\\u0938\\u0902\\u0938\\u094d\\u0915\\u0930\\u0923, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940 \\u0914\\u0930 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0926\\u0940 \\u091c\\u093e\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e\\u090f\\u0901 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938 \\u0914\\u0930 \\u092a\\u0930\\u092e\\u093f\\u091f \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u093f\\u0924 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u0915\\u093e \\u090f\\u0915 \\u0905\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u093f\\u0938\\u094d\\u0938\\u093e \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0909\\u0928\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0932\\u093e\\u0917\\u0942 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e, \\u091c\\u0928\\u0939\\u093f\\u0924 \\u092e\\u0947\\u0902 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092a\\u094d\\u0930\\u094b\\u0924\\u094d\\u0938\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0914\\u0930 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092c\\u093e\\u091c\\u093e\\u0930 \\u0915\\u093e \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635 \\u0648\\u062a\\u0635\\u0627\\u0631\\u064a\\u062d \\u0627\\u0644\\u0642\\u0646\\u0628 \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0641\\u0648\\u064a\\u0636\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u0646\\u062d\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0623\\u0648 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u0638\\u0645\\u0627\\u062a \\u0644\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0641\\u064a \\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0648\\u062a\\u062c\\u0647\\u064a\\u0632 \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u0628\\u064a\\u0639 \\u0648\\u062d\\u064a\\u0627\\u0632\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628. \\u062a\\u0639\\u062a\\u0628\\u0631 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635 \\u0648\\u0627\\u0644\\u062a\\u0635\\u0627\\u0631\\u064a\\u062d \\u062c\\u0632\\u0621\\u064b\\u0627 \\u0623\\u0633\\u0627\\u0633\\u064a\\u064b\\u0627 \\u0645\\u0646 \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u0636\\u0639 \\u0644\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0648\\u062a\\u0647\\u062f\\u0641 \\u0625\\u0644\\u0649 \\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0633\\u0627\\u0631\\u064a\\u0629\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629\\u060c \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0633\\u0648\\u0642 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0644\\u0644\\u0642\\u0646\\u0628.<\\/p>"}',
                'icon' => NULL,
                'id' => 16,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Cannabis Licensing and Permits","hi":"\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u092a\\u0930\\u092e\\u093f\\u091f","ar":"\\u062a\\u0631\\u062e\\u064a\\u0635 \\u0648\\u062a\\u0635\\u0627\\u0631\\u064a\\u062d \\u0627\\u0644\\u0642\\u0646\\u0628"}',
                'parent_category_id' => 2,
                'slug' => 'cannabis-licensing-and-permits-16',
                'updated_at' => '2023-10-11 15:39:48',
            ),
            16 => 
            array (
                'created_at' => '2023-08-08 13:07:25',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>Cannabis business regulation refers to the legal framework and rules established by government authorities to oversee and govern the operations of businesses engaged in the cannabis industry. These regulations cover various aspects of the cannabis business, including licensing, production, distribution, retail, marketing, and compliance with local, state, or national therapys.<\\/p>","hi":"<p>\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0914\\u0930 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092e\\u0947\\u0902 \\u0935\\u094d\\u092f\\u093e\\u092a\\u094d\\u0924 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0902\\u091a\\u093e\\u0932\\u0928 \\u0915\\u094b \\u0928\\u093f\\u0917\\u0930\\u093e\\u0928\\u0940 \\u0914\\u0930 \\u0936\\u093e\\u0938\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0947 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u0948\\u0938\\u0947 \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938, \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u0916\\u0941\\u0926\\u0930\\u093e, \\u0935\\u093f\\u092a\\u0923\\u0928, \\u0914\\u0930 \\u0938\\u094d\\u0925\\u093e\\u0928\\u0940\\u092f, \\u0930\\u093e\\u091c\\u094d\\u092f, \\u092f\\u093e \\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928\\u0964<\\/p>","ar":"<p>\\u062a\\u0646\\u0638\\u064a\\u0645 \\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u062a\\u064a \\u0623\\u0646\\u0634\\u0623\\u062a\\u0647\\u0627 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0644\\u0644\\u0625\\u0634\\u0631\\u0627\\u0641 \\u0648\\u0627\\u0644\\u062a\\u062d\\u0643\\u0645 \\u0641\\u064a \\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0639\\u0645\\u0644 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628. \\u062a\\u0634\\u0645\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u062c\\u0648\\u0627\\u0646\\u0628 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u0646 \\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0642\\u0646\\u0628\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0631\\u062e\\u0635\\u060c \\u0648\\u0627\\u0644\\u0625\\u0646\\u062a\\u0627\\u062c\\u060c \\u0648\\u0627\\u0644\\u062a\\u0648\\u0632\\u064a\\u0639\\u060c \\u0648\\u0627\\u0644\\u0628\\u064a\\u0639 \\u0628\\u0627\\u0644\\u062a\\u062c\\u0632\\u0626\\u0629\\u060c \\u0648\\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642\\u060c \\u0648\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062d\\u0644\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0648\\u0644\\u0627\\u0626\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0648\\u0637\\u0646\\u064a\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 17,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Cannabis Business Regulation","hi":"\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928","ar":"\\u062a\\u0646\\u0638\\u064a\\u0645 \\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628"}',
                'parent_category_id' => 2,
                'slug' => 'cannabis-business-regulation-17',
                'updated_at' => '2023-10-11 15:37:35',
            ),
            17 => 
            array (
                'created_at' => '2023-08-08 13:08:15',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>The taxation of cannabis refers to the imposition of various taxes on the production, distribution, sale, and consumption of cannabis products. As cannabis legalization has gained traction in many jurisdictions for both medical and recreational use, governments have implemented taxation systems to generate revenue, fund regulatory efforts, and address public health concerns associated with cannabis use.<\\/p>","hi":"<p>\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u0940 \\u0915\\u0930 \\u0932\\u0917\\u093e\\u0928\\u0947 \\u0915\\u093e \\u092e\\u0924\\u0932\\u092c \\u0939\\u0948 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u092a\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u093e\\u0964 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940\\u0915\\u0930\\u0923 \\u0915\\u093e \\u092a\\u0930\\u093f\\u091a\\u092f \\u0905\\u0928\\u0947\\u0915 \\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u092a\\u0930 \\u092e\\u0947\\u0921\\u093f\\u0915\\u0932 \\u0914\\u0930 \\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0928\\u093f\\u0915 \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0939\\u0941\\u0906 \\u0939\\u0948, \\u0907\\u0938\\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0939\\u0940, \\u0938\\u0930\\u0915\\u093e\\u0930\\u0947\\u0902 \\u0930\\u093e\\u091c\\u0938\\u094d\\u0935 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0915\\u0930\\u0928\\u0947, \\u0935\\u093f\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u092a\\u094d\\u0930\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093f\\u0924\\u094d\\u0924\\u092a\\u094b\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0938\\u092e\\u0938\\u094d\\u092f\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0938\\u0902\\u092c\\u094b\\u0927\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0930 \\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e\\u090f\\u0901 \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>","ar":"<p>\\u0636\\u0631\\u064a\\u0628\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0641\\u0631\\u0636 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0636\\u0631\\u0627\\u0626\\u0628 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u062a\\u0627\\u062c \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u0628\\u064a\\u0639 \\u0648\\u0627\\u0633\\u062a\\u0647\\u0644\\u0627\\u0643 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0627\\u0644\\u0642\\u0646\\u0628. \\u0646\\u0638\\u0631\\u064b\\u0627 \\u0644\\u0623\\u0646 \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0642\\u062f \\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0642\\u0628\\u0648\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0644\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0637\\u0628\\u064a \\u0648\\u0627\\u0644\\u062a\\u0631\\u0641\\u064a\\u0647\\u064a\\u060c \\u0641\\u0642\\u062f \\u0642\\u0627\\u0645\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u0627\\u062a \\u0628\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0646\\u0638\\u0645 \\u0636\\u0631\\u064a\\u0628\\u064a\\u0629 \\u0644\\u062a\\u0648\\u0644\\u064a\\u062f \\u0627\\u0644\\u0625\\u064a\\u0631\\u0627\\u062f\\u0627\\u062a\\u060c \\u0648\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u062c\\u0647\\u0648\\u062f \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a\\u0629\\u060c \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0642\\u0644\\u0642 \\u0627\\u0644\\u0635\\u062d\\u064a \\u0627\\u0644\\u0639\\u0627\\u0645 \\u0627\\u0644\\u0645\\u0631\\u062a\\u0628\\u0637 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628.<\\/p>"}',
                'icon' => NULL,
                'id' => 18,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Taxation of Cannabis","hi":"\\u092d\\u093e\\u0902\\u0917 \\u0915\\u093e \\u0915\\u0930\\u093e\\u0927\\u093e\\u0928","ar":"\\u0641\\u0631\\u0636 \\u0627\\u0644\\u0636\\u0631\\u0627\\u0626\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0634\\u064a\\u0634"}',
                'parent_category_id' => 2,
                'slug' => 'taxation-of-cannabis-18',
                'updated_at' => '2023-10-11 15:35:37',
            ),
            18 => 
            array (
                'created_at' => '2023-08-08 13:08:54',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Cannabis intellectual property (IP) refers to the legal protections granted to innovative and original creations in the cannabis industry. Just like in other industries, intellectual property in the cannabis sector includes a range of legal tools that allow individuals and businesses to protect their inventions, brands, designs, and creative works. The unique legal and regulatory landscape surrounding cannabis IP presents both challenges and opportunities for businesses operating in this field.<\\/p>","hi":"<p>\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u092c\\u094c\\u0926\\u094d\\u0927\\u093f\\u0915 \\u0938\\u0902\\u092a\\u0926\\u093e (\\u0906\\u0908\\u092a\\u0940) \\u0909\\u0928 \\u0935\\u0948\\u0935\\u093f\\u0915 \\u0914\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092e\\u0947\\u0902 \\u0926\\u0940 \\u0917\\u0908 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u091c\\u0948\\u0938\\u093e \\u0915\\u093f \\u0905\\u0928\\u094d\\u092f \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u092e\\u0947\\u0902 \\u092c\\u094c\\u0926\\u094d\\u0927\\u093f\\u0915 \\u0938\\u0902\\u092a\\u0926\\u093e \\u092e\\u0947\\u0902 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0914\\u0930 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0909\\u0928\\u0915\\u0947 \\u0906\\u0935\\u093f\\u0937\\u094d\\u0915\\u093e\\u0930, \\u092c\\u094d\\u0930\\u093e\\u0902\\u0921, \\u0921\\u093f\\u091c\\u093e\\u0907\\u0928 \\u0914\\u0930 \\u0938\\u0943\\u091c\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0908 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0914\\u0930 \\u0909\\u092a\\u0915\\u0930\\u0923 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u092c\\u094c\\u0926\\u094d\\u0927\\u093f\\u0915 \\u0938\\u0902\\u092a\\u0926\\u093e \\u0915\\u0947 \\u091a\\u093e\\u0930\\u094b\\u0902 \\u0913\\u0930 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u092a\\u0930\\u093f\\u0926\\u0943\\u0936\\u094d\\u092f \\u0909\\u0926\\u094d\\u092f\\u092e\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u091a\\u0941\\u0928\\u094c\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0935\\u0938\\u0930\\u094b\\u0902 \\u0926\\u094b\\u0928\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629 \\u0644\\u0644\\u0642\\u0646\\u0628 \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0645\\u0646\\u0648\\u062d\\u0629 \\u0644\\u0644\\u0625\\u0628\\u062f\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0635\\u0644\\u064a\\u0629 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628. \\u062a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629 \\u0641\\u064a \\u0642\\u0637\\u0627\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0633\\u0645\\u062d \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0628\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u062e\\u062a\\u0631\\u0627\\u0639\\u0627\\u062a\\u0647\\u0645 \\u0648\\u0639\\u0644\\u0627\\u0645\\u0627\\u062a\\u0647\\u0645 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0648\\u062a\\u0635\\u0627\\u0645\\u064a\\u0645\\u0647\\u0645 \\u0648\\u0623\\u0639\\u0645\\u0627\\u0644\\u0647\\u0645 \\u0627\\u0644\\u0625\\u0628\\u062f\\u0627\\u0639\\u064a\\u0629\\u060c \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0643\\u0645\\u0627 \\u0647\\u0648 \\u0627\\u0644\\u062d\\u0627\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649. \\u064a\\u0642\\u062f\\u0645 \\u0627\\u0644\\u0645\\u0646\\u0638\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a \\u0627\\u0644\\u0641\\u0631\\u064a\\u062f \\u0627\\u0644\\u0645\\u062d\\u064a\\u0637 \\u0628\\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629 \\u0644\\u0644\\u0642\\u0646\\u0628 \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0648\\u0641\\u0631\\u0635\\u064b\\u0627 \\u0644\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0639\\u0645\\u0644 \\u0641\\u064a \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644.<\\/p>"}',
                'icon' => NULL,
                'id' => 19,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Cannabis Intellectual Property","hi":"\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u092c\\u094c\\u0926\\u094d\\u0927\\u093f\\u0915 \\u0938\\u0902\\u092a\\u0926\\u093e","ar":"\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629"}',
                'parent_category_id' => 2,
                'slug' => 'cannabis-intellectual-property-19',
                'updated_at' => '2023-10-11 15:32:51',
            ),
            19 => 
            array (
                'created_at' => '2023-08-08 13:09:39',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Cannabis home cultivation refers to the practice of individuals growing cannabis plants for personal use at their residences. Home cultivation is a significant aspect of cannabis legalization in many jurisdictions, allowing adults to cultivate a limited number of cannabis plants for personal consumption. The rules and regulations surrounding home cultivation vary widely depending on the jurisdiction and local therapys.<\\/p>","hi":"<p>\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0918\\u0930\\u0947\\u0932\\u0942 \\u0909\\u0917\\u093e\\u0908 \\u0909\\u0928 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0925\\u093e \\u0915\\u093e \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948 \\u091c\\u094b \\u0905\\u092a\\u0928\\u0947 \\u0928\\u093f\\u0935\\u093e\\u0938 \\u092a\\u0930 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u092a\\u094c\\u0927\\u0947 \\u0909\\u0917\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0918\\u0930\\u0947\\u0932\\u0942 \\u0909\\u0917\\u093e\\u0908 \\u0915\\u0908 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u094b \\u0935\\u0948\\u0927 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0935\\u092f\\u0938\\u094d\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0940\\u092e\\u093f\\u0924 \\u0938\\u0902\\u0916\\u094d\\u092f\\u093e \\u092e\\u0947\\u0902 \\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u092a\\u094c\\u0927\\u0947 \\u0909\\u0917\\u093e\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0918\\u0930\\u0947\\u0932\\u0942 \\u0909\\u0917\\u093e\\u0908 \\u0915\\u0947 \\u091a\\u093e\\u0930\\u094b\\u0902 \\u0913\\u0930 \\u0928\\u093f\\u092f\\u092e \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u093e\\u0927\\u0940\\u0928 \\u0914\\u0930 \\u0938\\u094d\\u0925\\u093e\\u0928\\u0940\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928\\u0924\\u093e \\u0926\\u093f\\u0916\\u093e \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>","ar":"<p>\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0644\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0646\\u0628\\u0627\\u062a\\u0627\\u062a \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a \\u0641\\u064a \\u0645\\u0646\\u0627\\u0632\\u0644\\u0647\\u0645. \\u0625\\u0646 \\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0647\\u064a \\u062c\\u0627\\u0646\\u0628 \\u0647\\u0627\\u0645 \\u0645\\u0646 \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0641\\u064a \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a\\u060c \\u062d\\u064a\\u062b \\u062a\\u0633\\u0645\\u062d \\u0644\\u0644\\u0628\\u0627\\u0644\\u063a\\u064a\\u0646 \\u0628\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0639\\u062f\\u062f \\u0645\\u062d\\u062f\\u0648\\u062f \\u0645\\u0646 \\u0646\\u0628\\u0627\\u062a\\u0627\\u062a \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0644\\u0627\\u0633\\u062a\\u0647\\u0644\\u0627\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a. \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0645\\u062d\\u064a\\u0637\\u0629 \\u0628\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644 \\u0628\\u0634\\u0643\\u0644 \\u0648\\u0627\\u0633\\u0639 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0648\\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062d\\u0644\\u064a\\u0629.<\\/p>"}',
                'icon' => NULL,
                'id' => 20,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Cannabis Home Cultivation","hi":"\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0918\\u0930\\u0947\\u0932\\u0942 \\u0916\\u0947\\u0924\\u0940","ar":"\\u0632\\u0631\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0645\\u0646\\u0632\\u0644\\u064a\\u0629"}',
                'parent_category_id' => 2,
                'slug' => 'cannabis-home-cultivation-20',
                'updated_at' => '2023-10-11 15:30:20',
            ),
            20 => 
            array (
                'created_at' => '2023-08-08 13:13:20',
                'deleted_at' => NULL,
                'description' => '{"hi":"<p> \\u092c\\u093f\\u0932\\u094d\\u0915\\u0941\\u0932, \\"\\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927\\u094b\\u0902\\" \\u0935\\u094d\\u092f\\u093e\\u0935\\u093e\\u0938\\u093f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u090f\\u0915 \\u092e\\u094c\\u0932\\u093f\\u0915 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0939\\u0948 \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0935\\u0947\\u0936 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0915\\u0941\\u091b \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u0909\\u092a\\u0935\\u0930\\u094d\\u0917\\u094b\\u0902 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927\\u094b\\u0902 \\u0915\\u0947 \\u0939\\u0948\\u0902: <\\/p>","ar":"<p> \\u0628\\u0627\\u0644\\u062a\\u0623\\u0643\\u064a\\u062f\\u060c \\"\\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0648\\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a\\" \\u0647\\u0648 \\u0645\\u062c\\u0627\\u0644 \\u0623\\u0633\\u0627\\u0633\\u064a \\u062f\\u0627\\u062e\\u0644 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a \\u064a\\u0634\\u0645\\u0644 \\u0623\\u0646\\u0648\\u0627\\u0639\\u064b\\u0627 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u0631\\u062a\\u064a\\u0628\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0641\\u0626\\u0627\\u062a \\u0627\\u0644\\u0641\\u0631\\u0639\\u064a\\u0629 \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629 \\u0648\\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0648\\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a: <\\/p>","en":"<p>Certainly, &quot;Contracts and Agreements&quot; is a fundamental area within commercial therapy that encompasses various types of legal arrangements and obligations between parties. Here are some common subcategories and types of contracts and agreements:<\\/p>"}',
                'icon' => NULL,
                'id' => 21,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Contracts and Agreements","hi":"\\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u0914\\u0930 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947","ar":"\\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0648\\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a"}',
                'parent_category_id' => 3,
                'slug' => 'contracts-and-agreements-21',
                'updated_at' => '2023-10-11 15:24:23',
            ),
            21 => 
            array (
                'created_at' => '2023-08-08 13:13:59',
                'deleted_at' => NULL,
                'description' => '{"hi":"<p> \\"\\u092e\\u093e\\u0932 \\u0915\\u0940 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940\\" \\u090f\\u0915 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0909\\u092a\\u0935\\u0930\\u094d\\u0917 \\u0939\\u0948 \\u091c\\u094b \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948 \\u0914\\u0930 \\u092f\\u0939 \\u0909\\u092a\\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0939\\u0948 \\u091c\\u094b \\u0935\\u0938\\u094d\\u0924\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u0916\\u0930\\u0940\\u0926\\u0926\\u093e\\u0930\\u0940 \\u0914\\u0930 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u094b \\u0935\\u093f\\u0935\\u0930\\u0923\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902 \\u0935\\u0947 \\u0928\\u093f\\u092f\\u092e \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u093e\\u0901 \\u091c\\u094b \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u0947 \\u0938\\u094d\\u0925\\u093e\\u0928\\u093e\\u0902\\u0924\\u0930\\u0923, \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930, \\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935, \\u0914\\u0930 \\u0935\\u0938\\u094d\\u0924\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940 \\u0938\\u0947 \\u091c\\u0941\\u0921\\u093c\\u0947 \\u091c\\u094b\\u0916\\u093f\\u092e\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u0938\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0935\\u0938\\u094d\\u0924\\u0941\\u0913\\u0902 \\u0915\\u0940 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0941\\u091b \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0905\\u0935\\u0927\\u093e\\u0930\\u0923\\u093e\\u090f\\u0901 \\u0914\\u0930 \\u092a\\u0939\\u0932\\u0941 \\u0939\\u0948\\u0902: <\\/p>","ar":"<p> \\"\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0633\\u0644\\u0639\\" \\u0647\\u0648 \\u0641\\u0626\\u0629 \\u0641\\u0631\\u0639\\u064a\\u0629 \\u0645\\u062d\\u062f\\u062f\\u0629 \\u062f\\u0627\\u062e\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u062a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0634\\u0631\\u0627\\u0621 \\u0648\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0633\\u0644\\u0639 \\u0627\\u0644\\u0645\\u0644\\u0645\\u0648\\u0633\\u0629. \\u0625\\u0646\\u0647 \\u064a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0643\\u0645 \\u0646\\u0642\\u0644 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631 \\u0627\\u0644\\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0633\\u0644\\u0639. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0645\\u0641\\u0627\\u0647\\u064a\\u0645 \\u0648\\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0633\\u0644\\u0639: <\\/p>","en":"<p>&quot;Sale of Goods&quot; is a specific subcategory within contract therapy that deals with legal aspects related to the buying and selling of tangible goods. It encompasses the rules and regulations that govern the transfer of ownership, rights, obligations, and risks associated with the sale of goods. Here are some key concepts and aspects related to the Sale of Goods:<\\/p>"}',
                'icon' => NULL,
                'id' => 22,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Sale of Goods","hi":"\\u092e\\u093e\\u0932 \\u0915\\u0940 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940","ar":"\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0628\\u0636\\u0627\\u0626\\u0639"}',
                'parent_category_id' => 3,
                'slug' => 'sale-of-goods-22',
                'updated_at' => '2023-10-11 15:25:55',
            ),
            22 => 
            array (
                'created_at' => '2023-08-08 13:15:15',
                'deleted_at' => NULL,
            'description' => '{"hi":"<p> \\"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928\\" \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092d\\u0940\\u0924\\u0930 \\u090f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0935\\u0927\\u093e\\u0930\\u0923\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u090f\\u0915 \\u090b\\u0923\\u0940 (\\u090b\\u0923\\u0940) \\u0909\\u0927\\u093e\\u0930 \\u0932\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u0909\\u0927\\u093e\\u0930 \\u0926\\u0947\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 (\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092a\\u0915\\u094d\\u0937) \\u0915\\u094b \\u0909\\u092a\\u093e\\u0930\\u094d\\u091c\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u092a\\u093e\\u0930\\u094d\\u091c\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0909\\u092a\\u093e\\u0930\\u094d\\u091c\\u093f\\u0924 \\u0935\\u0938\\u094d\\u0924\\u094d\\u0930 \\u090b\\u0923 \\u0915\\u0947 \\u091a\\u0941\\u0915\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092f\\u093e \\u0917\\u093e\\u0930\\u0902\\u091f\\u0940 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0915\\u093e\\u092e \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0926\\u093f \\u090b\\u0923\\u0940 \\u0909\\u0927\\u093e\\u0930 \\u0915\\u0940 \\u0905\\u092a\\u0947\\u0915\\u094d\\u0937\\u093e \\u092a\\u0930 \\u0916\\u0930\\u093e\\u092c \\u0939\\u094b \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0924\\u094b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u092a\\u0915\\u094d\\u0937 \\u0915\\u094b \\u090b\\u0923 \\u0915\\u094b \\u091a\\u0941\\u0915\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u092a\\u093e\\u0930\\u094d\\u091c\\u093f\\u0924 \\u0935\\u0938\\u094d\\u0924\\u094d\\u0930 \\u0915\\u0947 \\u0938\\u094d\\u0935\\u093e\\u092e\\u093f\\u0924\\u094d\\u0935 \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0941\\u091b \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941 \\u0914\\u0930 \\u0905\\u0935\\u0927\\u093e\\u0930\\u0923\\u093e\\u090f\\u0901 \\u0939\\u0948\\u0902: <\\/p>","ar":"<p> \\"\\u0635\\u0641\\u0642\\u0627\\u062a \\u0645\\u0624\\u0645\\u0646\\u0629\\" \\u0647\\u0648 \\u0645\\u0641\\u0647\\u0648\\u0645 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u062f\\u0627\\u062e\\u0644 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0635\\u0641\\u0642\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u064a\\u062a\\u0639\\u0647\\u062f \\u0641\\u064a\\u0647\\u0627 \\u0627\\u0644\\u0645\\u0642\\u062a\\u0631\\u0636 (\\u0627\\u0644\\u0645\\u062f\\u064a\\u0646) \\u0628\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0636\\u0645\\u0627\\u0646 \\u0644\\u0644\\u0645\\u0642\\u0631\\u0636 (\\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0645\\u0624\\u0645\\u0646) \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0642\\u0631\\u0636 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0632\\u0627\\u0645 \\u0622\\u062e\\u0631. \\u064a\\u0639\\u0645\\u0644 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0643\\u0634\\u0643\\u0644 \\u0645\\u0646 \\u0623\\u0634\\u0643\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0644\\u0633\\u062f\\u0627\\u062f \\u0627\\u0644\\u062f\\u064a\\u0646. \\u0625\\u0630\\u0627 \\u062a\\u062e\\u0644\\u0641 \\u0627\\u0644\\u0645\\u062f\\u064a\\u0646 \\u0639\\u0646 \\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u060c \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0644\\u062f\\u0649 \\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0645\\u0624\\u0645\\u0646 \\u0627\\u0644\\u062d\\u0642 \\u0641\\u064a \\u0627\\u062a\\u062e\\u0627\\u0630 \\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0644\\u062a\\u0633\\u062f\\u064a\\u062f \\u0627\\u0644\\u062f\\u064a\\u0646. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0641\\u0627\\u0647\\u064a\\u0645 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0635\\u0641\\u0642\\u0627\\u062a \\u0627\\u0644\\u0645\\u0624\\u0645\\u0646\\u0629: <\\/p>","en":"<p>&quot;Secured Transactions&quot; is a legal concept within commercial therapy that involves transactions where a borrower (debtor) pledges collateral to a lender (secured party) to secure a loan or other obligation. The collateral serves as a form of security or guarantee for the repayment of the debt. If the debtor defaults on the obligation, the secured party may have the right to take ownership of the collateral to satisfy the debt. Here are some key aspects and concepts related to secured transactions:<\\/p>"}',
                'icon' => NULL,
                'id' => 23,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Secured Transactions","hi":"\\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928","ar":"\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0636\\u0645\\u0648\\u0646\\u0629"}',
                'parent_category_id' => 3,
                'slug' => 'secured-transactions-23',
                'updated_at' => '2023-10-11 15:26:48',
            ),
            23 => 
            array (
                'created_at' => '2023-08-08 13:16:21',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&quot;Payment Systems&quot; refer to the methods, processes, and mechanisms used for the transfer of funds, payments, and financial transactions between individuals, businesses, and financial institutions. These systems facilitate the movement of money and enable the exchange of goods and services. Here are some key aspects and concepts related to payment systems:<\\/p>","hi":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>\\"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u093f\\u092f\\u093e\\u0901\\" \\u0909\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902, \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902, \\u0914\\u0930 \\u092f\\u093e\\u0902\\u0924\\u094d\\u0930\\u093f\\u0915\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0915\\u0947\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u091c\\u093f\\u0928\\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0927\\u0928, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928, \\u0914\\u0930 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902, \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902, \\u0914\\u0930 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0947 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u093f\\u092f\\u093e\\u0901 \\u0927\\u0928 \\u0915\\u0947 \\u0906\\u0902\\u0924\\u0930\\u093f\\u0915 \\u0938\\u0902\\u091a\\u092f \\u0914\\u0930 \\u0938\\u093e\\u092e\\u0917\\u094d\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0935\\u093f\\u0924 \\u092c\\u0928\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u093f\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0941\\u091b \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u090f\\u0902 \\u0914\\u0930 \\u0905\\u0935\\u0927\\u093e\\u0930\\u0923\\u093e\\u090f\\u0901 \\u0939\\u0948\\u0902:<\\/p>","ar":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>\\"\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639\\" \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0644\\u064a\\u0628 \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u0622\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u0629 \\u0644\\u0646\\u0642\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0648\\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629. \\u062a\\u0633\\u0647\\u0645 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0641\\u064a \\u062a\\u064a\\u0633\\u064a\\u0631 \\u062d\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0648\\u062a\\u0645\\u0643\\u064a\\u0646 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0639 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0641\\u0627\\u0647\\u064a\\u0645 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639:<\\/p>"}',
                'icon' => NULL,
                'id' => 24,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Payment Systems","hi":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u0940","ar":"\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639"}',
                'parent_category_id' => 3,
                'slug' => 'payment-systems-24',
                'updated_at' => '2023-10-10 21:00:56',
            ),
            24 => 
            array (
                'created_at' => '2023-08-08 13:16:23',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&quot;Payment Systems&quot; refer to the methods, processes, and mechanisms used for the transfer of funds, payments, and financial transactions between individuals, businesses, and financial institutions. These systems facilitate the movement of money and enable the exchange of goods and services. Here are some key aspects and concepts related to payment systems:<\\/p>","hi":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>\\"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u093f\\u092f\\u093e\\u0901\\" \\u0909\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902, \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902, \\u0914\\u0930 \\u092f\\u093e\\u0902\\u0924\\u094d\\u0930\\u093f\\u0915\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0915\\u0947\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u091c\\u093f\\u0928\\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0927\\u0928, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928, \\u0914\\u0930 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902, \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902, \\u0914\\u0930 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0947 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u093f\\u092f\\u093e\\u0901 \\u0927\\u0928 \\u0915\\u0947 \\u0906\\u0902\\u0924\\u0930\\u093f\\u0915 \\u0938\\u0902\\u091a\\u092f \\u0914\\u0930 \\u0938\\u093e\\u092e\\u0917\\u094d\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0935\\u093f\\u0924 \\u092c\\u0928\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u093f\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u0941\\u091b \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u090f\\u0902 \\u0914\\u0930 \\u0905\\u0935\\u0927\\u093e\\u0930\\u0923\\u093e\\u090f\\u0901 \\u0939\\u0948\\u0902:<\\/p>","ar":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>\\"\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639\\" \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0644\\u064a\\u0628 \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u0622\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u0629 \\u0644\\u0646\\u0642\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0648\\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629. \\u062a\\u0633\\u0647\\u0645 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0641\\u064a \\u062a\\u064a\\u0633\\u064a\\u0631 \\u062d\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0648\\u062a\\u0645\\u0643\\u064a\\u0646 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0639 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0641\\u0627\\u0647\\u064a\\u0645 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639:<\\/p>"}',
                'icon' => NULL,
                'id' => 25,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Payment Systems","hi":"\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u0940","ar":"\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639"}',
                'parent_category_id' => 3,
                'slug' => 'payment-systems-25',
                'updated_at' => '2023-10-10 20:55:42',
            ),
            25 => 
            array (
                'created_at' => '2023-08-08 13:17:05',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>A franchise agreement is a legal contract between two parties&mdash;the franchisor and the franchisee&mdash;that outlines the terms and conditions of a franchise business relationship. In a franchise arrangement, the franchisor grants the franchisee the right to operate a business using its established brand, business model, and support systems. The franchisee pays fees and follows the franchisor&#39;s guidelines in exchange for the benefits of operating under a recognized brand and receiving ongoing support. Here are some key aspects and components of a franchise agreement:<\\/p>","hi":"<p>\\u092b\\u094d\\u0930\\u0947\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0935\\u0939 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u0939\\u0948 \\u091c\\u094b \\u0926\\u094b \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 - \\u092b\\u094d\\u0930\\u0948\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940\\u0926\\u093e\\u0924\\u093e \\u0914\\u0930 \\u092b\\u094d\\u0930\\u0947\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940 - \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u090f\\u0915 \\u092b\\u094d\\u0930\\u0947\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940 \\u0935\\u094d\\u092f\\u093e\\u0935\\u0938\\u093e\\u092f\\u093f\\u0915 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u0915\\u0940 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u0930\\u0942\\u092a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092b\\u094d\\u0930\\u0947\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940 \\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e \\u092e\\u0947\\u0902, \\u092b\\u094d\\u0930\\u0948\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940\\u0926\\u093e\\u0924\\u093e \\u0915\\u094b \\u092b\\u094d\\u0930\\u0948\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940 \\u0915\\u094b \\u0909\\u0938\\u0915\\u0947 \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u092c\\u094d\\u0930\\u093e\\u0902\\u0921, \\u0935\\u094d\\u092f\\u093e\\u0935\\u0938\\u093e\\u092f\\u093f\\u0915 \\u0928\\u092e\\u0942\\u0928\\u093e \\u0914\\u0930 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u092a\\u094d\\u0930\\u0923\\u093e\\u0932\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0926\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092b\\u094d\\u0930\\u0947\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940\\u0926\\u093e\\u0924\\u093e \\u0936\\u0941\\u0932\\u094d\\u0915 \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948 \\u0914\\u0930 \\u092b\\u094d\\u0930\\u0948\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940\\u0926\\u093e\\u0924\\u093e \\u0915\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0909\\u0938\\u0915\\u0947 \\u0905\\u0927\\u0940\\u0928 \\u090f\\u0915 \\u092e\\u093e\\u0928\\u094d\\u092f\\u0924\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u092c\\u094d\\u0930\\u093e\\u0902\\u0921 \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0935\\u094d\\u092f\\u093e\\u0935\\u0938\\u093e\\u092f\\u093f\\u0915\\u0924\\u093e \\u0915\\u0947 \\u0932\\u093e\\u092d \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0914\\u0930 \\u0928\\u093f\\u0930\\u0902\\u0924\\u0930 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0915\\u0941\\u091b \\u092b\\u094d\\u0930\\u0947\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0918\\u091f\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u0916\\u093e\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a \\u0647\\u064a \\u0639\\u0642\\u062f \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0628\\u064a\\u0646 \\u0637\\u0631\\u0641\\u064a\\u0646 - \\u0645\\u0646\\u062d \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632 \\u0648\\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632 - \\u064a\\u062d\\u062f\\u062f \\u0634\\u0631\\u0648\\u0637 \\u0648\\u0623\\u062d\\u0643\\u0627\\u0645 \\u0639\\u0644\\u0627\\u0642\\u0629 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u062a\\u0627\\u0628\\u0639\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632. \\u0641\\u064a \\u0627\\u0644\\u062a\\u0631\\u062a\\u064a\\u0628 \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632\\u064a\\u060c \\u064a\\u0645\\u0646\\u062d \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632 \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632\\u064a \\u0627\\u0644\\u062d\\u0642 \\u0641\\u064a \\u062a\\u0634\\u063a\\u064a\\u0644 \\u0639\\u0645\\u0644 \\u062a\\u062c\\u0627\\u0631\\u064a \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0639\\u0644\\u0627\\u0645\\u062a\\u0647 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0639\\u062a\\u0631\\u0641 \\u0628\\u0647\\u0627\\u060c \\u0648\\u0646\\u0645\\u0648\\u0630\\u062c \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0648\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u062b\\u0628\\u062a\\u0629. \\u064a\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632\\u064a \\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0648\\u064a\\u062a\\u0628\\u0639 \\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0641\\u0648\\u0627\\u0626\\u062f \\u062a\\u0634\\u063a\\u064a\\u0644 \\u062a\\u062d\\u062a \\u0639\\u0644\\u0627\\u0645\\u0629 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0639\\u062a\\u0631\\u0641 \\u0628\\u0647\\u0627 \\u0648\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0627\\u0644\\u062f\\u0639\\u0645. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0643\\u0648\\u0646\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0645\\u062a\\u064a\\u0627\\u0632:<\\/p>"}',
                'icon' => NULL,
                'id' => 26,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Franchise Agreement","hi":"\\u092b\\u094d\\u0930\\u0948\\u0902\\u091a\\u093e\\u0907\\u091c\\u093c\\u0940 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e","ar":"\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629 \\u0627\\u0645\\u062a\\u064a\\u0627\\u0632"}',
                'parent_category_id' => 3,
                'slug' => 'franchise-agreement-26',
                'updated_at' => '2023-10-10 20:52:15',
            ),
            26 => 
            array (
                'created_at' => '2023-08-08 13:22:01',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>&quot;Real Estate Transactions&quot; refer to the legal processes and activities involved in the buying, selling, leasing, financing, and management of real property. Real estate transactions encompass a range of activities, from residential home purchases to commercial property acquisitions. Here are some key aspects and components of real estate transactions:<\\/p>","hi":"<p>\\"\\u0930\\u093f\\u092f\\u0932 \\u090f\\u0938\\u094d\\u091f\\u0947\\u091f \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928\\" \\u0909\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0915\\u0947\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0935\\u093e\\u0938\\u094d\\u0924\\u0935\\u093f\\u0915 \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u0940 \\u0916\\u0930\\u0940\\u0926\\u0926\\u093e\\u0930\\u0940, \\u092c\\u0947\\u091a\\u093e\\u0928, \\u0932\\u0940\\u091c\\u093c, \\u0935\\u093f\\u0924\\u094d\\u0924\\u092a\\u094b\\u0937\\u0923 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0930\\u093f\\u092f\\u0932 \\u090f\\u0938\\u094d\\u091f\\u0947\\u091f \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0928\\u093f\\u0935\\u093e\\u0938\\u0940 \\u0918\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0916\\u0930\\u0940\\u0926\\u0926\\u093e\\u0930\\u0940 \\u0938\\u0947 \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0917\\u094d\\u0930\\u0939\\u0923 \\u0924\\u0915 \\u0915\\u0908 \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0906\\u0935\\u0930\\u0923 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0915\\u0941\\u091b \\u092e\\u0941\\u0916\\u094d\\u092f \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0930\\u093f\\u092f\\u0932 \\u090f\\u0938\\u094d\\u091f\\u0947\\u091f \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0918\\u091f\\u0915 \\u0926\\u093f\\u0916\\u093e\\u090f \\u0917\\u090f \\u0939\\u0948\\u0902:<\\/p>","ar":"<p>\\u062a\\u0634\\u064a\\u0631 \\"\\u0635\\u0641\\u0642\\u0627\\u062a \\u0627\\u0644\\u0639\\u0642\\u0627\\u0631\\u0627\\u062a\\" \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0636\\u0645\\u0646\\u0629 \\u0641\\u064a \\u0634\\u0631\\u0627\\u0621 \\u0648\\u0628\\u064a\\u0639 \\u0648\\u062a\\u0623\\u062c\\u064a\\u0631 \\u0648\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0639\\u0642\\u0627\\u0631\\u0627\\u062a. \\u062a\\u0634\\u0645\\u0644 \\u0635\\u0641\\u0642\\u0627\\u062a \\u0627\\u0644\\u0639\\u0642\\u0627\\u0631\\u0627\\u062a \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0646\\u0634\\u0637\\u0629\\u060c \\u0628\\u062f\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0634\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0632\\u0644 \\u0627\\u0644\\u0633\\u0643\\u0646\\u064a\\u0629 \\u062d\\u062a\\u0649 \\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0643\\u0648\\u0646\\u0627\\u062a \\u0644\\u0635\\u0641\\u0642\\u0627\\u062a \\u0627\\u0644\\u0639\\u0642\\u0627\\u0631\\u0627\\u062a:<\\/p>"}',
                'icon' => NULL,
                'id' => 27,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Real Estate Transactions","hi":"\\u0930\\u093f\\u092f\\u0932 \\u090f\\u0938\\u094d\\u091f\\u0947\\u091f \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928","ar":"\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0639\\u0642\\u0627\\u0631\\u064a\\u0629"}',
                'parent_category_id' => 3,
                'slug' => 'real-estate-transactions-27',
                'updated_at' => '2023-10-10 20:47:53',
            ),
            27 => 
            array (
                'created_at' => '2023-08-08 13:23:28',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>&quot;Mergers and Acquisitions&quot; (M&amp;A) refers to the process by which companies combine or undergo changes in ownership or control. M&amp;A activities involve various transactions, such as mergers, acquisitions, consolidations, and asset purchases. These transactions can be driven by strategic, financial, or operational considerations, and they have significant legal, financial, and business implications. Here are key aspects and stages of the M&amp;A process:<\\/p>","hi":"<p>\\"\\u092e\\u0930\\u094d\\u091c\\u0930\\u094d\\u0938 \\u0914\\u0930 \\u090f\\u0915\\u094d\\u0935\\u093f\\u091c\\u0940\\u0936\\u0928\\u094d\\u0938\\" (M&A) \\u0909\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0938\\u0902\\u0915\\u0947\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0928\\u092e\\u0947\\u0902 \\u0915\\u0902\\u092a\\u0928\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u090f\\u0915\\u0940\\u0915\\u0943\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948 \\u092f\\u093e \\u0938\\u094d\\u0935\\u093e\\u092e\\u093f\\u0924\\u094d\\u0935 \\u092f\\u093e \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u0923 \\u092e\\u0947\\u0902 \\u092c\\u0926\\u0932\\u093e\\u0935 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 M&A \\u0917\\u0924\\u093f\\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u0948\\u0938\\u0947 \\u092e\\u0930\\u094d\\u091c\\u0930\\u094d\\u0938, \\u090f\\u0915\\u094d\\u0935\\u093f\\u091c\\u0940\\u0936\\u0928\\u094d\\u0938, \\u0938\\u092e\\u093e\\u0939\\u093e\\u0930\\u0923 \\u0914\\u0930 \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0916\\u0930\\u0940\\u0926\\u0940\\u0964 \\u092f\\u0947 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0930\\u0923\\u0928\\u0940\\u0924\\u093f\\u0915, \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u092f\\u093e \\u092a\\u0930\\u093f\\u091a\\u093e\\u0932\\u0928 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0947\\u0930\\u093f\\u0924 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u0907\\u0928\\u0915\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940, \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0914\\u0930 \\u0935\\u094d\\u092f\\u093e\\u0935\\u0938\\u093e\\u092f\\u093f\\u0915 \\u092a\\u0930\\u093f\\u0923\\u093e\\u092e \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 M&A \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u092e\\u0941\\u0916\\u094d\\u092f \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u091a\\u0930\\u0923\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u0916\\u093e\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\"\\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630\\" (M&A) \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u062c\\u062a\\u0645\\u0639 \\u0641\\u064a\\u0647\\u0627 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0623\\u0648 \\u062a\\u062d\\u062f\\u062b \\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062d\\u0643\\u0645. \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0623\\u0646\\u0634\\u0637\\u0629 \\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629\\u060c \\u0645\\u062b\\u0644 \\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u062f\\u0645\\u062c\\u060c \\u0648\\u0634\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0623\\u0635\\u0648\\u0644. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u062f\\u0641\\u0648\\u0639\\u0629 \\u0628\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u0627\\u062a\\u064a\\u062c\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0634\\u063a\\u064a\\u0644\\u064a\\u0629\\u060c \\u0648\\u0644\\u0647\\u0627 \\u0622\\u062b\\u0627\\u0631 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0648\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0643\\u0628\\u064a\\u0631\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0631\\u0627\\u062d\\u0644 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630:<\\/p>"}',
                'icon' => NULL,
                'id' => 28,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Mergers and Acquisitions","hi":"\\u0935\\u093f\\u0932\\u092f \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0917\\u094d\\u0930\\u0939\\u0923","ar":"\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u062f\\u0645\\u062c \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630"}',
                'parent_category_id' => 3,
                'slug' => 'mergers-and-acquisitions-28',
                'updated_at' => '2023-10-10 20:42:41',
            ),
            28 => 
            array (
                'created_at' => '2023-08-08 13:26:08',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Divorce mediation is a process that helps couples navigate the challenges of divorce by facilitating open communication and negotiation to reach mutually agreeable solutions. Mediation allows divorcing spouses to work together with the assistance of a neutral mediator to address various aspects of their divorce, including property division, spousal support, child custody, visitation, and child support. Here are key aspects and considerations in divorce mediation:<\\/p>","hi":"<p>\\u0935\\u093f\\u0935\\u093e\\u0939 \\u0935\\u093f\\u091a\\u094d\\u091b\\u0947\\u0926 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u090f\\u0915 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0939\\u0948 \\u091c\\u094b \\u091c\\u094b\\u0921\\u093c\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093f\\u0935\\u093e\\u0939 \\u0915\\u0940 \\u091a\\u0941\\u0928\\u094c\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0941\\u0932\\u091d\\u093e\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u0938\\u0940\\u0927\\u0947 \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930-\\u0935\\u093f\\u092e\\u0930\\u094d\\u0936 \\u0915\\u094b \\u0938\\u0930\\u094d\\u0935\\u0938\\u092e\\u094d\\u092e\\u0924 \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928\\u094b\\u0902 \\u0924\\u0915 \\u092a\\u0939\\u0941\\u0901\\u091a\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f\\u0964 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0935\\u093f\\u0935\\u093e\\u0939\\u093f\\u0924 \\u091c\\u094b\\u0921\\u093c\\u094b\\u0902 \\u0915\\u094b \\u090f\\u0915 \\u0928\\u094d\\u092f\\u0942\\u0928\\u0924\\u092e \\u092e\\u0902\\u0924\\u094d\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u093e\\u092e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u0902\\u092d\\u093e\\u0935\\u0928\\u093e \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948 \\u0924\\u093e\\u0915\\u093f \\u0909\\u0928\\u0915\\u0947 \\u0935\\u093f\\u0935\\u093e\\u0939 \\u0915\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u093e \\u0938\\u092e\\u094d\\u092e\\u094b\\u0939\\u0928 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0947, \\u091c\\u0948\\u0938\\u0947 \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u093e \\u0935\\u093f\\u092d\\u093e\\u091c\\u0928, \\u092a\\u0924\\u093f-\\u092a\\u0924\\u094d\\u0928\\u0940 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928, \\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0940 \\u0939\\u093e\\u0915\\u093f\\u092e\\u0940, \\u0926\\u094c\\u0930\\u093e, \\u0914\\u0930 \\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0935\\u093f\\u0935\\u093e\\u0939 \\u0935\\u093f\\u091a\\u094d\\u091b\\u0947\\u0926 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642 \\u0647\\u064a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0633\\u0627\\u0639\\u062f \\u0627\\u0644\\u0623\\u0632\\u0648\\u0627\\u062c \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u063a\\u0644\\u0628 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062a\\u064a\\u0633\\u064a\\u0631 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0648\\u062d \\u0648\\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0644\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0644\\u0627\\u064b \\u0645\\u062a\\u0641\\u0642 \\u0639\\u0644\\u064a\\u0647 \\u0628\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0637\\u0631\\u0641\\u064a\\u0646. \\u062a\\u062a\\u064a\\u062d \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0644\\u0644\\u0623\\u0632\\u0648\\u0627\\u062c \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u062e\\u062a\\u0627\\u0631\\u0648\\u0646 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0633\\u0648\\u064a\\u064b\\u0627 \\u0628\\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0648\\u0633\\u064a\\u0637 \\u0645\\u062d\\u0627\\u064a\\u062f \\u0644\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u062c\\u0648\\u0627\\u0646\\u0628 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u0646 \\u0637\\u0644\\u0627\\u0642\\u0647\\u0645\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u062a\\u0642\\u0633\\u064a\\u0645 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0632\\u0648\\u062c\\u064a\\u060c \\u0648\\u062d\\u0636\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644\\u060c \\u0648\\u0627\\u0644\\u0632\\u064a\\u0627\\u0631\\u0627\\u062a\\u060c \\u0648\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0641\\u064a \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642:<\\/p>"}',
                'icon' => NULL,
                'id' => 29,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Divorce Mediation","hi":"\\u0924\\u0932\\u093e\\u0915 \\u0915\\u0940 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0924\\u093e","ar":"\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642"}',
                'parent_category_id' => 4,
                'slug' => 'divorce-mediation-29',
                'updated_at' => '2023-10-10 20:34:36',
            ),
            29 => 
            array (
                'created_at' => '2023-08-08 13:28:13',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Child support mediation is a specialized form of family therapy mediation that focuses specifically on resolving disputes related to child support obligations. It involves parents or guardians working with a trained mediator to negotiate and reach an agreement regarding the financial support of their children following a separation or divorce. Here are key aspects and considerations in child support mediation:<\\/p>","hi":"<p>\\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e\\u093f\\u0924 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0939\\u0948 \\u091c\\u094b \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0939\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u092a\\u0930 \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u093f\\u0924 \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u092f\\u093e \\u0905\\u092d\\u093f\\u092d\\u093e\\u0935\\u0915 \\u0938\\u091c\\u0940\\u0935 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u092a\\u094d\\u0930\\u0936\\u093f\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u093e\\u092e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u090f\\u0915 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u094b \\u0926\\u0930\\u094d\\u0936\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0909\\u0928\\u0915\\u0947 \\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u094b \\u0905\\u0932\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u092f\\u093e \\u0924\\u0932\\u093e\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0926 \\u0905\\u0928\\u0941\\u0938\\u0930\\u0923 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644 \\u0647\\u064a \\u0646\\u0648\\u0639 \\u0645\\u062a\\u062e\\u0635\\u0635 \\u0645\\u0646 \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u062a\\u0631\\u0643\\u0632 \\u0628\\u0634\\u0643\\u0644 \\u062e\\u0627\\u0635 \\u0639\\u0644\\u0649 \\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644. \\u0625\\u0646\\u0647\\u0627 \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0639\\u0645\\u0644 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0648\\u0635\\u064a\\u064a\\u0646 \\u0645\\u0639 \\u0648\\u0633\\u064a\\u0637 \\u0645\\u062f\\u0631\\u0628 \\u0644\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0648\\u0627\\u0644\\u062a\\u0648\\u0635\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u062a\\u0641\\u0627\\u0642 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u0644\\u0623\\u0637\\u0641\\u0627\\u0644\\u0647\\u0645 \\u0628\\u0639\\u062f \\u0627\\u0644\\u0627\\u0646\\u0641\\u0635\\u0627\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0641\\u064a \\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644:<\\/p>"}',
                'icon' => NULL,
                'id' => 30,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Child Support Mediation","hi":"\\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0924\\u093e","ar":"\\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644"}',
                'parent_category_id' => 4,
                'slug' => 'child-support-mediation-30',
                'updated_at' => '2023-10-10 20:31:11',
            ),
            30 => 
            array (
                'created_at' => '2023-08-08 13:53:59',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Child support mediation is a specialized form of family therapy mediation that focuses specifically on resolving disputes related to child support obligations. It involves parents or guardians working with a trained mediator to negotiate and reach an agreement regarding the financial support of their children following a separation or divorce. Here are key aspects and considerations in child support mediation:<\\/p>","hi":"<p>\\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e\\u093f\\u0924 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0939\\u0948 \\u091c\\u094b \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0939\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u092a\\u0930 \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u093f\\u0924 \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u092f\\u093e \\u0905\\u092d\\u093f\\u092d\\u093e\\u0935\\u0915 \\u0938\\u091c\\u0940\\u0935 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u092a\\u094d\\u0930\\u0936\\u093f\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u093e\\u092e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u090f\\u0915 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u094b \\u0926\\u0930\\u094d\\u0936\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0909\\u0928\\u0915\\u0947 \\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u094b \\u0905\\u0932\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u092f\\u093e \\u0924\\u0932\\u093e\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0926 \\u0905\\u0928\\u0941\\u0938\\u0930\\u0923 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644 \\u0647\\u064a \\u0646\\u0648\\u0639 \\u0645\\u062a\\u062e\\u0635\\u0635 \\u0645\\u0646 \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u062a\\u0631\\u0643\\u0632 \\u0628\\u0634\\u0643\\u0644 \\u062e\\u0627\\u0635 \\u0639\\u0644\\u0649 \\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644. \\u0625\\u0646\\u0647\\u0627 \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0639\\u0645\\u0644 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0648\\u0635\\u064a\\u064a\\u0646 \\u0645\\u0639 \\u0648\\u0633\\u064a\\u0637 \\u0645\\u062f\\u0631\\u0628 \\u0644\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0648\\u0627\\u0644\\u062a\\u0648\\u0635\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u062a\\u0641\\u0627\\u0642 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u0644\\u0623\\u0637\\u0641\\u0627\\u0644\\u0647\\u0645 \\u0628\\u0639\\u062f \\u0627\\u0644\\u0627\\u0646\\u0641\\u0635\\u0627\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0641\\u064a \\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644:<\\/p>"}',
                'icon' => NULL,
                'id' => 31,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Child Support Mediation","hi":"\\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0924\\u093e","ar":"\\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644"}',
                'parent_category_id' => 2,
                'slug' => 'child-support-mediation-31',
                'updated_at' => '2023-10-10 20:20:57',
            ),
            31 => 
            array (
                'created_at' => '2023-08-08 14:20:27',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Child support mediation is a specialized form of family therapy mediation that focuses specifically on resolving disputes related to child support obligations. It involves parents or guardians working with a trained mediator to negotiate and reach an agreement regarding the financial support of their children following a separation or divorce. Here are key aspects and considerations in child support mediation:<\\/p>","hi":"<p>\\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e\\u093f\\u0924 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0939\\u0948 \\u091c\\u094b \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0926\\u093e\\u092f\\u093f\\u0924\\u094d\\u0935\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0939\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u092a\\u0930 \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u093f\\u0924 \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u092f\\u093e \\u0905\\u092d\\u093f\\u092d\\u093e\\u0935\\u0915 \\u0938\\u091c\\u0940\\u0935 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u092a\\u094d\\u0930\\u0936\\u093f\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0915\\u093e\\u092e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u090f\\u0915 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u094b \\u0926\\u0930\\u094d\\u0936\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0909\\u0928\\u0915\\u0947 \\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0915\\u094b \\u0905\\u0932\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u092f\\u093e \\u0924\\u0932\\u093e\\u0915 \\u0915\\u0947 \\u092c\\u093e\\u0926 \\u0905\\u0928\\u0941\\u0938\\u0930\\u0923 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u092c\\u093e\\u0932 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644 \\u0647\\u064a \\u0646\\u0648\\u0639 \\u0645\\u062a\\u062e\\u0635\\u0635 \\u0645\\u0646 \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u062a\\u0631\\u0643\\u0632 \\u0628\\u0634\\u0643\\u0644 \\u062e\\u0627\\u0635 \\u0639\\u0644\\u0649 \\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644. \\u0625\\u0646\\u0647\\u0627 \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0639\\u0645\\u0644 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0648\\u0635\\u064a\\u064a\\u0646 \\u0645\\u0639 \\u0648\\u0633\\u064a\\u0637 \\u0645\\u062f\\u0631\\u0628 \\u0644\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0648\\u0627\\u0644\\u062a\\u0648\\u0635\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u062a\\u0641\\u0627\\u0642 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u0644\\u0623\\u0637\\u0641\\u0627\\u0644\\u0647\\u0645 \\u0628\\u0639\\u062f \\u0627\\u0644\\u0627\\u0646\\u0641\\u0635\\u0627\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0641\\u064a \\u0648\\u0633\\u0627\\u0637\\u0629 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0637\\u0641\\u0644:<\\/p>"}',
                'icon' => NULL,
                'id' => 32,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
            'name' => '{"en":"Spousal Support (Alimony)","hi":"\\u091c\\u0940\\u0935\\u0928\\u0938\\u093e\\u0925\\u0940 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 (\\u0917\\u0941\\u091c\\u093c\\u093e\\u0930\\u093e \\u092d\\u0924\\u094d\\u0924\\u093e)","ar":"\\u0627\\u0644\\u0646\\u0641\\u0642\\u0629 \\u0627\\u0644\\u0632\\u0648\\u062c\\u064a\\u0629 (\\u0627\\u0644\\u0646\\u0641\\u0642\\u0629)"}',
                'parent_category_id' => 4,
                'slug' => 'spousal-support-alimony-32',
                'updated_at' => '2023-10-10 20:17:18',
            ),
            32 => 
            array (
                'created_at' => '2023-08-08 14:25:06',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Estate and inheritance disputes involve conflicts and disagreements that arise among beneficiaries, heirs, or other parties related to the distribution of assets and property from a deceased person&#39;s estate. These disputes can occur when there are issues related to the interpretation of wills, trusts, estate plans, or the rightful entitlement to inheritances. Here are key aspects and considerations related to estate and inheritance disputes:<\\/p>","hi":"<p>\\u0906\\u0938\\u094d\\u0924\\u093e\\u0928\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0930\\u093e\\u0938\\u0924 \\u0935\\u093f\\u0935\\u093e\\u0926 \\u0909\\u0928 \\u0938\\u0902\\u0918\\u0930\\u094d\\u0937\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0938\\u0939\\u092e\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0915\\u093f\\u0938\\u0940 \\u092e\\u0943\\u0924 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0915\\u0947 \\u0906\\u0938\\u094d\\u0924\\u093e\\u0928\\u0947 \\u0938\\u0947 \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0914\\u0930 \\u0927\\u0930\\u094b\\u0939\\u0930 \\u0915\\u0947 \\u0935\\u093f\\u0924\\u0930\\u0923 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0909\\u0928 \\u0932\\u093e\\u092d\\u093e\\u0930\\u094d\\u0925\\u093f\\u092f\\u094b\\u0902, \\u0935\\u093e\\u0930\\u093f\\u0938\\u094b\\u0902, \\u092f\\u093e \\u0905\\u0928\\u094d\\u092f \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0935\\u093f\\u0935\\u093e\\u0926 \\u0909\\u0924\\u094d\\u0924\\u093f\\u0937\\u094d\\u0920\\u093f\\u0924 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u092c \\u0935\\u0938\\u0940\\u092f\\u094b\\u0902, \\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938\\u094b\\u0902, \\u0906\\u0938\\u094d\\u0924\\u093e\\u0928\\u093e \\u092f\\u094b\\u091c\\u0928\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u092f\\u093e \\u0935\\u093f\\u0930\\u093e\\u0938\\u0924\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u0935\\u093f\\u0924\\u0930\\u0923 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947 \\u0939\\u094b\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0906\\u0938\\u094d\\u0924\\u093e\\u0928\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0930\\u093e\\u0938\\u0924 \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u062a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0627\\u0644\\u0645\\u064a\\u0631\\u0627\\u062b \\u0648\\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0648\\u0627\\u0644\\u0627\\u062e\\u062a\\u0644\\u0627\\u0641\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0646\\u0634\\u0623 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0641\\u064a\\u062f\\u064a\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0648\\u0631\\u062b\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0627\\u0644\\u0623\\u0635\\u0648\\u0644 \\u0648\\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0645\\u0646 \\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635 \\u0627\\u0644\\u0645\\u062a\\u0648\\u0641\\u0649. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062d\\u062f\\u062b \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0639\\u0646\\u062f\\u0645\\u0627 \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u0642\\u0636\\u0627\\u064a\\u0627 \\u062a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u062a\\u0641\\u0633\\u064a\\u0631 \\u0627\\u0644\\u0648\\u0635\\u0627\\u064a\\u0627\\u060c \\u0627\\u0644\\u0623\\u0648\\u0642\\u0627\\u0641\\u060c \\u062e\\u0637\\u0637 \\u0627\\u0644\\u062a\\u0648\\u0632\\u064a\\u0639\\u060c \\u0623\\u0648 \\u0627\\u0644\\u062d\\u0642 \\u0627\\u0644\\u0645\\u0634\\u0631\\u0648\\u0639 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0631\\u0627\\u062b\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0627\\u0644\\u0645\\u064a\\u0631\\u0627\\u062b \\u0648\\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a:<\\/p>"}',
                'icon' => NULL,
                'id' => 33,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Estate & Inheritance Disputes","hi":"\\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0914\\u0930 \\u0935\\u093f\\u0930\\u093e\\u0938\\u0924 \\u0935\\u093f\\u0935\\u093e\\u0926","ar":"\\u0645\\u0646\\u0627\\u0632\\u0639\\u0627\\u062a \\u0627\\u0644\\u0639\\u0642\\u0627\\u0631\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u064a\\u0631\\u0627\\u062b"}',
                'parent_category_id' => 1,
                'slug' => 'estate-inheritance-disputes-33',
                'updated_at' => '2023-10-10 20:12:10',
            ),
            33 => 
            array (
                'created_at' => '2023-08-08 15:02:47',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Parent-teen mediation is a process designed to help parents and teenagers address conflicts, improve communication, and find mutually acceptable solutions to issues that arise during adolescence. This form of mediation aims to promote healthy relationships, reduce misunderstandings, and enhance cooperation between parents and their teenage children. Here are key aspects and considerations related to parent-teen mediation:<\\/p>","hi":"<p>\\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0926\\u0930\\u0935\\u093e\\u091c\\u0947 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u090f\\u0915 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0938\\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0915\\u093f\\u0936\\u094b\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u0918\\u0930\\u094d\\u0937\\u094b\\u0902 \\u0915\\u093e \\u0938\\u093e\\u092e\\u0928\\u093e \\u0915\\u0930\\u0928\\u0947, \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0938\\u0941\\u0927\\u093e\\u0930\\u0928\\u0947, \\u0914\\u0930 \\u0915\\u093f\\u0936\\u094b\\u0930\\u093e\\u0935\\u0938\\u094d\\u0925\\u093e \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928 \\u0909\\u0924\\u094d\\u092a\\u0928\\u094d\\u0928 \\u0939\\u094b\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964 \\u0907\\u0938 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0938\\u094d\\u0935\\u0938\\u094d\\u0925 \\u0938\\u0902\\u092c\\u0902\\u0927\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u094b\\u0924\\u094d\\u0938\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948, \\u092d\\u094d\\u0930\\u092e\\u094b\\u0902 \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0909\\u0928\\u0915\\u0947 \\u0915\\u093f\\u0936\\u094b\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0938\\u0939\\u092f\\u094b\\u0917 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0928\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0926\\u0930\\u0935\\u093e\\u091c\\u0947 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0631\\u0627\\u0647\\u0642\\u064a\\u0646 \\u0647\\u064a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0645\\u0635\\u0645\\u0645\\u0629 \\u0644\\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0631\\u0627\\u0647\\u0642\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0635\\u0631\\u0627\\u0639\\u0627\\u062a\\u060c \\u0648\\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644\\u060c \\u0648\\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u062d\\u0644\\u0627\\u064b \\u0645\\u0642\\u0628\\u0648\\u0644\\u0627\\u064b \\u0628\\u0627\\u0644\\u062a\\u0631\\u0627\\u0636\\u064a \\u0644\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0646\\u0634\\u0623 \\u062e\\u0644\\u0627\\u0644 \\u0645\\u0631\\u062d\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0631\\u0627\\u0647\\u0642\\u0629. \\u064a\\u0647\\u062f\\u0641 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0646\\u0648\\u0639 \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0625\\u0644\\u0649 \\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629\\u060c \\u0648\\u062a\\u0642\\u0644\\u064a\\u0644 \\u0627\\u0644\\u0633\\u0648\\u0621 \\u0641\\u0647\\u0645\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0648\\u0646 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0648\\u0623\\u0628\\u0646\\u0627\\u0626\\u0647\\u0645 \\u0627\\u0644\\u0645\\u0631\\u0627\\u0647\\u0642\\u064a\\u0646. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0631\\u0627\\u0647\\u0642\\u064a\\u0646:<\\/p>"}',
                'icon' => NULL,
                'id' => 34,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Parent-Teen Mediation","hi":"\\u0905\\u092d\\u093f\\u092d\\u093e\\u0935\\u0915-\\u0915\\u093f\\u0936\\u094b\\u0930 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0924\\u093e","ar":"\\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0631\\u0627\\u0647\\u0642\\u064a\\u0646"}',
                'parent_category_id' => 4,
                'slug' => 'parent-teen-mediation-34',
                'updated_at' => '2023-10-10 20:07:57',
            ),
            34 => 
            array (
                'created_at' => '2023-08-08 15:13:31',
                'deleted_at' => NULL,
                'description' => '{"hi":"<p>\\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0902\\u0935\\u093f\\u0927\\u093e\\u0928\\u093f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u094b \\u0938\\u0942\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u090f\\u0915 \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0915\\u0947 \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u094b \\u0938\\u092e\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u0948\\u0938\\u0947 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0915\\u0940 \\u0938\\u094d\\u0935\\u0924\\u0902\\u0924\\u094d\\u0930\\u0924\\u093e, \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e, \\u0928\\u094d\\u092f\\u093e\\u092f \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e, \\u0914\\u0930 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0905\\u0935\\u0938\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0928 \\u0909\\u092a\\u092f\\u094b\\u0917\\u0964 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0938\\u092e\\u091d\\u0928\\u093e \\u0914\\u0930 \\u0909\\u0928\\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u093e, \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924, \\u0938\\u092e\\u093e\\u0935\\u0947\\u0936\\u0940, \\u0914\\u0930 \\u0906\\u0926\\u0930\\u0923\\u0940\\u092f \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0935\\u093e\\u0924\\u093e\\u0935\\u0930\\u0923 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u0936\\u094d\\u0930\\u0947\\u0923\\u093f\\u092f\\u093e\\u0901 \\u0939\\u0948\\u0902:<\\/p>","ar":"<p>\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u062a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0633\\u062a\\u0648\\u0631\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0645\\u0646\\u0648\\u062d\\u0629 \\u0644\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0641\\u064a \\u0627\\u0644\\u0628\\u064a\\u0626\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629. \\u062a\\u0634\\u0645\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u062c\\u0648\\u0627\\u0646\\u0628 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0645\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0637\\u0627\\u0644\\u0628\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631 \\u0648\\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0633\\u0648\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0645\\u062a\\u0633\\u0627\\u0648\\u064a \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629. \\u0641\\u0647\\u0645 \\u0648\\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645 \\u0628\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0623\\u0645\\u0631 \\u0623\\u0633\\u0627\\u0633\\u064a \\u0644\\u0625\\u064a\\u062c\\u0627\\u062f \\u0628\\u064a\\u0626\\u0629 \\u062a\\u0639\\u0644\\u0645 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0634\\u0627\\u0645\\u0644\\u0629 \\u0648\\u0645\\u062d\\u062a\\u0631\\u0645\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u0641\\u0626\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628:<\\/p>"}',
                'icon' => NULL,
                'id' => 35,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Student Rights","hi":"\\u091b\\u093e\\u0924\\u094d\\u0930 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930","ar":"\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0637\\u0627\\u0644\\u0628"}',
                'parent_category_id' => 5,
                'slug' => 'student-rights-35',
                'updated_at' => '2023-10-10 20:03:47',
            ),
            35 => 
            array (
                'created_at' => '2023-08-08 15:15:50',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Special education therapy encompasses the legal framework and regulations governing the rights, services, and accommodations provided to students with disabilities in educational settings. It ensures that students with disabilities have equal access to a quality education and the necessary support to succeed academically and socially. Special education therapy is primarily governed by federal therapys and regulations, with some variations at the state level. Here are key aspects and components of special education therapy:<\\/p>","hi":"<p>\\u0935\\u093f\\u0936\\u0947\\u0937 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f\\u0940 \\u092a\\u0930\\u093f\\u0926\\u0943\\u0936\\u094d\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0915\\u0932\\u093e\\u0902\\u0917 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u094b \\u092a\\u094d\\u0930\\u0926\\u0924\\u094d\\u0924 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930, \\u0938\\u0947\\u0935\\u093e\\u090f\\u0902 \\u0914\\u0930 \\u0906\\u0930\\u093e\\u092e\\u0917\\u093e\\u0939\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0922\\u093e\\u0902\\u091a\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u094b \\u0938\\u092e\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0935\\u093f\\u0915\\u0932\\u093e\\u0902\\u0917 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0909\\u091a\\u094d\\u091a \\u0917\\u0941\\u0923\\u0935\\u0924\\u094d\\u0924\\u093e \\u0935\\u093e\\u0932\\u0940 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0930\\u094d\\u0925\\u0940 \\u0914\\u0930 \\u0938\\u093e\\u092e\\u093e\\u091c\\u093f\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u092b\\u0932 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u092c\\u0930\\u093e\\u092c\\u0930 \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0939\\u0948\\u0964 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u094b \\u092e\\u0941\\u0916\\u094d\\u092f \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u0902\\u0918\\u0940\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0930\\u093e\\u091c\\u094d\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u0915\\u0941\\u091b \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928\\u0924\\u093e\\u090f\\u0901 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0918\\u091f\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u064a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0643\\u0645 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0648\\u0627\\u0644\\u0625\\u0633\\u0643\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0642\\u062f\\u0645\\u0629 \\u0644\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0630\\u0648\\u064a \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0628\\u064a\\u0626\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629. \\u0625\\u0646\\u0647 \\u064a\\u0636\\u0645\\u0646 \\u0623\\u0646 \\u0644\\u062f\\u0649 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0630\\u0648\\u0648 \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0645\\u062a\\u0633\\u0627\\u0648\\u064a \\u0625\\u0644\\u0649 \\u062a\\u0639\\u0644\\u064a\\u0645 \\u0630\\u064a \\u062c\\u0648\\u062f\\u0629 \\u0648\\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0636\\u0631\\u0648\\u0631\\u064a \\u0644\\u0644\\u0646\\u062c\\u0627\\u062d \\u0627\\u0644\\u0623\\u0643\\u0627\\u062f\\u064a\\u0645\\u064a \\u0648\\u0627\\u0644\\u0627\\u062c\\u062a\\u0645\\u0627\\u0639\\u064a. \\u064a\\u062a\\u0645 \\u062a\\u062d\\u0643\\u0645 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0642\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0648\\u0644 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0641\\u064a\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629\\u060c \\u0645\\u0639 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0627\\u062e\\u062a\\u0644\\u0627\\u0641\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0643\\u0648\\u0646\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u062e\\u0627\\u0635:<\\/p>"}',
                'icon' => NULL,
                'id' => 36,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Special Education Therapy","hi":"\\u0935\\u093f\\u0936\\u0947\\u0937 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u062e\\u0627\\u0635"}',
                'parent_category_id' => 5,
                'slug' => 'vashashha-shakashha-kanana-36',
                'updated_at' => '2023-10-10 19:58:50',
            ),
            36 => 
            array (
                'created_at' => '2023-08-08 15:22:23',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Civil rights and equal opportunity are fundamental principles that ensure fair and equal treatment for all individuals, regardless of their race, color, sex, religion, national origin, disability, or other protected characteristics. In the context of education and society, civil rights and equal opportunity therapys are enacted to prevent discrimination, promote diversity, and create inclusive environments that respect the rights and dignity of every individual. Here are key aspects and considerations related to civil rights and equal opportunity:<\\/p>","hi":"<p>\\u091b\\u093e\\u0924\\u094d\\u0930 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0939\\u0948\\u0902, \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093f \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0916\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948 \\u0914\\u0930 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u0940\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u092a\\u094d\\u0930\\u092f\\u094b\\u0917 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u091c\\u0948\\u0938\\u0947-\\u091c\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u094c\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915\\u0940 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915 \\u0938\\u092e\\u093e\\u0939\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948, \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0915\\u093e \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939\\u0923, \\u092d\\u0902\\u0921\\u093e\\u0930\\u0923, \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u092c\\u0922\\u093c\\u0924\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947 \\u092c\\u0928 \\u0930\\u0939\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0644\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0647\\u064a \\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u062d\\u0627\\u0633\\u0645\\u0629 \\u0641\\u064a \\u0645\\u062c\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u060c \\u062d\\u064a\\u062b \\u062a\\u0636\\u0645\\u0646 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0645\\u062d\\u0645\\u064a\\u0629 \\u0648\\u062a\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0628\\u0634\\u0643\\u0644 \\u0645\\u0633\\u0624\\u0648\\u0644 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629. \\u0645\\u0639 \\u062a\\u0643\\u0627\\u0645\\u0644 \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627 \\u0623\\u0643\\u062b\\u0631 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629\\u060c \\u0623\\u0635\\u0628\\u062d\\u062a \\u062c\\u0645\\u0639 \\u0648\\u062a\\u062e\\u0632\\u064a\\u0646 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0642\\u0636\\u0627\\u064a\\u0627 \\u0645\\u062a\\u0632\\u0627\\u064a\\u062f\\u0629 \\u0627\\u0644\\u0623\\u0647\\u0645\\u064a\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a:<\\/p>"}',
                'icon' => NULL,
                'id' => 37,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Civil Rights and Equal Opportunity","hi":"\\u0928\\u093e\\u0917\\u0930\\u093f\\u0915 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0938\\u092e\\u093e\\u0928 \\u0905\\u0935\\u0938\\u0930","ar":"\\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0645\\u062f\\u0646\\u064a\\u0629 \\u0648\\u062a\\u0643\\u0627\\u0641\\u0624 \\u0627\\u0644\\u0641\\u0631\\u0635"}',
                'parent_category_id' => 5,
                'slug' => 'nagaraka-athhakara-oura-samana-avasara-37',
                'updated_at' => '2023-10-10 19:55:23',
            ),
            37 => 
            array (
                'created_at' => '2023-08-08 15:23:09',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Student privacy and data protection are critical considerations in education, ensuring that students&#39; personal information is safeguarded and used responsibly by educational institutions. As technology becomes more integrated into educational practices, the collection, storage, and use of student data have become increasingly important issues. Here are key aspects and considerations related to student privacy and data protection:<\\/p>","hi":"<p>\\u091b\\u093e\\u0924\\u094d\\u0930 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0939\\u0948\\u0902, \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u093f \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0916\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948 \\u0914\\u0930 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u0940\\u092a\\u0942\\u0930\\u094d\\u0935\\u0915 \\u092a\\u094d\\u0930\\u092f\\u094b\\u0917 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u091c\\u0948\\u0938\\u0947-\\u091c\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u094c\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915\\u0940 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915 \\u0938\\u092e\\u093e\\u0939\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948, \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0915\\u093e \\u0938\\u0902\\u0917\\u094d\\u0930\\u0939\\u0923, \\u092d\\u0902\\u0921\\u093e\\u0930\\u0923, \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u092c\\u0922\\u093c\\u0924\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947 \\u092c\\u0928 \\u0930\\u0939\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0644\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0647\\u064a \\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u062d\\u0627\\u0633\\u0645\\u0629 \\u0641\\u064a \\u0645\\u062c\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u060c \\u062d\\u064a\\u062b \\u062a\\u0636\\u0645\\u0646 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0645\\u062d\\u0645\\u064a\\u0629 \\u0648\\u062a\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0628\\u0634\\u0643\\u0644 \\u0645\\u0633\\u0624\\u0648\\u0644 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629. \\u0645\\u0639 \\u062a\\u0643\\u0627\\u0645\\u0644 \\u0627\\u0644\\u062a\\u0643\\u0646\\u0648\\u0644\\u0648\\u062c\\u064a\\u0627 \\u0623\\u0643\\u062b\\u0631 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629\\u060c \\u0623\\u0635\\u0628\\u062d\\u062a \\u062c\\u0645\\u0639 \\u0648\\u062a\\u062e\\u0632\\u064a\\u0646 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0642\\u0636\\u0627\\u064a\\u0627 \\u0645\\u062a\\u0632\\u0627\\u064a\\u062f\\u0629 \\u0627\\u0644\\u0623\\u0647\\u0645\\u064a\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a:<\\/p>"}',
                'icon' => NULL,
                'id' => 38,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Student Privacy and Data Protection","hi":"\\u091b\\u093e\\u0924\\u094d\\u0930 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0921\\u0947\\u091f\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e","ar":"\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a"}',
                'parent_category_id' => 5,
                'slug' => 'chhatara-gapanayata-oura-data-sarakashha-38',
                'updated_at' => '2023-10-10 19:52:27',
            ),
            38 => 
            array (
                'created_at' => '2023-08-08 15:23:59',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>Religious freedom and expression are fundamental rights that protect individuals&#39; ability to practice their religion, hold religious beliefs, and express those beliefs without interference or discrimination. In the context of education and society, religious freedom encompasses a range of rights and considerations related to individuals&#39; beliefs, practices, and interactions within educational institutions and public spaces. Here are key aspects and considerations related to religious freedom and expression:<\\/p>","hi":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>\\u0927\\u093e\\u0930\\u094d\\u092e\\u093f\\u0915 \\u0938\\u094d\\u0935\\u0924\\u0902\\u0924\\u094d\\u0930\\u0924\\u093e \\u0914\\u0930 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0935\\u0939 \\u092e\\u094c\\u0932\\u093f\\u0915 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0927\\u0930\\u094d\\u092e \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u0928 \\u0915\\u0940 \\u0915\\u094d\\u0937\\u092e\\u0924\\u093e, \\u0927\\u093e\\u0930\\u094d\\u092e\\u093f\\u0915 \\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938\\u094b\\u0902 \\u0915\\u094b \\u0927\\u093e\\u0930\\u0923 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0909\\u0928 \\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938\\u094b\\u0902 \\u0915\\u094b \\u092c\\u093f\\u0928\\u093e \\u0939\\u0938\\u094d\\u0924\\u0915\\u094d\\u0937\\u0947\\u092a \\u092f\\u093e \\u092d\\u0947\\u0926\\u092d\\u093e\\u0935 \\u0915\\u0947 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0938\\u092e\\u093e\\u091c \\u0915\\u0947 \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u092e\\u0947\\u0902, \\u0927\\u093e\\u0930\\u094d\\u092e\\u093f\\u0915 \\u0938\\u094d\\u0935\\u0924\\u0902\\u0924\\u094d\\u0930\\u0924\\u093e \\u090f\\u0915 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938\\u094b\\u0902, \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902, \\u0914\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u0923 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0909\\u0928\\u0915\\u0947 \\u0935\\u093f\\u0936\\u094d\\u0935\\u093e\\u0938\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u092d\\u094d\\u092f\\u093e\\u0938\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0936\\u094d\\u0930\\u0947\\u0923\\u0940 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0927\\u093e\\u0930\\u094d\\u092e\\u093f\\u0915 \\u0938\\u094d\\u0935\\u0924\\u0902\\u0924\\u094d\\u0930\\u0924\\u093e \\u0914\\u0930 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062f\\u064a\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631 \\u0647\\u064a \\u062d\\u0642\\u0648\\u0642 \\u0623\\u0633\\u0627\\u0633\\u064a\\u0629 \\u062a\\u062d\\u0645\\u064a \\u0642\\u062f\\u0631\\u0629 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0639\\u0644\\u0649 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u062f\\u064a\\u0627\\u0646\\u062a\\u0647\\u0645\\u060c \\u0648\\u0627\\u0639\\u062a\\u0646\\u0627\\u0642 \\u0627\\u0644\\u0645\\u0639\\u062a\\u0642\\u062f\\u0627\\u062a \\u0627\\u0644\\u062f\\u064a\\u0646\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631 \\u0639\\u0646 \\u062a\\u0644\\u0643 \\u0627\\u0644\\u0645\\u0639\\u062a\\u0642\\u062f\\u0627\\u062a \\u062f\\u0648\\u0646 \\u062a\\u062f\\u062e\\u0644 \\u0623\\u0648 \\u062a\\u0645\\u064a\\u064a\\u0632. \\u0641\\u064a \\u0633\\u064a\\u0627\\u0642 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0648\\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u060c \\u062a\\u0634\\u0645\\u0644 \\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062f\\u064a\\u0627\\u0646\\u0629 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0645\\u0639\\u062a\\u0642\\u062f\\u0627\\u062a \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a\\u0647\\u0645\\u060c \\u0648\\u062a\\u0641\\u0627\\u0639\\u0644\\u0627\\u062a\\u0647\\u0645 \\u062f\\u0627\\u062e\\u0644 \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0645\\u0627\\u0643\\u0646 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062f\\u064a\\u0627\\u0646\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631:<\\/p>"}',
                'icon' => NULL,
                'id' => 39,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Religious Freedom and Expression","hi":"\\u0927\\u093e\\u0930\\u094d\\u092e\\u093f\\u0915 \\u0938\\u094d\\u0935\\u0924\\u0902\\u0924\\u094d\\u0930\\u0924\\u093e \\u0914\\u0930 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f","ar":"\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062f\\u064a\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631"}',
                'parent_category_id' => 1,
                'slug' => 'thharamaka-savatatarata-oura-abhavayakata-39',
                'updated_at' => '2023-10-10 19:48:34',
            ),
            39 => 
            array (
                'created_at' => '2023-08-08 15:24:48',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Curriculum and instruction are central components of the educational process, encompassing the design, delivery, and assessment of educational content and learning experiences. A well-designed curriculum guides what students learn and how they learn it, while effective instruction involves teaching methods, strategies, and resources that facilitate meaningful learning. Here are key aspects and considerations related to curriculum and instruction in education:<\\/p>","hi":"<p>\\u092a\\u093e\\u0920\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e \\u0914\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u0923 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u0940\\u092f \\u0918\\u091f\\u0915 \\u0939\\u0948\\u0902, \\u091c\\u094b \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0938\\u093e\\u092e\\u0917\\u094d\\u0930\\u0940 \\u0914\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0905\\u0928\\u0941\\u092d\\u0935 \\u0915\\u0947 \\u0921\\u093f\\u091c\\u093e\\u0907\\u0928, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u0914\\u0930 \\u092e\\u0942\\u0932\\u094d\\u092f\\u093e\\u0902\\u0915\\u0928 \\u0915\\u094b \\u0938\\u092e\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u090f\\u0915 \\u0905\\u091a\\u094d\\u091b\\u0947 \\u0921\\u093f\\u091c\\u093e\\u0907\\u0928 \\u0915\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u092a\\u093e\\u0920\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e \\u092f\\u0939 \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0915\\u094d\\u092f\\u093e \\u0938\\u0940\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0935\\u0947 \\u092f\\u0939 \\u0915\\u0948\\u0938\\u0947 \\u0938\\u0940\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u092c\\u0915\\u093f \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u0940 \\u0936\\u093f\\u0915\\u094d\\u0937\\u0923 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0909\\u092a\\u093e\\u092f, \\u0930\\u0923\\u0928\\u0940\\u0924\\u093f\\u092f\\u094b\\u0902, \\u0914\\u0930 \\u0938\\u0902\\u0938\\u093e\\u0927\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0905\\u0930\\u094d\\u0925\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u094b \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u092c\\u0928\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u092e\\u0947\\u0902 \\u092a\\u093e\\u0920\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e \\u0914\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u0923 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u0627\\u0644\\u0645\\u0646\\u0647\\u062c \\u0648\\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0647\\u0645\\u0627 \\u0639\\u0646\\u0635\\u0631\\u0627\\u0646 \\u0623\\u0633\\u0627\\u0633\\u064a\\u0627\\u0646 \\u0641\\u064a \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629\\u060c \\u062d\\u064a\\u062b \\u064a\\u062a\\u0636\\u0645\\u0646\\u0627\\u0646 \\u062a\\u0635\\u0645\\u064a\\u0645 \\u0627\\u0644\\u0645\\u062d\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645\\u0647 \\u0648\\u062a\\u0642\\u064a\\u064a\\u0645\\u0647 \\u0648\\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u062a\\u0639\\u0644\\u0645. \\u0627\\u0644\\u0645\\u0646\\u0647\\u062c \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645 \\u0628\\u0634\\u0643\\u0644 \\u062c\\u064a\\u062f \\u064a\\u0648\\u062c\\u0647 \\u0645\\u0627 \\u064a\\u062a\\u0639\\u0644\\u0645\\u0647 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0639\\u0644\\u0645\\u0647\\u0645\\u060c \\u0641\\u064a \\u062d\\u064a\\u0646 \\u0623\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0641\\u0639\\u0627\\u0644 \\u064a\\u0634\\u0645\\u0644 \\u0623\\u0633\\u0627\\u0644\\u064a\\u0628 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0633 \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u0627\\u062a\\u064a\\u062c\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u0631\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0633\\u0647\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0644\\u0645 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0639. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0645\\u0646\\u0647\\u062c \\u0648\\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0641\\u064a \\u0645\\u062c\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645:<\\/p>"}',
                'icon' => NULL,
                'id' => 40,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Curriculum and Instruction","hi":"\\u092a\\u093e\\u0920\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e \\u0914\\u0930 \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936","ar":"\\u0627\\u0644\\u0645\\u0646\\u0627\\u0647\\u062c \\u0648\\u0637\\u0631\\u0642 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0633"}',
                'parent_category_id' => 5,
                'slug' => 'pathayakarama-oura-narathasha-40',
                'updated_at' => '2023-10-10 19:35:14',
            ),
            40 => 
            array (
                'created_at' => '2023-08-08 15:27:02',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Higher education therapy encompasses the legal framework that governs colleges and universities, as well as the rights, responsibilities, and regulations that apply to students, faculty, administrators, and other stakeholders within higher education institutions. This area of therapy covers a wide range of issues that impact higher education, from admissions and academic programs to student rights and campus safety. Here are key aspects and considerations related to higher education therapy:<\\/p>","hi":"<p>\\u0909\\u091a\\u094d\\u091a\\u0924\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u0928 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0942\\u0939 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u0915\\u0949\\u0932\\u0947\\u091c\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0936\\u094d\\u0935\\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0938\\u093e\\u0925 \\u0939\\u0940 \\u0909\\u091a\\u094d\\u091a\\u0924\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902, \\u0936\\u093f\\u0915\\u094d\\u0937\\u0915\\u094b\\u0902, \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0915\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0939\\u093f\\u0924\\u0927\\u093e\\u0930\\u0915\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930, \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u093e\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0938\\u092e\\u093e\\u092f\\u094b\\u091c\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0909\\u091a\\u094d\\u091a\\u0924\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u092a\\u0930 \\u0905\\u0938\\u0930 \\u0921\\u093e\\u0932\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u0915\\u0908 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0915\\u0935\\u0930 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u0948\\u0938\\u0947 \\u092a\\u094d\\u0930\\u0935\\u0947\\u0936 \\u0914\\u0930 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0915\\u093e\\u0930\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e \\u0938\\u0947 \\u0932\\u0947\\u0915\\u0930 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0915\\u0948\\u092e\\u094d\\u092a\\u0938 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0909\\u091a\\u094d\\u091a\\u0924\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0926\\u093f\\u092f\\u093e \\u0917\\u092f\\u093e \\u0939\\u0948:<\\/p>","ar":"<p>\\u062a\\u0634\\u0645\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0627\\u0644\\u0630\\u064a \\u064a\\u062d\\u0643\\u0645 \\u0627\\u0644\\u0643\\u0644\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u062c\\u0627\\u0645\\u0639\\u0627\\u062a\\u060c \\u0628\\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0646\\u0637\\u0628\\u0642 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u0623\\u0639\\u0636\\u0627\\u0621 \\u0647\\u064a\\u0626\\u0629 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0633 \\u0648\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0646 \\u0648\\u0623\\u0635\\u062d\\u0627\\u0628 \\u0627\\u0644\\u0645\\u0635\\u0644\\u062d\\u0629 \\u0627\\u0644\\u0622\\u062e\\u0631\\u064a\\u0646 \\u062f\\u0627\\u062e\\u0644 \\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a. \\u064a\\u063a\\u0637\\u064a \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0624\\u062b\\u0631 \\u0641\\u064a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a\\u060c \\u0628\\u062f\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0642\\u0628\\u0648\\u0644 \\u0648\\u0627\\u0644\\u0628\\u0631\\u0627\\u0645\\u062c \\u0627\\u0644\\u0623\\u0643\\u0627\\u062f\\u064a\\u0645\\u064a\\u0629 \\u0625\\u0644\\u0649 \\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u062d\\u0631\\u0645 \\u0627\\u0644\\u062c\\u0627\\u0645\\u0639\\u064a. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a:<\\/p>"}',
                'icon' => NULL,
                'id' => 41,
                'image' => NULL,
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Advertising Therapy","hi":"\\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646"}',
                'parent_category_id' => 5,
                'slug' => 'vajaniapana-kanana-41',
                'updated_at' => '2023-10-10 19:26:05',
            ),
            41 => 
            array (
                'created_at' => '2023-11-03 16:10:30',
                'deleted_at' => '2023-11-03 16:11:55',
                'description' => '{"en":"\\"This is an example text used in the printing and writing industry. These sentences have no meaning. 122\\"","hi":"\\u092f\\u0939 \\u090f\\u0915 \\u0909\\u0926\\u093e\\u0939\\u0930\\u0923 \\u092a\\u093e\\u0920 \\u0939\\u0948 \\u091c\\u094b \\u092a\\u094d\\u0930\\u093f\\u0902\\u091f\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u0932\\u0947\\u0916\\u0928 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0935\\u093e\\u0915\\u094d\\u092f \\u0905\\u0930\\u094d\\u0925\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u0948\\u0964","ar":"\\u092f\\u0939 \\u090f\\u0915 \\u0909\\u0926\\u093e\\u0939\\u0930\\u0923 \\u092a\\u093e\\u0920 \\u0939\\u0948 \\u091c\\u094b \\u092a\\u094d\\u0930\\u093f\\u0902\\u091f\\u093f\\u0902\\u0917 \\u0914\\u0930 \\u0932\\u0947\\u0916\\u0928 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092e\\u0947\\u0902 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0935\\u093e\\u0915\\u094d\\u092f \\u0905\\u0930\\u094d\\u0925\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u0948\\u0964"}',
                'icon' => NULL,
                'id' => 42,
                'image' => '/images/therapist_categories/6544d5265cd5d.png',
                'is_active' => 1,
                'is_featured' => 0,
                'name' => '{"en":"Religious Freedom and Expression","hi":"\\u0927\\u093e\\u0930\\u094d\\u092e\\u093f\\u0915 \\u0938\\u094d\\u0935\\u0924\\u0902\\u0924\\u094d\\u0930\\u0924\\u093e \\u0914\\u0930 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f","ar":"\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062f\\u064a\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631"}',
                'parent_category_id' => 2,
                'slug' => 'religious-freedom-and-expression-42',
                'updated_at' => '2023-11-03 16:11:55',
            ),
        ));
        
        
    }
}